/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo.bg;

import com.kennycason.kumo.bg.Background;
import com.kennycason.kumo.bg.RectangleBackground;
import com.kennycason.kumo.collide.Collidable;
import com.kennycason.kumo.image.CollisionRaster;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class PixelBoundryBackground
implements Background {
    private final CollisionRaster collisionRaster;
    private final RectangleBackground rectangleBackground;

    public PixelBoundryBackground(InputStream imageInputStream) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(imageInputStream);
        this.collisionRaster = new CollisionRaster(bufferedImage);
        this.rectangleBackground = new RectangleBackground(new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight()));
    }

    public PixelBoundryBackground(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public PixelBoundryBackground(String filepath) throws IOException {
        this(new File(filepath));
    }

    @Override
    public boolean isInBounds(Collidable collidable) {
        if (!this.rectangleBackground.isInBounds(collidable)) {
            return false;
        }
        Point position = collidable.getPosition();
        int startX = Math.max(position.x, 0);
        int endX = Math.min(position.x + collidable.getDimension().width, this.collisionRaster.getDimension().width);
        int startY = Math.max(position.y, 0);
        int endY = Math.min(position.y + collidable.getDimension().height, this.collisionRaster.getDimension().height);
        for (int y = startY; y < endY; ++y) {
            for (int x = startX; x < endX; ++x) {
                if (!this.collisionRaster.isTransparent(x, y) || collidable.getCollisionRaster().isTransparent(x - position.x, y - position.y)) continue;
                return false;
            }
        }
        return true;
    }
}

