/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo.bg;

import com.kennycason.kumo.bg.Background;
import com.kennycason.kumo.collide.Collidable;
import java.awt.Dimension;
import java.awt.Point;

public class RectangleBackground
implements Background {
    private static final Point ZERO = new Point(0, 0);
    private final Point position;
    private final Dimension dimension;

    public RectangleBackground(Dimension dimension) {
        this(ZERO, dimension);
    }

    public RectangleBackground(Point position, Dimension dimension) {
        this.position = position;
        this.dimension = dimension;
    }

    @Override
    public boolean isInBounds(Collidable collidable) {
        Point position = collidable.getPosition();
        return position.x >= this.position.x && position.x + collidable.getDimension().width < this.position.x + this.dimension.width && position.y >= this.position.y && position.y + collidable.getDimension().height < this.position.y + this.dimension.height;
    }

    public String toString() {
        return "RectangleBackground [x=" + this.position.x + ", y=" + this.position.y + ", width=" + this.dimension.width + ", height=" + this.dimension.height + "]";
    }
}

