/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo.collide.checkers;

import com.kennycason.kumo.collide.Collidable;
import com.kennycason.kumo.collide.checkers.CollisionChecker;
import com.kennycason.kumo.collide.checkers.RectangleCollisionChecker;
import com.kennycason.kumo.image.CollisionRaster;
import java.awt.Point;

public class RectanglePixelCollisionChecker
implements CollisionChecker {
    private static final RectangleCollisionChecker RECTANGLE_COLLISION_CHECKER = new RectangleCollisionChecker();

    @Override
    public boolean collide(Collidable collidable, Collidable collidable2) {
        if (!RECTANGLE_COLLISION_CHECKER.collide(collidable, collidable2)) {
            return false;
        }
        Point position = collidable.getPosition();
        Point position2 = collidable2.getPosition();
        CollisionRaster collisionRaster = collidable.getCollisionRaster();
        CollisionRaster collisionRaster2 = collidable2.getCollisionRaster();
        int startX = Math.max(position.x, position2.x);
        int endX = Math.min(position.x + collidable.getDimension().width, position2.x + collidable2.getDimension().width);
        int startY = Math.max(position.y, position2.y);
        int endY = Math.min(position.y + collidable.getDimension().height, position2.y + collidable2.getDimension().height);
        for (int y = startY; y < endY; ++y) {
            for (int x = startX; x < endX; ++x) {
                if (collisionRaster2.isTransparent(x - position2.x, y - position2.y) || collisionRaster.isTransparent(x - position.x, y - position.y)) continue;
                return true;
            }
        }
        return false;
    }
}

