/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo.image;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;

public class CollisionRaster {
    private final int[][] data;
    private final Dimension dimension;

    public CollisionRaster(BufferedImage bufferedImage) {
        this.dimension = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
        this.data = new int[this.dimension.width][this.dimension.height];
        for (int y = 0; y < this.dimension.height; ++y) {
            for (int x = 0; x < this.dimension.width; ++x) {
                this.data[x][y] = bufferedImage.getRGB(x, y);
            }
        }
    }

    public CollisionRaster(Dimension dimension) {
        this.dimension = dimension;
        this.data = new int[dimension.width][dimension.height];
    }

    public int getRGB(int x, int y) {
        return this.data[x][y];
    }

    public void setRGB(int x, int y, int rgb) {
        this.data[x][y] = rgb;
    }

    public void mask(CollisionRaster collisionRaster, Point point) {
        int maxHeight = Math.min(point.y + collisionRaster.getDimension().height, this.dimension.height);
        int maxWidth = Math.min(point.x + collisionRaster.getDimension().width, this.dimension.width);
        int offY = point.y;
        int offY2 = 0;
        while (offY < maxHeight) {
            int offX = point.x;
            int offX2 = 0;
            while (offX < maxWidth) {
                if (!collisionRaster.isTransparent(offX2, offY2)) {
                    this.data[offX][offY] = collisionRaster.getRGB(offX2, offY2);
                }
                ++offX;
                ++offX2;
            }
            ++offY;
            ++offY2;
        }
    }

    public boolean isTransparent(int x, int y) {
        return (this.data[x][y] & 0xFF000000) == 0;
    }

    public Dimension getDimension() {
        return this.dimension;
    }
}

