/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo.padding;

import com.kennycason.kumo.Word;
import com.kennycason.kumo.image.CollisionRaster;
import com.kennycason.kumo.padding.Padder;
import com.kennycason.kumo.padding.RectanglePadder;
import java.awt.Color;
import java.awt.Point;
import java.util.HashSet;

public class WordPixelPadder
implements Padder {
    private static final Color PAD_COLOR = Color.BLACK;
    private RectanglePadder rectanglePadder = new RectanglePadder();

    @Override
    public void pad(Word word, int padding) {
        if (padding <= 0) {
            return;
        }
        this.rectanglePadder.pad(word, padding);
        CollisionRaster collisionRaster = word.getCollisionRaster();
        HashSet<Point> toPad = new HashSet<Point>();
        int width = collisionRaster.getDimension().width;
        int height = collisionRaster.getDimension().height;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (!this.shouldPad(collisionRaster, x, y, padding)) continue;
                toPad.add(new Point(x, y));
            }
        }
        for (Point padPoint : toPad) {
            collisionRaster.setRGB(padPoint.x, padPoint.y, PAD_COLOR.getRGB());
        }
    }

    private boolean shouldPad(CollisionRaster collisionRaster, int cx, int cy, int padding) {
        if (!collisionRaster.isTransparent(cx, cy)) {
            return false;
        }
        for (int y = cy - padding; y <= cy + padding; ++y) {
            for (int x = cx - padding; x <= cx + padding; ++x) {
                if (x == cx && y == cy || !this.inBounds(collisionRaster, x, y) || collisionRaster.isTransparent(x, y)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean inBounds(CollisionRaster collisionRaster, int x, int y) {
        return x >= 0 && y >= 0 && x < collisionRaster.getDimension().width && y < collisionRaster.getDimension().height;
    }
}

