/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.properties;

import com.lazerycode.jmeter.properties.ConfigurationFiles;
import com.lazerycode.jmeter.properties.ReservedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import org.eclipse.aether.artifact.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesFile.class);
    private Properties properties;

    public PropertiesFile() {
        this.properties = new Properties();
    }

    public PropertiesFile(File propertiesFile) throws com.lazerycode.jmeter.exceptions.IOException {
        this.properties = this.loadPropertiesFile(propertiesFile);
    }

    public PropertiesFile(Artifact jmeterConfigArtifact, ConfigurationFiles jMeterPropertiesFile) throws com.lazerycode.jmeter.exceptions.IOException {
        Properties defaultPropertySet = new Properties();
        if (null != jmeterConfigArtifact && jMeterPropertiesFile.createFileIfItDoesNotExist()) {
            try {
                JarFile propertyJar = new JarFile(jmeterConfigArtifact.getFile());
                try (InputStream sourceFile = propertyJar.getInputStream(propertyJar.getEntry("bin/" + jMeterPropertiesFile.getFilename()));){
                    defaultPropertySet.load(sourceFile);
                }
            }
            catch (IOException ex) {
                throw new com.lazerycode.jmeter.exceptions.IOException(ex.getMessage(), ex);
            }
        }
        this.properties = defaultPropertySet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadPropertiesFile(File propertiesFile) throws com.lazerycode.jmeter.exceptions.IOException {
        try (FileInputStream propertiesFileInputStream = new FileInputStream(propertiesFile);){
            Properties loadedProperties = new Properties();
            loadedProperties.load(propertiesFileInputStream);
            Properties properties = loadedProperties;
            return properties;
        }
        catch (IOException e) {
            throw new com.lazerycode.jmeter.exceptions.IOException(e.getMessage(), e);
        }
    }

    public void loadProvidedPropertiesIfAvailable(File providedPropertiesFile, boolean replaceAllProperties) throws com.lazerycode.jmeter.exceptions.IOException {
        if (providedPropertiesFile.exists()) {
            Properties providedPropertySet = this.loadPropertiesFile(providedPropertiesFile);
            if (replaceAllProperties) {
                this.properties = providedPropertySet;
            } else {
                this.properties.putAll((Map<?, ?>)providedPropertySet);
            }
        }
    }

    public void addAndOverwriteProperties(Map<String, String> additionalProperties) {
        additionalProperties.values().removeAll(Collections.singleton(null));
        for (Map.Entry<String, String> additionalPropertiesMap : additionalProperties.entrySet()) {
            if (additionalPropertiesMap.getValue().trim().equals("")) continue;
            this.properties.setProperty(additionalPropertiesMap.getKey(), additionalPropertiesMap.getValue());
            this.warnUserOfPossibleErrors(additionalPropertiesMap.getKey(), this.properties);
        }
    }

    public void writePropertiesToFile(File outputFile) throws com.lazerycode.jmeter.exceptions.IOException {
        this.stripOutReservedProperties();
        if (this.properties.size() == 0) {
            return;
        }
        try (FileOutputStream writeOutFinalPropertiesFile = new FileOutputStream(outputFile);){
            this.properties.store(writeOutFinalPropertiesFile, null);
            writeOutFinalPropertiesFile.flush();
        }
        catch (IOException e) {
            throw new com.lazerycode.jmeter.exceptions.IOException(e.getMessage(), e);
        }
    }

    private void warnUserOfPossibleErrors(String newKey, Properties baseProperties) {
        for (String key : baseProperties.stringPropertyNames()) {
            if (key.equals(newKey) || !key.toLowerCase().equals(newKey.toLowerCase())) continue;
            LOGGER.warn("You have set a property called '" + newKey + "' which is very similar to '" + key + "'!");
        }
    }

    protected void stripOutReservedProperties() {
        for (ReservedProperties reservedProperty : ReservedProperties.values()) {
            if (!this.properties.containsKey(reservedProperty.getPropertyKey())) continue;
            this.properties.remove(reservedProperty.getPropertyKey());
            LOGGER.warn("Unable to set '" + reservedProperty.getPropertyKey() + "', it is a reserved property in the jmeter-maven-plugin");
        }
    }

    public Properties getProperties() {
        return this.properties;
    }
}

