/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.testrunner;

import com.lazerycode.jmeter.configuration.JMeterArgumentsArray;
import com.lazerycode.jmeter.configuration.JMeterProcessJVMSettings;
import com.lazerycode.jmeter.configuration.RemoteArgumentsArrayBuilder;
import com.lazerycode.jmeter.configuration.RemoteConfiguration;
import com.lazerycode.jmeter.testrunner.JMeterProcessBuilder;
import com.lazerycode.jmeter.utility.UtilityFunctions;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.DirectoryScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(JMeterProcessBuilder.class);
    private final JMeterArgumentsArray baseTestArgs;
    private final File binDir;
    private final File testFilesDirectory;
    private final String[] testFilesIncluded;
    private final String[] testFilesExcluded;
    private final boolean suppressJMeterOutput;
    private final RemoteConfiguration remoteServerConfiguration;
    private final JMeterProcessJVMSettings jMeterProcessJVMSettings;
    private long postTestPauseInSeconds;
    private final String runtimeJarName;

    public TestManager(JMeterArgumentsArray baseTestArgs, File testFilesDirectory, List<String> testFilesIncluded, List<String> testFilesExcluded, RemoteConfiguration remoteServerConfiguration, boolean suppressJMeterOutput, File binDir, JMeterProcessJVMSettings jMeterProcessJVMSettings, String runtimeJarName) {
        this.binDir = binDir;
        this.baseTestArgs = baseTestArgs;
        this.testFilesDirectory = testFilesDirectory;
        this.remoteServerConfiguration = remoteServerConfiguration;
        this.suppressJMeterOutput = suppressJMeterOutput;
        this.jMeterProcessJVMSettings = jMeterProcessJVMSettings;
        this.runtimeJarName = runtimeJarName;
        this.testFilesExcluded = testFilesExcluded.toArray(new String[0]);
        this.testFilesIncluded = testFilesIncluded.size() > 0 ? testFilesIncluded.toArray(new String[0]) : new String[]{"**/*.jmx"};
    }

    public void setPostTestPauseInSeconds(String postTestPauseInSeconds) {
        Long testPause = Long.getLong(postTestPauseInSeconds);
        if (null == testPause) {
            LOGGER.info("Invalid value detected for <postTestPauseInSeconds>.  Setting pause to 0...");
            testPause = 0L;
        }
        this.postTestPauseInSeconds = testPause;
    }

    public List<String> executeTests() throws MojoExecutionException {
        JMeterArgumentsArray thisTestArgs = this.baseTestArgs;
        List<String> tests = this.generateTestList();
        ArrayList<String> results = new ArrayList<String>();
        for (String file : tests) {
            if (this.remoteServerConfiguration != null) {
                if (this.remoteServerConfiguration.isStartServersBeforeTests() && tests.get(0).equals(file) || this.remoteServerConfiguration.isStartAndStopServersForEachTest()) {
                    thisTestArgs.setRemoteStart();
                    thisTestArgs.setRemoteStartServerList(this.remoteServerConfiguration.getServerList());
                }
                if (this.remoteServerConfiguration.isStopServersAfterTests() && tests.get(tests.size() - 1).equals(file) || this.remoteServerConfiguration.isStartAndStopServersForEachTest()) {
                    thisTestArgs.setRemoteStop();
                }
            }
            results.add(this.executeSingleTest(new File(this.testFilesDirectory, file), thisTestArgs));
            try {
                TimeUnit.SECONDS.sleep(this.postTestPauseInSeconds);
            }
            catch (InterruptedException interruptedException) {}
        }
        return results;
    }

    private String executeSingleTest(File test, JMeterArgumentsArray testArgs) throws MojoExecutionException {
        LOGGER.info(" ");
        testArgs.setTestFile(test, this.testFilesDirectory);
        new File(testArgs.getResultsLogFileName()).delete();
        List<String> argumentsArray = testArgs.buildArgumentsArray();
        argumentsArray.addAll(this.buildRemoteArgs(this.remoteServerConfiguration));
        LOGGER.debug("JMeter is called with the following command line arguments: " + UtilityFunctions.humanReadableCommandLineOutput(argumentsArray));
        LOGGER.info("Executing test: " + test.getName());
        JMeterProcessBuilder JMeterProcessBuilder2 = new JMeterProcessBuilder(this.jMeterProcessJVMSettings, this.runtimeJarName);
        JMeterProcessBuilder2.setWorkingDirectory(this.binDir);
        JMeterProcessBuilder2.addArguments(argumentsArray);
        try {
            String line;
            final Process process = JMeterProcessBuilder2.startProcess();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    LOGGER.info("Shutdown detected, destroying JMeter process...");
                    process.destroy();
                }
            });
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = br.readLine()) != null) {
                if (this.suppressJMeterOutput) {
                    LOGGER.debug(line);
                    continue;
                }
                LOGGER.info(line);
            }
            int jMeterExitCode = process.waitFor();
            if (jMeterExitCode != 0) {
                throw new MojoExecutionException("Test failed");
            }
            LOGGER.info("Completed Test: " + test.getName());
        }
        catch (InterruptedException ex) {
            LOGGER.info(" ");
            LOGGER.info("System Exit Detected!  Stopping Test...");
            LOGGER.info(" ");
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
        }
        return testArgs.getResultsLogFileName();
    }

    private List<String> buildRemoteArgs(RemoteConfiguration remoteConfig) {
        if (remoteConfig == null) {
            return Collections.emptyList();
        }
        return new RemoteArgumentsArrayBuilder().buildRemoteArgumentsArray(remoteConfig.getPropertiesMap());
    }

    private List<String> generateTestList() {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.testFilesDirectory);
        scanner.setIncludes(this.testFilesIncluded);
        scanner.setExcludes(this.testFilesExcluded);
        scanner.scan();
        return Arrays.asList(scanner.getIncludedFiles());
    }
}

