/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.websocket.components;

import com.lframework.starter.common.utils.CollectionUtil;
import com.lframework.starter.common.utils.StringUtil;
import com.lframework.starter.web.dto.WsPushData;
import com.lframework.starter.web.utils.JsonUtil;
import com.lframework.starter.websocket.components.WsSessionManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;

public class WsDataPushWorker {
    private static final Logger log = LoggerFactory.getLogger(WsDataPushWorker.class);

    public static void push(WsPushData data) {
        if (log.isDebugEnabled()) {
            log.debug("\u5f00\u59cb\u63a8\u9001\u6d88\u606f\uff0cdata = {}", (Object)data);
        }
        if (data == null) {
            return;
        }
        if (data.getAll().booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug("\u5168\u5458\u5e7f\u64ad");
            }
            WsSessionManager.getAllAvailableSessions(data.getTenantId(), data.getIncludeSessionIds(), data.getExcludeSessionIds()).stream().forEach(t -> {
                try {
                    HashMap<String, String> obj = new HashMap<String, String>(2, 1.0f);
                    obj.put("bizType", data.getBizType());
                    obj.put("data", data.getData());
                    t.getWebSocketSession().sendMessage((WebSocketMessage)new TextMessage((CharSequence)JsonUtil.toJsonString(obj)));
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            });
        } else {
            ArrayList<String> userIds = new ArrayList<String>();
            if (CollectionUtil.isNotEmpty((Collection)data.getIncludeUserIds())) {
                userIds.addAll(data.getIncludeUserIds());
            }
            if (StringUtil.isNotBlank((CharSequence)data.getIncludeUserId())) {
                userIds.add(data.getIncludeUserId());
            }
            if (log.isDebugEnabled()) {
                log.debug("\u90e8\u5206\u6210\u5458\u63a5\u6536\u6d88\u606f");
            }
            WsSessionManager.getAvailableSessionsByUserIds(data.getTenantId(), userIds, data.getIncludeSessionIds(), data.getExcludeSessionIds()).forEach(t -> {
                try {
                    HashMap<String, String> obj = new HashMap<String, String>(2, 1.0f);
                    obj.put("bizType", data.getBizType());
                    obj.put("data", data.getData());
                    t.getWebSocketSession().sendMessage((WebSocketMessage)new TextMessage((CharSequence)JsonUtil.toJsonString(obj)));
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            });
        }
    }
}

