/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.websocket.components;

import com.lframework.starter.web.common.tenant.TenantContextHolder;
import com.lframework.starter.web.dto.WsPushData;
import com.lframework.starter.web.utils.JsonUtil;
import com.lframework.starter.web.utils.TenantUtil;
import com.lframework.starter.websocket.components.WsDataPusher;
import com.lframework.starter.websocket.config.WsProperties;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class WsDataPusherImpl
implements WsDataPusher {
    private static final Logger log = LoggerFactory.getLogger(WsDataPusherImpl.class);
    private RedisTemplate redisTemplate;
    private WsProperties properties;

    public WsDataPusherImpl(RedisTemplate redisTemplate, WsProperties properties) {
        this.redisTemplate = redisTemplate;
        this.properties = properties;
    }

    @Override
    public void push(WsPushData data) {
        if (TenantUtil.enableTenant() && data.getTenantId() == null) {
            data.setTenantId(TenantContextHolder.getTenantId());
        }
        if (log.isDebugEnabled()) {
            log.debug("\u51c6\u5907\u63a8\u9001\u6d88\u606f\uff0cdata = {}", (Object)data);
        }
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(this.properties.getTopic());
        parameters.add(JsonUtil.toJsonString((Object)data));
        this.redisTemplate.execute(connection -> {
            byte[][] params = new byte[parameters.size()][];
            for (int i = 0; i < params.length; ++i) {
                params[i] = this.serializer(parameters.get(i));
            }
            Object result = connection.execute("publish", (byte[][])params);
            return this.deserialize(result);
        }, this.redisTemplate.isExposeConnection());
    }

    private byte[] serializer(Object value) {
        if (value == null || value instanceof String) {
            return this.redisTemplate.getStringSerializer().serialize((Object)((String)value));
        }
        return this.serializer(value.toString());
    }

    private Object deserialize(Object value) {
        if (value != null) {
            if (value instanceof byte[]) {
                return this.redisTemplate.getStringSerializer().deserialize((byte[])value);
            }
            if (value instanceof List) {
                List valueList = (List)value;
                ArrayList<Object> resultList = new ArrayList<Object>(valueList.size());
                for (Object val2 : valueList) {
                    resultList.add(this.deserialize(val2));
                }
                return resultList;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                LinkedHashMap newMap = new LinkedHashMap(map.size());
                map.forEach((key, val) -> newMap.put(this.deserialize(key), this.deserialize(val)));
                return newMap;
            }
        }
        return value;
    }
}

