/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.websocket.config;

import com.lframework.starter.common.utils.StringUtil;
import com.lframework.starter.web.dto.WsPushData;
import com.lframework.starter.web.utils.JsonUtil;
import com.lframework.starter.websocket.components.WsDataPushWorker;
import com.lframework.starter.websocket.components.WsDataPusher;
import com.lframework.starter.websocket.components.WsDataPusherImpl;
import com.lframework.starter.websocket.config.WsProperties;
import com.lframework.starter.websocket.handler.WsHandler;
import com.lframework.starter.websocket.interceptor.WsHandshakeInterceptor;
import com.lframework.starter.websocket.listener.WsUserConnectListener;
import com.lframework.starter.websocket.listener.WsUserDisConnectListener;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistration;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.server.HandshakeInterceptor;

@Configuration
@EnableConfigurationProperties(value={WsProperties.class})
@ConditionalOnProperty(prefix="jugg.ws", value={"enabled"}, havingValue="true")
public class WsAutoConfiguration
implements WebSocketConfigurer {
    @Autowired
    private WsProperties properties;

    @Bean
    public WsDataPusher wsDataPusher(RedisTemplate redisTemplate) {
        return new WsDataPusherImpl(redisTemplate, this.properties);
    }

    @Bean
    public RedisMessageListenerContainer redisMessageListenerContainer(RedisConnectionFactory redisConnectionFactory) {
        RedisMessageListenerContainer redisMessageListenerContainer = new RedisMessageListenerContainer();
        redisMessageListenerContainer.setConnectionFactory(redisConnectionFactory);
        redisMessageListenerContainer.addMessageListener((message, pattern) -> WsDataPushWorker.push((WsPushData)JsonUtil.parseObject((String)StringUtil.str((byte[])message.getBody(), (Charset)StandardCharsets.UTF_8), WsPushData.class)), (Topic)ChannelTopic.of((String)this.properties.getTopic()));
        return redisMessageListenerContainer;
    }

    @Bean
    public WsHandler wsHandler() {
        return new WsHandler();
    }

    @Bean
    public WsHandshakeInterceptor wsHandshakeInterceptor() {
        return new WsHandshakeInterceptor();
    }

    @Bean
    public WsUserConnectListener wsUserConnectListener() {
        return new WsUserConnectListener();
    }

    @Bean
    public WsUserDisConnectListener wsUserDisConnectListener() {
        return new WsUserDisConnectListener();
    }

    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        WebSocketHandlerRegistration registration = registry.addHandler((WebSocketHandler)this.wsHandler(), new String[]{"/message/bus"}).addInterceptors(new HandshakeInterceptor[]{this.wsHandshakeInterceptor()});
        if (this.properties.isSupportCrossDomain()) {
            registration.setAllowedOrigins(new String[]{"*"});
        }
    }
}

