/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.websocket.listener;

import com.lframework.starter.web.dto.WsPushData;
import com.lframework.starter.websocket.components.WsDataPusher;
import com.lframework.starter.websocket.events.UserConnectEvent;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;

public class WsUserConnectListener
implements ApplicationListener<UserConnectEvent> {
    private static final Logger log = LoggerFactory.getLogger(WsUserConnectListener.class);
    @Autowired
    private WsDataPusher wsDataPusher;

    public void onApplicationEvent(UserConnectEvent event) {
        if (log.isDebugEnabled()) {
            log.debug("\u76d1\u542c\u5230\u7528\u6237\u5efa\u7acb\u8fde\u63a5\u4e8b\u4ef6\uff0cevent={}", (Object)event);
        }
        WsPushData data = new WsPushData();
        data.setBizType("connect");
        data.setAll(Boolean.TRUE);
        data.setTenantId(event.getUser().getTenantId());
        data.setExcludeSessionIds(Collections.singletonList(event.getSessionId()));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", event.getUser().getName());
        map.put("ip", event.getUser().getIp());
        map.put("createTime", LocalDateTime.now());
        data.setDataObj(map);
        this.wsDataPusher.push(data);
    }
}

