/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository;

import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.Rate;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties.RateLimitProperties;
import java.beans.ConstructorProperties;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisRateLimiter
implements RateLimiter {
    private static final String QUOTA_SUFFIX = "-quota";
    private final RedisTemplate redisTemplate;

    @Override
    public Rate consume(RateLimitProperties.Policy policy, String key, Long requestTime) {
        Long refreshInterval = policy.getRefreshInterval();
        Long quota = policy.getQuota() != null ? Long.valueOf(TimeUnit.SECONDS.toMillis(policy.getQuota())) : null;
        Rate rate = new Rate(key, policy.getLimit(), quota, null, null);
        this.calcRemainingLimit(policy.getLimit(), refreshInterval, requestTime, key, rate);
        this.calcRemainingQuota(quota, refreshInterval, requestTime, key, rate);
        return rate;
    }

    private void calcRemainingLimit(Long limit, Long refreshInterval, Long requestTime, String key, Rate rate) {
        if (limit != null) {
            this.handleExpiration(key, refreshInterval, rate);
            long usage = requestTime == null ? 1L : 0L;
            Long current = this.redisTemplate.boundValueOps((Object)key).increment(usage);
            rate.setRemaining(Math.max(-1L, limit - current));
        }
    }

    private void calcRemainingQuota(Long quota, Long refreshInterval, Long requestTime, String key, Rate rate) {
        if (quota != null) {
            String quotaKey = key + QUOTA_SUFFIX;
            this.handleExpiration(quotaKey, refreshInterval, rate);
            Long usage = requestTime != null ? requestTime : 0L;
            Long current = this.redisTemplate.boundValueOps((Object)quotaKey).increment(usage.longValue());
            rate.setRemainingQuota(Math.max(-1L, quota - current));
        }
    }

    private void handleExpiration(String key, Long refreshInterval, Rate rate) {
        Long expire = this.redisTemplate.getExpire((Object)key);
        if (expire == null || expire == -1L) {
            this.redisTemplate.expire((Object)key, refreshInterval.longValue(), TimeUnit.SECONDS);
            expire = refreshInterval;
        }
        rate.setReset(TimeUnit.SECONDS.toMillis(expire));
    }

    @ConstructorProperties(value={"redisTemplate"})
    public RedisRateLimiter(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

