/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository;

import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.Rate;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.AbstractCacheRateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.RateLimiterErrorHandler;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisRateLimiter
extends AbstractCacheRateLimiter {
    private static final Logger log = LoggerFactory.getLogger(RedisRateLimiter.class);
    private final RateLimiterErrorHandler rateLimiterErrorHandler;
    private final RedisTemplate redisTemplate;

    @Override
    protected void calcRemainingLimit(Long limit, Long refreshInterval, Long requestTime, String key, Rate rate) {
        if (Objects.nonNull(limit)) {
            long usage = requestTime == null ? 1L : 0L;
            Long remaining = this.calcRemaining(limit, refreshInterval, usage, key, rate);
            rate.setRemaining(remaining);
        }
    }

    @Override
    protected void calcRemainingQuota(Long quota, Long refreshInterval, Long requestTime, String key, Rate rate) {
        if (Objects.nonNull(quota)) {
            String quotaKey = key + "-quota";
            long usage = requestTime != null ? requestTime : 0L;
            Long remaining = this.calcRemaining(quota, refreshInterval, usage, quotaKey, rate);
            rate.setRemainingQuota(remaining);
        }
    }

    private Long calcRemaining(Long limit, Long refreshInterval, long usage, String key, Rate rate) {
        rate.setReset(TimeUnit.SECONDS.toMillis(refreshInterval));
        Long current = 0L;
        try {
            current = this.redisTemplate.opsForValue().increment((Object)key, usage);
            if (current != null && current.equals(usage)) {
                this.handleExpiration(key, refreshInterval);
            }
        }
        catch (RuntimeException e) {
            String msg = "Failed retrieving rate for " + key + ", will return the current value";
            this.rateLimiterErrorHandler.handleError(msg, e);
        }
        return Math.max(-1L, limit - current);
    }

    private void handleExpiration(String key, Long refreshInterval) {
        try {
            this.redisTemplate.expire((Object)key, refreshInterval.longValue(), TimeUnit.SECONDS);
        }
        catch (RuntimeException e) {
            String msg = "Failed retrieving expiration for " + key + ", will reset now";
            this.rateLimiterErrorHandler.handleError(msg, e);
        }
    }

    public RedisRateLimiter(RateLimiterErrorHandler rateLimiterErrorHandler, RedisTemplate redisTemplate) {
        this.rateLimiterErrorHandler = rateLimiterErrorHandler;
        this.redisTemplate = redisTemplate;
    }
}

