/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.captcha.base;

import com.googlecode.aviator.AviatorEvaluator;
import com.pig4cloud.captcha.base.Captcha;
import com.pig4cloud.captcha.engine.Symbol;

public abstract class ArithmeticCaptchaAbstract
extends Captcha {
    private String arithmeticString;
    protected static int difficulty = 10;
    protected static int algorithmSign = 4;

    public ArithmeticCaptchaAbstract() {
        this.setLen(2);
    }

    @Override
    protected char[] alphas() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.len; ++i) {
            sb.append(ArithmeticCaptchaAbstract.num(difficulty));
            if (i >= this.len - 1) continue;
            int type = ArithmeticCaptchaAbstract.num(1, algorithmSign);
            if (type == 1) {
                sb.append(Symbol.ADD.getValue());
                continue;
            }
            if (type == 2) {
                sb.append(Symbol.SUB.getValue());
                continue;
            }
            if (type != 3) continue;
            sb.append(Symbol.MUL.getValue());
        }
        this.chars = String.valueOf(AviatorEvaluator.execute((String)sb.toString().replace("x", "*")));
        sb.append("=?");
        this.arithmeticString = sb.toString();
        return this.chars.toCharArray();
    }

    public String getArithmeticString() {
        this.checkAlpha();
        return this.arithmeticString;
    }

    public void setArithmeticString(String arithmeticString) {
        this.arithmeticString = arithmeticString;
    }

    public void setDifficulty(int difficulty) {
        ArithmeticCaptchaAbstract.difficulty = difficulty;
    }

    public void supportAlgorithmSign(int algorithmSign) {
        ArithmeticCaptchaAbstract.algorithmSign = algorithmSign;
    }
}

