/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.collation.CharCollation;
import dev.miku.r2dbc.mysql.message.server.DefinitionMetadataMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import io.r2dbc.spi.ColumnMetadata;
import io.r2dbc.spi.Nullability;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Objects;
import reactor.util.annotation.NonNull;

final class MySqlColumnMetadata
implements ColumnMetadata,
FieldInformation {
    private final int index;
    private final short type;
    private final String name;
    private final short definitions;
    private final Nullability nullability;
    private final long size;
    private final int decimals;
    private final int collationId;

    private MySqlColumnMetadata(int index, short type, String name, short definitions, boolean nonNull, long size, int decimals, int collationId) {
        AssertUtils.require(index >= 0, "index must not be a negative integer");
        AssertUtils.require(size >= 0L, "size must not be a negative integer");
        AssertUtils.require(decimals >= 0, "decimals must not be a negative integer");
        AssertUtils.requireNonNull(name, "name must not be null");
        AssertUtils.require(collationId > 0, "collationId must be a positive integer");
        this.index = index;
        this.type = type;
        this.name = name;
        this.definitions = definitions;
        this.nullability = nonNull ? Nullability.NON_NULL : Nullability.NULLABLE;
        this.size = size;
        this.decimals = decimals;
        this.collationId = collationId;
    }

    static MySqlColumnMetadata create(int index, DefinitionMetadataMessage message) {
        short definitions = message.getDefinitions();
        return new MySqlColumnMetadata(index, message.getType(), message.getColumn(), definitions, (definitions & 1) != 0, message.getSize(), message.getDecimals(), message.getCollationId());
    }

    int getIndex() {
        return this.index;
    }

    @Override
    public short getType() {
        return this.type;
    }

    @Override
    public short getDefinitions() {
        return this.definitions;
    }

    @Override
    public Class<?> getJavaType() {
        switch (this.type) {
            case 0: 
            case 246: {
                return BigDecimal.class;
            }
            case 1: {
                if ((this.definitions & 0x20) != 0) {
                    return Short.class;
                }
                return Byte.class;
            }
            case 2: {
                if ((this.definitions & 0x20) != 0) {
                    return Integer.class;
                }
                return Short.class;
            }
            case 3: {
                if ((this.definitions & 0x20) != 0) {
                    return Long.class;
                }
                return Integer.class;
            }
            case 4: {
                return Float.class;
            }
            case 5: {
                return Double.class;
            }
            case 7: 
            case 12: 
            case 17: {
                return LocalDateTime.class;
            }
            case 8: {
                if ((this.definitions & 0x20) != 0) {
                    return BigInteger.class;
                }
                return Long.class;
            }
            case 9: {
                return Integer.class;
            }
            case 10: {
                return LocalDate.class;
            }
            case 11: {
                return LocalTime.class;
            }
            case 13: {
                return Short.class;
            }
            case 15: 
            case 245: 
            case 247: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: {
                if (this.collationId == CharCollation.BINARY_ID) {
                    return ByteBuffer.class;
                }
                return String.class;
            }
            case 16: {
                return ByteBuffer.class;
            }
            case 255: {
                return byte[].class;
            }
            case 248: {
                return String[].class;
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Integer getNativeTypeMetadata() {
        return this.type;
    }

    public Nullability getNullability() {
        return this.nullability;
    }

    @NonNull
    public Integer getPrecision() {
        return (int)this.size;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public Integer getScale() {
        if ((this.type == 0 || this.type == 246 || this.type == 5 || this.type == 4) && this.decimals >= 0 && this.decimals <= 81) {
            return this.decimals;
        }
        return null;
    }

    @Override
    public int getCollationId() {
        return this.collationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MySqlColumnMetadata)) {
            return false;
        }
        MySqlColumnMetadata metadata = (MySqlColumnMetadata)o;
        return this.index == metadata.index && this.type == metadata.type && this.definitions == metadata.definitions && this.size == metadata.size && this.decimals == metadata.decimals && this.collationId == metadata.collationId && this.name.equals(metadata.name) && this.nullability == metadata.nullability;
    }

    public int hashCode() {
        return Objects.hash(this.index, this.type, this.name, this.definitions, this.nullability, this.size, this.decimals, this.collationId);
    }

    public String toString() {
        return String.format("MySqlColumnMetadata{index=%d, type=%d, name='%s', definitions=%x, nullability=%s, size=%d, decimals=%d, collationId=%d}", this.index, this.type, this.name, this.definitions, this.nullability, this.size, this.decimals, this.collationId);
    }
}

