/*
 * Decompiled with CFR 0.152.
 */
package io.minio.credentials;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.minio.credentials.Credentials;
import io.minio.credentials.EnvironmentProvider;
import io.minio.credentials.Jwt;
import io.minio.credentials.WebIdentityProvider;
import io.minio.messages.ResponseDate;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.ProviderException;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;

public class IamAwsProvider
extends EnvironmentProvider {
    private final HttpUrl customEndpoint;
    private final OkHttpClient httpClient;
    private final ObjectMapper mapper;
    private Credentials credentials;

    public IamAwsProvider(@Nullable String customEndpoint, @Nullable OkHttpClient customHttpClient) {
        this.customEndpoint = customEndpoint != null ? Objects.requireNonNull(HttpUrl.parse((String)customEndpoint), "Invalid custom endpoint") : null;
        this.httpClient = customHttpClient != null ? customHttpClient : new OkHttpClient().newBuilder().protocols(Arrays.asList(Protocol.HTTP_1_1)).build();
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
    }

    private void checkLoopbackHost(HttpUrl url) {
        try {
            for (InetAddress addr : InetAddress.getAllByName(url.host())) {
                if (addr.isLoopbackAddress()) continue;
                throw new ProviderException(url.host() + " is not loopback only host");
            }
        }
        catch (UnknownHostException e) {
            throw new ProviderException("Host in " + url + " is not loopback address");
        }
    }

    private Credentials fetchCredentials(String tokenFile) {
        HttpUrl url = this.customEndpoint;
        if (url == null) {
            String region = this.getProperty("AWS_REGION");
            url = HttpUrl.parse((String)(region == null ? "https://sts.amazonaws.com" : "https://sts." + region + ".amazonaws.com"));
        }
        WebIdentityProvider provider = new WebIdentityProvider(() -> {
            try {
                byte[] data = Files.readAllBytes(Paths.get(tokenFile, new String[0]));
                return new Jwt(new String(data, StandardCharsets.UTF_8), 0);
            }
            catch (IOException e) {
                throw new ProviderException("Error in reading file " + tokenFile, e);
            }
        }, url.toString(), null, null, this.getProperty("AWS_ROLE_ARN"), this.getProperty("AWS_ROLE_SESSION_NAME"), this.httpClient);
        this.credentials = provider.fetch();
        return this.credentials;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Credentials fetchCredentials(HttpUrl url) {
        try (Response response = this.httpClient.newCall(new Request.Builder().url(url).method("GET", null).build()).execute();){
            if (!response.isSuccessful()) {
                throw new ProviderException(url + " failed with HTTP status code " + response.code());
            }
            EcsCredentials creds = (EcsCredentials)this.mapper.readValue(response.body().charStream(), EcsCredentials.class);
            if (creds.code() != null && !creds.code().equals("Success")) {
                throw new ProviderException(url + " failed with code " + creds.code() + " and message " + creds.message());
            }
            Credentials credentials = creds.toCredentials();
            return credentials;
        }
        catch (IOException e) {
            throw new ProviderException("Unable to parse response", e);
        }
    }

    private String getIamRoleName(HttpUrl url) {
        String[] roleNames = null;
        try (Response response = this.httpClient.newCall(new Request.Builder().url(url).method("GET", null).build()).execute();){
            if (!response.isSuccessful()) {
                throw new ProviderException(url + " failed with HTTP status code " + response.code());
            }
            roleNames = response.body().string().split("\\R");
        }
        catch (IOException e) {
            throw new ProviderException("Unable to parse response", e);
        }
        if (roleNames.length == 0) {
            throw new ProviderException("No IAM roles attached to EC2 service " + url);
        }
        return roleNames[0];
    }

    private HttpUrl getIamRoleNamedUrl() {
        HttpUrl url = this.customEndpoint;
        url = url == null ? HttpUrl.parse((String)"http://169.254.169.254/latest/meta-data/iam/security-credentials/") : new HttpUrl.Builder().scheme(url.scheme()).host(url.host()).addPathSegments("latest/meta-data/iam/security-credentials/").build();
        String roleName = this.getIamRoleName(url);
        return url.newBuilder().addPathSegment(roleName).build();
    }

    @Override
    public synchronized Credentials fetch() {
        if (this.credentials != null && !this.credentials.isExpired()) {
            return this.credentials;
        }
        HttpUrl url = this.customEndpoint;
        String tokenFile = this.getProperty("AWS_WEB_IDENTITY_TOKEN_FILE");
        if (tokenFile != null) {
            this.credentials = this.fetchCredentials(tokenFile);
            return this.credentials;
        }
        if (this.getProperty("AWS_CONTAINER_CREDENTIALS_RELATIVE_URI") != null) {
            if (url == null) {
                url = new HttpUrl.Builder().scheme("http").host("169.254.170.2").addPathSegments(this.getProperty("AWS_CONTAINER_CREDENTIALS_RELATIVE_URI")).build();
            }
        } else if (this.getProperty("AWS_CONTAINER_CREDENTIALS_FULL_URI") != null) {
            if (url == null) {
                url = HttpUrl.parse((String)this.getProperty("AWS_CONTAINER_CREDENTIALS_FULL_URI"));
            }
            this.checkLoopbackHost(url);
        } else {
            url = this.getIamRoleNamedUrl();
        }
        this.credentials = this.fetchCredentials(url);
        return this.credentials;
    }

    public static class EcsCredentials {
        @JsonProperty(value="AccessKeyID")
        private String accessKey;
        @JsonProperty(value="SecretAccessKey")
        private String secretKey;
        @JsonProperty(value="Token")
        private String sessionToken;
        @JsonProperty(value="Expiration")
        private ResponseDate expiration;
        @JsonProperty(value="Code")
        private String code;
        @JsonProperty(value="Message")
        private String message;

        public String code() {
            return this.code;
        }

        public String message() {
            return this.message;
        }

        public Credentials toCredentials() {
            return new Credentials(this.accessKey, this.secretKey, this.sessionToken, this.expiration);
        }
    }
}

