/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteStreams;
import io.minio.BucketExistsArgs;
import io.minio.CloseableIterator;
import io.minio.ComposeObjectArgs;
import io.minio.ComposeSource;
import io.minio.CopyObjectArgs;
import io.minio.CreateMultipartUploadResponse;
import io.minio.DeleteBucketEncryptionArgs;
import io.minio.DeleteBucketLifecycleArgs;
import io.minio.DeleteBucketNotificationArgs;
import io.minio.DeleteBucketPolicyArgs;
import io.minio.DeleteBucketReplicationArgs;
import io.minio.DeleteBucketTagsArgs;
import io.minio.DeleteObjectLockConfigurationArgs;
import io.minio.DeleteObjectTagsArgs;
import io.minio.DeleteObjectsResponse;
import io.minio.Directive;
import io.minio.DisableObjectLegalHoldArgs;
import io.minio.DownloadObjectArgs;
import io.minio.EnableObjectLegalHoldArgs;
import io.minio.GetBucketEncryptionArgs;
import io.minio.GetBucketLifecycleArgs;
import io.minio.GetBucketNotificationArgs;
import io.minio.GetBucketPolicyArgs;
import io.minio.GetBucketReplicationArgs;
import io.minio.GetBucketTagsArgs;
import io.minio.GetBucketVersioningArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectLockConfigurationArgs;
import io.minio.GetObjectResponse;
import io.minio.GetObjectRetentionArgs;
import io.minio.GetObjectTagsArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.IsObjectLegalHoldEnabledArgs;
import io.minio.ListBucketsArgs;
import io.minio.ListObjectsArgs;
import io.minio.ListenBucketNotificationArgs;
import io.minio.MakeBucketArgs;
import io.minio.ObjectWriteResponse;
import io.minio.PostPolicy;
import io.minio.PutObjectArgs;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.Result;
import io.minio.S3Base;
import io.minio.SelectObjectContentArgs;
import io.minio.SelectResponseStream;
import io.minio.ServerSideEncryptionCustomerKey;
import io.minio.SetBucketEncryptionArgs;
import io.minio.SetBucketLifecycleArgs;
import io.minio.SetBucketNotificationArgs;
import io.minio.SetBucketPolicyArgs;
import io.minio.SetBucketReplicationArgs;
import io.minio.SetBucketTagsArgs;
import io.minio.SetBucketVersioningArgs;
import io.minio.SetObjectLockConfigurationArgs;
import io.minio.SetObjectRetentionArgs;
import io.minio.SetObjectTagsArgs;
import io.minio.Signer;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.UploadObjectArgs;
import io.minio.UploadPartCopyResponse;
import io.minio.Xml;
import io.minio.credentials.Credentials;
import io.minio.credentials.Provider;
import io.minio.credentials.StaticProvider;
import io.minio.errors.BucketPolicyTooLargeException;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.http.HttpUtils;
import io.minio.http.Method;
import io.minio.messages.Bucket;
import io.minio.messages.CopyObjectResult;
import io.minio.messages.CreateBucketConfiguration;
import io.minio.messages.DeleteError;
import io.minio.messages.DeleteObject;
import io.minio.messages.Item;
import io.minio.messages.LegalHold;
import io.minio.messages.LifecycleConfiguration;
import io.minio.messages.ListAllMyBucketsResult;
import io.minio.messages.NotificationConfiguration;
import io.minio.messages.NotificationRecords;
import io.minio.messages.ObjectLockConfiguration;
import io.minio.messages.Part;
import io.minio.messages.ReplicationConfiguration;
import io.minio.messages.Retention;
import io.minio.messages.SelectObjectContentRequest;
import io.minio.messages.SseConfiguration;
import io.minio.messages.Tags;
import io.minio.messages.VersioningConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class MinioClient
extends S3Base {
    private MinioClient(HttpUrl baseUrl, String region, boolean isAwsHost, boolean isAcceleratedHost, boolean isDualStackHost, boolean useVirtualStyle, Provider provider, OkHttpClient httpClient) {
        super(baseUrl, region, isAwsHost, isAcceleratedHost, isDualStackHost, useVirtualStyle, provider, httpClient);
    }

    protected MinioClient(MinioClient client) {
        super(client);
    }

    @Override
    public StatObjectResponse statObject(StatObjectArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return super.statObject(args);
    }

    public GetObjectResponse getObject(GetObjectArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        args.validateSsec(this.baseUrl);
        Response response = this.executeGet(args, args.getHeaders(), args.versionId() != null ? this.newMultimap("versionId", args.versionId()) : null);
        return new GetObjectResponse(response.headers(), args.bucket(), args.region(), args.object(), response.body().byteStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadObject(DownloadObjectArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        String filename = args.filename();
        Path filePath = Paths.get(filename, new String[0]);
        boolean fileExists = Files.exists(filePath, new LinkOption[0]);
        StatObjectResponse stat = this.statObject(new StatObjectArgs(args));
        String tempFilename = filename + "." + stat.etag() + ".part.minio";
        Path tempFilePath = Paths.get(tempFilename, new String[0]);
        boolean tempFileExists = Files.exists(tempFilePath, new LinkOption[0]);
        if (tempFileExists && !Files.isRegularFile(tempFilePath, new LinkOption[0])) {
            throw new IOException(tempFilename + ": not a regular file");
        }
        long tempFileSize = 0L;
        if (tempFileExists && (tempFileSize = Files.size(tempFilePath)) > stat.size()) {
            Files.delete(tempFilePath);
            tempFileExists = false;
            tempFileSize = 0L;
        }
        if (fileExists) {
            long fileSize = Files.size(filePath);
            if (fileSize == stat.size()) {
                return;
            }
            if (fileSize > stat.size()) {
                throw new IllegalArgumentException("Source object, '" + args.object() + "', size:" + stat.size() + " is smaller than the destination file, '" + filename + "', size:" + fileSize);
            }
            if (!tempFileExists) {
                Files.copy(filePath, tempFilePath, new CopyOption[0]);
                tempFileSize = fileSize;
                tempFileExists = true;
            }
        }
        InputStream is = null;
        OutputStream os = null;
        try {
            is = this.getObject(new GetObjectArgs(args));
            os = Files.newOutputStream(tempFilePath, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            long bytesWritten = ByteStreams.copy((InputStream)is, (OutputStream)os);
            is.close();
            os.close();
            if (bytesWritten != stat.size() - tempFileSize) {
                throw new IOException(tempFilename + ": unexpected data written.  expected = " + (stat.size() - tempFileSize) + ", written = " + bytesWritten);
            }
            Files.move(tempFilePath, filePath, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    public ObjectWriteResponse copyObject(CopyObjectArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        args.validateSse(this.baseUrl);
        long size = -1L;
        if (args.source().offset() != null && args.source().length() != null) {
            StatObjectResponse stat = this.statObject(new StatObjectArgs(args.source()));
            size = stat.size();
        }
        if (args.source().offset() != null || args.source().length() != null || size > 0x140000000L) {
            if (args.metadataDirective() != null && args.metadataDirective() == Directive.COPY) {
                throw new IllegalArgumentException("COPY metadata directive is not applicable to source object size greater than 5 GiB");
            }
            if (args.taggingDirective() != null && args.taggingDirective() == Directive.COPY) {
                throw new IllegalArgumentException("COPY tagging directive is not applicable to source object size greater than 5 GiB");
            }
            return this.composeObject(new ComposeObjectArgs(args));
        }
        Multimap<String, String> headers = args.genHeaders();
        if (args.metadataDirective() != null) {
            headers.put((Object)"x-amz-metadata-directive", (Object)args.metadataDirective().name());
        }
        if (args.taggingDirective() != null) {
            headers.put((Object)"x-amz-tagging-directive", (Object)args.taggingDirective().name());
        }
        headers.putAll(args.source().genCopyHeaders());
        try (Response response = this.executePut(args, headers, null, null, 0);){
            CopyObjectResult result = Xml.unmarshal(CopyObjectResult.class, response.body().charStream());
            ObjectWriteResponse objectWriteResponse = new ObjectWriteResponse(response.headers(), args.bucket(), args.region(), args.object(), result.etag(), response.header("x-amz-version-id"));
            return objectWriteResponse;
        }
    }

    public ObjectWriteResponse composeObject(ComposeObjectArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        args.validateSse(this.baseUrl);
        List<ComposeSource> sources = args.sources();
        int partCount = this.calculatePartCount(sources);
        if (partCount == 1 && args.sources().get(0).offset() == null && args.sources().get(0).length() == null) {
            return this.copyObject(new CopyObjectArgs(args));
        }
        Multimap<String, String> headers = this.newMultimap(args.extraHeaders());
        headers.putAll(args.genHeaders());
        CreateMultipartUploadResponse createMultipartUploadResponse = this.createMultipartUpload(args.bucket(), args.region(), args.object(), headers, args.extraQueryParams());
        String uploadId = createMultipartUploadResponse.result().uploadId();
        HashMultimap ssecHeaders = HashMultimap.create();
        if (args.sse() != null && args.sse() instanceof ServerSideEncryptionCustomerKey) {
            ssecHeaders.putAll(this.newMultimap(args.sse().headers()));
        }
        try {
            int partNumber = 0;
            Part[] totalParts = new Part[partCount];
            for (ComposeSource src : sources) {
                long size = src.objectSize();
                if (src.length() != null) {
                    size = src.length();
                } else if (src.offset() != null) {
                    size -= src.offset().longValue();
                }
                long offset = 0L;
                if (src.offset() != null) {
                    offset = src.offset();
                }
                headers = this.newMultimap(src.headers());
                headers.putAll((Multimap)ssecHeaders);
                if (size <= 0x140000000L) {
                    ++partNumber;
                    if (src.length() != null) {
                        headers.put((Object)"x-amz-copy-source-range", (Object)("bytes=" + offset + "-" + (offset + src.length() - 1L)));
                    } else if (src.offset() != null) {
                        headers.put((Object)"x-amz-copy-source-range", (Object)("bytes=" + offset + "-" + (offset + size - 1L)));
                    }
                    UploadPartCopyResponse response = this.uploadPartCopy(args.bucket(), args.region(), args.object(), uploadId, partNumber, headers, null);
                    String eTag = response.result().etag();
                    totalParts[partNumber - 1] = new Part(partNumber, eTag);
                    continue;
                }
                while (size > 0L) {
                    ++partNumber;
                    long startBytes = offset;
                    long endBytes = startBytes + 0x140000000L;
                    if (size < 0x140000000L) {
                        endBytes = startBytes + size;
                    }
                    Multimap<String, String> headersCopy = this.newMultimap(headers);
                    headersCopy.put((Object)"x-amz-copy-source-range", (Object)("bytes=" + startBytes + "-" + endBytes));
                    UploadPartCopyResponse response = this.uploadPartCopy(args.bucket(), args.region(), args.object(), uploadId, partNumber, headersCopy, null);
                    String eTag = response.result().etag();
                    totalParts[partNumber - 1] = new Part(partNumber, eTag);
                    offset = startBytes;
                    size -= endBytes - startBytes;
                }
            }
            return this.completeMultipartUpload(args.bucket(), this.getRegion(args.bucket(), args.region()), args.object(), uploadId, totalParts, null, null);
        }
        catch (RuntimeException e) {
            this.abortMultipartUpload(args.bucket(), args.region(), args.object(), uploadId, null, null);
            throw e;
        }
        catch (Exception e) {
            this.abortMultipartUpload(args.bucket(), args.region(), args.object(), uploadId, null, null);
            throw e;
        }
    }

    public String getPresignedObjectUrl(GetPresignedObjectUrlArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException, ServerException {
        this.checkArgs(args);
        byte[] body = (byte[])(args.method() == Method.PUT || args.method() == Method.POST ? HttpUtils.EMPTY_BODY : null);
        Multimap<String, String> queryParams = this.newMultimap(args.extraQueryParams());
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        String region = this.getRegion(args.bucket(), args.region());
        if (this.provider == null) {
            HttpUrl url = this.buildUrl(args.method(), args.bucket(), args.object(), region, queryParams);
            return url.toString();
        }
        Credentials creds = this.provider.fetch();
        if (creds.sessionToken() != null) {
            queryParams.put((Object)"X-Amz-Security-Token", (Object)creds.sessionToken());
        }
        HttpUrl url = this.buildUrl(args.method(), args.bucket(), args.object(), region, queryParams);
        Request request = this.createRequest(url, args.method(), args.extraHeaders() == null ? null : this.httpHeaders(args.extraHeaders()), body, 0, creds);
        url = Signer.presignV4(request, region, creds.accessKey(), creds.secretKey(), args.expiry());
        return url.toString();
    }

    public Map<String, String> getPresignedPostFormData(PostPolicy policy) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        if (this.provider == null) {
            throw new IllegalArgumentException("Anonymous access does not require presigned post form-data");
        }
        return policy.formData(this.provider.fetch(), this.getRegion(policy.bucket(), null));
    }

    public void removeObject(RemoveObjectArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        this.executeDelete(args, args.bypassGovernanceMode() ? this.newMultimap("x-amz-bypass-governance-retention", "true") : null, args.versionId() != null ? this.newMultimap("versionId", args.versionId()) : null);
    }

    public Iterable<Result<DeleteError>> removeObjects(final RemoveObjectsArgs args) {
        this.checkArgs(args);
        return new Iterable<Result<DeleteError>>(){

            @Override
            public Iterator<Result<DeleteError>> iterator() {
                return new Iterator<Result<DeleteError>>(){
                    private Result<DeleteError> error = null;
                    private Iterator<DeleteError> errorIterator = null;
                    private boolean completed = false;
                    private Iterator<DeleteObject> objectIter;
                    {
                        this.objectIter = args.objects().iterator();
                    }

                    private void setError() {
                        this.error = null;
                        while (this.errorIterator.hasNext()) {
                            DeleteError deleteError = this.errorIterator.next();
                            if ("NoSuchVersion".equals(deleteError.code())) continue;
                            this.error = new Result<DeleteError>(deleteError);
                            break;
                        }
                    }

                    private synchronized void populate() {
                        if (this.completed) {
                            return;
                        }
                        try {
                            LinkedList<DeleteObject> objectList = new LinkedList<DeleteObject>();
                            while (this.objectIter.hasNext() && objectList.size() < 1000) {
                                objectList.add(this.objectIter.next());
                            }
                            this.completed = objectList.isEmpty();
                            if (this.completed) {
                                return;
                            }
                            DeleteObjectsResponse response = MinioClient.this.deleteObjects(args.bucket(), args.region(), objectList, true, args.bypassGovernanceMode(), args.extraHeaders(), args.extraQueryParams());
                            if (!response.result().errorList().isEmpty()) {
                                this.errorIterator = response.result().errorList().iterator();
                                this.setError();
                                this.completed = true;
                            }
                        }
                        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
                            this.error = new Result(e);
                            this.completed = true;
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.error == null && this.errorIterator == null && !this.completed) {
                            this.populate();
                        }
                        if (this.error == null && this.errorIterator != null) {
                            this.setError();
                        }
                        if (this.error != null) {
                            return true;
                        }
                        if (this.completed) {
                            return false;
                        }
                        this.errorIterator = null;
                        return this.hasNext();
                    }

                    @Override
                    public Result<DeleteError> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        if (this.error != null) {
                            Result<DeleteError> error = this.error;
                            this.error = null;
                            return error;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Iterable<Result<Item>> listObjects(ListObjectsArgs args) {
        if (args.includeVersions() || args.versionIdMarker() != null) {
            return this.listObjectVersions(args);
        }
        if (args.useApiVersion1()) {
            return this.listObjectsV1(args);
        }
        return this.listObjectsV2(args);
    }

    public List<Bucket> listBuckets() throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.listBuckets((ListBucketsArgs)ListBucketsArgs.builder().build());
    }

    public List<Bucket> listBuckets(ListBucketsArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try (Response response = this.executeGet(args, null, null);){
            ListAllMyBucketsResult result = Xml.unmarshal(ListAllMyBucketsResult.class, response.body().charStream());
            List<Bucket> list = result.buckets();
            return list;
        }
    }

    public boolean bucketExists(BucketExistsArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.executeHead(args, null, null);
            return true;
        }
        catch (ErrorResponseException e) {
            if (!e.errorResponse().code().equals("NoSuchBucket")) {
                throw e;
            }
            return false;
        }
    }

    public void makeBucket(MakeBucketArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        String region = args.region();
        if (this.region != null && !this.region.isEmpty()) {
            if (region != null && !region.equals(this.region)) {
                throw new IllegalArgumentException("region must be " + this.region + ", but passed " + region);
            }
            region = this.region;
        }
        if (region == null) {
            region = "us-east-1";
        }
        Multimap<String, String> headers = args.objectLock() ? this.newMultimap("x-amz-bucket-object-lock-enabled", "true") : null;
        try (Response response = this.execute(Method.PUT, args.bucket(), null, region, this.httpHeaders(this.merge(args.extraHeaders(), headers)), args.extraQueryParams(), region.equals("us-east-1") ? null : new CreateBucketConfiguration(region), 0);){
            this.regionCache.put(args.bucket(), region);
        }
    }

    public void setBucketVersioning(SetBucketVersioningArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        Response response = this.executePut(args, null, this.newMultimap("versioning", ""), args.config(), 0);
        response.close();
    }

    public VersioningConfiguration getBucketVersioning(GetBucketVersioningArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        try (Response response = this.executeGet(args, null, this.newMultimap("versioning", ""));){
            VersioningConfiguration versioningConfiguration = Xml.unmarshal(VersioningConfiguration.class, response.body().charStream());
            return versioningConfiguration;
        }
    }

    public void setObjectLockConfiguration(SetObjectLockConfigurationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        Response response = this.executePut(args, null, this.newMultimap("object-lock", ""), args.config(), 0);
        response.close();
    }

    public void deleteObjectLockConfiguration(DeleteObjectLockConfigurationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        Response response = this.executePut(args, null, this.newMultimap("object-lock", ""), new ObjectLockConfiguration(), 0);
        response.close();
    }

    public ObjectLockConfiguration getObjectLockConfiguration(GetObjectLockConfigurationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        try (Response response = this.executeGet(args, null, this.newMultimap("object-lock", ""));){
            ObjectLockConfiguration objectLockConfiguration = Xml.unmarshal(ObjectLockConfiguration.class, response.body().charStream());
            return objectLockConfiguration;
        }
    }

    public void setObjectRetention(SetObjectRetentionArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        Multimap<String, String> queryParams = this.newMultimap("retention", "");
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        Response response = this.executePut(args, args.bypassGovernanceMode() ? this.newMultimap("x-amz-bypass-governance-retention", "True") : null, queryParams, args.config(), 0);
        response.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Retention getObjectRetention(GetObjectRetentionArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        Multimap<String, String> queryParams = this.newMultimap("retention", "");
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        try (Response response = this.executeGet(args, null, queryParams);){
            Retention retention = Xml.unmarshal(Retention.class, response.body().charStream());
            return retention;
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().code().equals("NoSuchObjectLockConfiguration")) return null;
            throw e;
        }
    }

    public void enableObjectLegalHold(EnableObjectLegalHoldArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        Multimap<String, String> queryParams = this.newMultimap("legal-hold", "");
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        Response response = this.executePut(args, null, queryParams, new LegalHold(true), 0);
        response.close();
    }

    public void disableObjectLegalHold(DisableObjectLegalHoldArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        Multimap<String, String> queryParams = this.newMultimap("legal-hold", "");
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        Response response = this.executePut(args, null, queryParams, new LegalHold(false), 0);
        response.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isObjectLegalHoldEnabled(IsObjectLegalHoldEnabledArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        Multimap<String, String> queryParams = this.newMultimap("legal-hold", "");
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        try (Response response = this.executeGet(args, null, queryParams);){
            LegalHold result = Xml.unmarshal(LegalHold.class, response.body().charStream());
            boolean bl = result.status();
            return bl;
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().code().equals("NoSuchObjectLockConfiguration")) return false;
            throw e;
        }
    }

    public void removeBucket(RemoveBucketArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        this.executeDelete(args, null, null);
        this.regionCache.remove(args.bucket());
    }

    public ObjectWriteResponse putObject(PutObjectArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        args.validateSse(this.baseUrl);
        return this.putObject(args, args.stream(), args.objectSize(), args.partSize(), args.partCount(), args.contentType());
    }

    public ObjectWriteResponse uploadObject(UploadObjectArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        args.validateSse(this.baseUrl);
        try (RandomAccessFile file = new RandomAccessFile(args.filename(), "r");){
            ObjectWriteResponse objectWriteResponse = this.putObject(args, file, args.objectSize(), args.partSize(), args.partCount(), args.contentType());
            return objectWriteResponse;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getBucketPolicy(GetBucketPolicyArgs args) throws BucketPolicyTooLargeException, ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        try (Response response = this.executeGet(args, null, this.newMultimap("policy", ""));){
            byte[] buf = new byte[20480];
            int bytesRead = 0;
            bytesRead = response.body().byteStream().read(buf, 0, 20480);
            if (bytesRead < 0) {
                throw new IOException("unexpected EOF when reading bucket policy");
            }
            if (bytesRead == 20480) {
                int byteRead = 0;
                while (byteRead == 0 && (byteRead = response.body().byteStream().read()) >= 0) {
                    if (byteRead <= 0) continue;
                    throw new BucketPolicyTooLargeException(args.bucket());
                }
            }
            String string = new String(buf, 0, bytesRead, StandardCharsets.UTF_8);
            return string;
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().code().equals("NoSuchBucketPolicy")) return "";
            throw e;
        }
    }

    public void setBucketPolicy(SetBucketPolicyArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        Response response = this.executePut(args, this.newMultimap("Content-Type", "application/json"), this.newMultimap("policy", ""), args.config(), 0);
        response.close();
    }

    public void deleteBucketPolicy(DeleteBucketPolicyArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        block2: {
            this.checkArgs(args);
            try {
                this.executeDelete(args, null, this.newMultimap("policy", ""));
            }
            catch (ErrorResponseException e) {
                if (e.errorResponse().code().equals("NoSuchBucketPolicy")) break block2;
                throw e;
            }
        }
    }

    public void setBucketLifecycle(SetBucketLifecycleArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        Response response = this.executePut(args, null, this.newMultimap("lifecycle", ""), args.config(), 0);
        response.close();
    }

    public void deleteBucketLifecycle(DeleteBucketLifecycleArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        this.executeDelete(args, null, this.newMultimap("lifecycle", ""));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LifecycleConfiguration getBucketLifecycle(GetBucketLifecycleArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        try (Response response = this.executeGet(args, null, this.newMultimap("lifecycle", ""));){
            LifecycleConfiguration lifecycleConfiguration = Xml.unmarshal(LifecycleConfiguration.class, response.body().charStream());
            return lifecycleConfiguration;
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().code().equals("NoSuchLifecycleConfiguration")) return null;
            throw e;
        }
    }

    public NotificationConfiguration getBucketNotification(GetBucketNotificationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        try (Response response = this.executeGet(args, null, this.newMultimap("notification", ""));){
            NotificationConfiguration notificationConfiguration = Xml.unmarshal(NotificationConfiguration.class, response.body().charStream());
            return notificationConfiguration;
        }
    }

    public void setBucketNotification(SetBucketNotificationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        Response response = this.executePut(args, null, this.newMultimap("notification", ""), args.config(), 0);
        response.close();
    }

    public void deleteBucketNotification(DeleteBucketNotificationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        Response response = this.executePut(args, null, this.newMultimap("notification", ""), new NotificationConfiguration(), 0);
        response.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReplicationConfiguration getBucketReplication(GetBucketReplicationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        try (Response response = this.executeGet(args, null, this.newMultimap("replication", ""));){
            ReplicationConfiguration replicationConfiguration = Xml.unmarshal(ReplicationConfiguration.class, response.body().charStream());
            return replicationConfiguration;
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().code().equals("ReplicationConfigurationNotFoundError")) return null;
            throw e;
        }
    }

    public void setBucketReplication(SetBucketReplicationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        Response response = this.executePut(args, args.objectLockToken() != null ? this.newMultimap("x-amz-bucket-object-lock-token", args.objectLockToken()) : null, this.newMultimap("replication", ""), args.config(), 0);
        response.close();
    }

    public void deleteBucketReplication(DeleteBucketReplicationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        this.executeDelete(args, null, this.newMultimap("replication", ""));
    }

    public CloseableIterator<Result<NotificationRecords>> listenBucketNotification(ListenBucketNotificationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        Multimap<String, String> queryParams = this.newMultimap("prefix", args.prefix(), "suffix", args.suffix());
        for (String event : args.events()) {
            queryParams.put((Object)"events", (Object)event);
        }
        Response response = this.executeGet(args, null, queryParams);
        S3Base.NotificationResultRecords result = new S3Base.NotificationResultRecords(response);
        return result.closeableIterator();
    }

    public SelectResponseStream selectObjectContent(SelectObjectContentArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        args.validateSsec(this.baseUrl);
        Response response = this.executePost(args, args.ssec() != null ? this.newMultimap(args.ssec().headers()) : null, this.newMultimap("select", "", "select-type", "2"), new SelectObjectContentRequest(args.sqlExpression(), args.requestProgress(), args.inputSerialization(), args.outputSerialization(), args.scanStartRange(), args.scanEndRange()));
        return new SelectResponseStream(response.body().byteStream());
    }

    public void setBucketEncryption(SetBucketEncryptionArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        Response response = this.executePut(args, null, this.newMultimap("encryption", ""), args.config(), 0);
        response.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SseConfiguration getBucketEncryption(GetBucketEncryptionArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        try (Response response = this.executeGet(args, null, this.newMultimap("encryption", ""));){
            SseConfiguration sseConfiguration = Xml.unmarshal(SseConfiguration.class, response.body().charStream());
            return sseConfiguration;
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().code().equals("ServerSideEncryptionConfigurationNotFoundError")) return new SseConfiguration(null);
            throw e;
        }
    }

    public void deleteBucketEncryption(DeleteBucketEncryptionArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        block2: {
            this.checkArgs(args);
            try {
                this.executeDelete(args, null, this.newMultimap("encryption", ""));
            }
            catch (ErrorResponseException e) {
                if (e.errorResponse().code().equals("ServerSideEncryptionConfigurationNotFoundError")) break block2;
                throw e;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tags getBucketTags(GetBucketTagsArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        try (Response response = this.executeGet(args, null, this.newMultimap("tagging", ""));){
            Tags tags = Xml.unmarshal(Tags.class, response.body().charStream());
            return tags;
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().code().equals("NoSuchTagSet")) return new Tags();
            throw e;
        }
    }

    public void setBucketTags(SetBucketTagsArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        Response response = this.executePut(args, null, this.newMultimap("tagging", ""), args.tags(), 0);
        response.close();
    }

    public void deleteBucketTags(DeleteBucketTagsArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        this.executeDelete(args, null, this.newMultimap("tagging", ""));
    }

    public Tags getObjectTags(GetObjectTagsArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        Multimap<String, String> queryParams = this.newMultimap("tagging", "");
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        try (Response response = this.executeGet(args, null, queryParams);){
            Tags tags = Xml.unmarshal(Tags.class, response.body().charStream());
            return tags;
        }
    }

    public void setObjectTags(SetObjectTagsArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        Multimap<String, String> queryParams = this.newMultimap("tagging", "");
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        Response response = this.executePut(args, null, queryParams, args.tags(), 0);
        response.close();
    }

    public void deleteObjectTags(DeleteObjectTagsArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        this.checkArgs(args);
        Multimap<String, String> queryParams = this.newMultimap("tagging", "");
        if (args.versionId() != null) {
            queryParams.put((Object)"versionId", (Object)args.versionId());
        }
        this.executeDelete(args, null, queryParams);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private HttpUrl baseUrl;
        private String region;
        private boolean isAwsHost;
        private boolean isAcceleratedHost;
        private boolean isDualStackHost;
        private boolean useVirtualStyle;
        private Provider provider;
        private OkHttpClient httpClient;
        private boolean isAwsChinaHost;
        private String regionInUrl;

        private boolean isAwsEndpoint(String endpoint) {
            return !(!endpoint.startsWith("s3.") && !this.isAwsAccelerateEndpoint(endpoint) || !endpoint.endsWith(".amazonaws.com") && !endpoint.endsWith(".amazonaws.com.cn"));
        }

        private boolean isAwsAccelerateEndpoint(String endpoint) {
            return endpoint.startsWith("s3-accelerate.");
        }

        private boolean isAwsDualStackEndpoint(String endpoint) {
            return endpoint.contains(".dualstack.");
        }

        private String extractRegion(String endpoint) {
            String[] tokens = endpoint.split("\\.");
            String token = tokens[1];
            if (token.equals("dualstack")) {
                token = tokens[2];
            }
            if (token.equals("amazonaws")) {
                return null;
            }
            return token;
        }

        private void setBaseUrl(HttpUrl url) {
            String host = url.host();
            this.isAwsHost = this.isAwsEndpoint(host);
            this.isAwsChinaHost = false;
            if (this.isAwsHost) {
                this.isAwsChinaHost = host.endsWith(".cn");
                url = url.newBuilder().host(this.isAwsChinaHost ? "amazonaws.com.cn" : "amazonaws.com").build();
                this.isAcceleratedHost = this.isAwsAccelerateEndpoint(host);
                this.isDualStackHost = this.isAwsDualStackEndpoint(host);
                this.regionInUrl = this.extractRegion(host);
                this.useVirtualStyle = true;
            } else {
                this.useVirtualStyle = host.endsWith("aliyuncs.com");
            }
            this.baseUrl = url;
        }

        public Builder endpoint(String endpoint) {
            this.setBaseUrl(HttpUtils.getBaseUrl(endpoint));
            return this;
        }

        public Builder endpoint(String endpoint, int port, boolean secure) {
            HttpUrl url = HttpUtils.getBaseUrl(endpoint);
            if (port < 1 || port > 65535) {
                throw new IllegalArgumentException("port must be in range of 1 to 65535");
            }
            url = url.newBuilder().port(port).scheme(secure ? "https" : "http").build();
            this.setBaseUrl(url);
            return this;
        }

        public Builder endpoint(URL url) {
            HttpUtils.validateNotNull(url, "url");
            return this.endpoint(HttpUrl.get((URL)url));
        }

        public Builder endpoint(HttpUrl url) {
            HttpUtils.validateNotNull(url, "url");
            HttpUtils.validateUrl(url);
            this.setBaseUrl(url);
            return this;
        }

        public Builder region(String region) {
            HttpUtils.validateNullOrNotEmptyString(region, "region");
            this.regionInUrl = region;
            this.region = region;
            return this;
        }

        public Builder credentials(String accessKey, String secretKey) {
            this.provider = new StaticProvider(accessKey, secretKey, null);
            return this;
        }

        public Builder credentialsProvider(Provider provider) {
            this.provider = provider;
            return this;
        }

        public Builder httpClient(OkHttpClient httpClient) {
            HttpUtils.validateNotNull(httpClient, "http client");
            this.httpClient = httpClient;
            return this;
        }

        public MinioClient build() {
            HttpUtils.validateNotNull(this.baseUrl, "endpoint");
            if (this.isAwsChinaHost && this.regionInUrl == null && this.region == null) {
                throw new IllegalArgumentException("Region missing in Amazon S3 China endpoint " + this.baseUrl);
            }
            if (this.httpClient == null) {
                this.httpClient = HttpUtils.newDefaultHttpClient(S3Base.DEFAULT_CONNECTION_TIMEOUT, S3Base.DEFAULT_CONNECTION_TIMEOUT, S3Base.DEFAULT_CONNECTION_TIMEOUT);
                if (this.region == null) {
                    this.region = this.regionInUrl;
                }
            }
            return new MinioClient(this.baseUrl, this.region, this.isAwsHost, this.isAcceleratedHost, this.isDualStackHost, this.useVirtualStyle, this.provider, this.httpClient);
        }
    }
}

