/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;
import rx.internal.operators.OperatorDebounceWithTime;
import rx.observers.SerializedSubscriber;
import rx.subscriptions.SerialSubscription;

public final class OperatorDebounceWithSelector<T, U>
implements Observable.Operator<T, T> {
    final Func1<? super T, ? extends Observable<U>> selector;

    public OperatorDebounceWithSelector(Func1<? super T, ? extends Observable<U>> selector) {
        this.selector = selector;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        final SerializedSubscriber<? super T> s = new SerializedSubscriber<T>(child);
        final SerialSubscription ssub = new SerialSubscription();
        child.add(ssub);
        return new Subscriber<T>(child){
            final OperatorDebounceWithTime.DebounceState<T> state;
            final Subscriber<?> self;
            {
                super(op);
                this.state = new OperatorDebounceWithTime.DebounceState();
                this.self = this;
            }

            @Override
            public void onStart() {
                this.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(T t) {
                Observable debouncer;
                try {
                    debouncer = OperatorDebounceWithSelector.this.selector.call(t);
                }
                catch (Throwable e) {
                    this.onError(e);
                    return;
                }
                final int index = this.state.next(t);
                Subscriber debounceSubscriber = new Subscriber<U>(){

                    @Override
                    public void onNext(U t) {
                        this.onCompleted();
                    }

                    @Override
                    public void onError(Throwable e) {
                        self.onError(e);
                    }

                    @Override
                    public void onCompleted() {
                        state.emit(index, s, self);
                        this.unsubscribe();
                    }
                };
                ssub.set(debounceSubscriber);
                debouncer.unsafeSubscribe(debounceSubscriber);
            }

            @Override
            public void onError(Throwable e) {
                s.onError(e);
                this.unsubscribe();
                this.state.clear();
            }

            @Override
            public void onCompleted() {
                this.state.emitAndComplete(s, this);
            }
        };
    }
}

