/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.List;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.internal.operators.NotificationLite;
import rx.observers.SerializedSubscriber;
import rx.subscriptions.SerialSubscription;

public final class OperatorSwitch<T>
implements Observable.Operator<T, Observable<? extends T>> {
    @Override
    public Subscriber<? super Observable<? extends T>> call(Subscriber<? super T> child) {
        return new SwitchSubscriber<T>(child);
    }

    private static final class SwitchSubscriber<T>
    extends Subscriber<Observable<? extends T>> {
        final SerializedSubscriber<T> s;
        final SerialSubscription ssub;
        final Object guard = new Object();
        final NotificationLite<?> nl = NotificationLite.instance();
        int index;
        boolean active;
        boolean mainDone;
        List<Object> queue;
        boolean emitting;
        InnerSubscriber currentSubscriber;
        long initialRequested;
        volatile boolean infinite = false;

        public SwitchSubscriber(Subscriber<? super T> child) {
            super(child);
            this.s = new SerializedSubscriber<T>(child);
            this.ssub = new SerialSubscription();
            child.add(this.ssub);
            child.setProducer(new Producer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void request(long n) {
                    InnerSubscriber localSubscriber;
                    if (SwitchSubscriber.this.infinite) {
                        return;
                    }
                    if (n == Long.MAX_VALUE) {
                        SwitchSubscriber.this.infinite = true;
                    }
                    Object object = SwitchSubscriber.this.guard;
                    synchronized (object) {
                        localSubscriber = SwitchSubscriber.this.currentSubscriber;
                        if (SwitchSubscriber.this.currentSubscriber == null) {
                            SwitchSubscriber.this.initialRequested = n;
                        } else {
                            InnerSubscriber innerSubscriber = SwitchSubscriber.this.currentSubscriber;
                            innerSubscriber.requested = innerSubscriber.requested + n;
                        }
                    }
                    if (localSubscriber != null) {
                        localSubscriber.requestMore(n);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(Observable<? extends T> t) {
            Object object = this.guard;
            synchronized (object) {
                int id = ++this.index;
                this.active = true;
                long remainingRequest = this.infinite ? Long.MAX_VALUE : (this.currentSubscriber == null ? this.initialRequested : this.currentSubscriber.requested);
                this.currentSubscriber = new InnerSubscriber(id, remainingRequest);
                this.currentSubscriber.requested = remainingRequest;
            }
            this.ssub.set(this.currentSubscriber);
            t.unsafeSubscribe(this.currentSubscriber);
        }

        @Override
        public void onError(Throwable e) {
            this.s.onError(e);
            this.unsubscribe();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            List<Object> localQueue;
            Object object = this.guard;
            synchronized (object) {
                this.mainDone = true;
                if (this.active) {
                    return;
                }
                if (this.emitting) {
                    if (this.queue == null) {
                        this.queue = new ArrayList<Object>();
                    }
                    this.queue.add(this.nl.completed());
                    return;
                }
                localQueue = this.queue;
                this.queue = null;
                this.emitting = true;
            }
            this.drain(localQueue);
            this.s.onCompleted();
            this.unsubscribe();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emit(T value, int id, InnerSubscriber innerSubscriber) {
            Object object;
            List<Object> localQueue;
            Object object2 = this.guard;
            synchronized (object2) {
                if (id != this.index) {
                    return;
                }
                if (this.emitting) {
                    if (this.queue == null) {
                        this.queue = new ArrayList<Object>();
                    }
                    innerSubscriber.requested--;
                    this.queue.add(value);
                    return;
                }
                localQueue = this.queue;
                this.queue = null;
                this.emitting = true;
            }
            boolean once = true;
            boolean skipFinal = false;
            try {
                do {
                    this.drain(localQueue);
                    if (once) {
                        once = false;
                        object = this.guard;
                        synchronized (object) {
                            innerSubscriber.requested--;
                        }
                        this.s.onNext(value);
                    }
                    object = this.guard;
                    synchronized (object) {
                        localQueue = this.queue;
                        this.queue = null;
                        if (localQueue == null) {
                            this.emitting = false;
                            skipFinal = true;
                            break;
                        }
                    }
                } while (!this.s.isUnsubscribed());
            }
            finally {
                if (!skipFinal) {
                    object = this.guard;
                    synchronized (object) {
                        this.emitting = false;
                    }
                }
            }
        }

        void drain(List<Object> localQueue) {
            if (localQueue == null) {
                return;
            }
            for (Object o : localQueue) {
                if (this.nl.isCompleted(o)) {
                    this.s.onCompleted();
                    break;
                }
                if (this.nl.isError(o)) {
                    this.s.onError(this.nl.getError(o));
                    break;
                }
                Object t = o;
                this.s.onNext(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void error(Throwable e, int id) {
            List<Object> localQueue;
            Object object = this.guard;
            synchronized (object) {
                if (id != this.index) {
                    return;
                }
                if (this.emitting) {
                    if (this.queue == null) {
                        this.queue = new ArrayList<Object>();
                    }
                    this.queue.add(this.nl.error(e));
                    return;
                }
                localQueue = this.queue;
                this.queue = null;
                this.emitting = true;
            }
            this.drain(localQueue);
            this.s.onError(e);
            this.unsubscribe();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void complete(int id) {
            List<Object> localQueue;
            Object object = this.guard;
            synchronized (object) {
                if (id != this.index) {
                    return;
                }
                this.active = false;
                if (!this.mainDone) {
                    return;
                }
                if (this.emitting) {
                    if (this.queue == null) {
                        this.queue = new ArrayList<Object>();
                    }
                    this.queue.add(this.nl.completed());
                    return;
                }
                localQueue = this.queue;
                this.queue = null;
                this.emitting = true;
            }
            this.drain(localQueue);
            this.s.onCompleted();
            this.unsubscribe();
        }

        final class InnerSubscriber
        extends Subscriber<T> {
            private long requested = 0L;
            private final int id;
            private final long initialRequested;

            public InnerSubscriber(int id, long initialRequested) {
                this.id = id;
                this.initialRequested = initialRequested;
            }

            @Override
            public void onStart() {
                this.requestMore(this.initialRequested);
            }

            public void requestMore(long n) {
                this.request(n);
            }

            @Override
            public void onNext(T t) {
                SwitchSubscriber.this.emit(t, this.id, this);
            }

            @Override
            public void onError(Throwable e) {
                SwitchSubscriber.this.error(e, this.id);
            }

            @Override
            public void onCompleted() {
                SwitchSubscriber.this.complete(this.id);
            }
        }
    }
}

