/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import rx.Subscription;
import rx.exceptions.CompositeException;

public final class SubscriptionList
implements Subscription {
    private List<Subscription> subscriptions;
    private boolean unsubscribed = false;

    public SubscriptionList() {
    }

    public SubscriptionList(Subscription ... subscriptions) {
        this.subscriptions = new LinkedList<Subscription>(Arrays.asList(subscriptions));
    }

    @Override
    public synchronized boolean isUnsubscribed() {
        return this.unsubscribed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Subscription s) {
        Subscription unsubscribe = null;
        SubscriptionList subscriptionList = this;
        synchronized (subscriptionList) {
            if (this.unsubscribed) {
                unsubscribe = s;
            } else {
                if (this.subscriptions == null) {
                    this.subscriptions = new LinkedList<Subscription>();
                }
                this.subscriptions.add(s);
            }
        }
        if (unsubscribe != null) {
            unsubscribe.unsubscribe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe() {
        SubscriptionList subscriptionList = this;
        synchronized (subscriptionList) {
            if (this.unsubscribed) {
                return;
            }
            this.unsubscribed = true;
        }
        SubscriptionList.unsubscribeFromAll(this.subscriptions);
        this.subscriptions = null;
    }

    private static void unsubscribeFromAll(Collection<Subscription> subscriptions) {
        if (subscriptions == null) {
            return;
        }
        ArrayList<Throwable> es = null;
        for (Subscription s : subscriptions) {
            try {
                s.unsubscribe();
            }
            catch (Throwable e) {
                if (es == null) {
                    es = new ArrayList<Throwable>();
                }
                es.add(e);
            }
        }
        if (es != null) {
            if (es.size() == 1) {
                Throwable t = (Throwable)es.get(0);
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new CompositeException("Failed to unsubscribe to 1 or more subscriptions.", es);
            }
            throw new CompositeException("Failed to unsubscribe to 2 or more subscriptions.", (Collection<? extends Throwable>)es);
        }
    }
}

