/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.plugins.RxJavaPlugins;
import rx.schedulers.GenericScheduledExecutorService;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.MultipleAssignmentSubscription;
import rx.subscriptions.Subscriptions;

final class ExecutorScheduler
extends Scheduler {
    final Executor executor;

    public ExecutorScheduler(Executor executor) {
        this.executor = executor;
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new ExecutorSchedulerWorker(this.executor);
    }

    static final class ExecutorAction
    implements Runnable,
    Subscription {
        final Action0 actual;
        final CompositeSubscription parent;
        volatile int unsubscribed;
        static final AtomicIntegerFieldUpdater<ExecutorAction> UNSUBSCRIBED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ExecutorAction.class, "unsubscribed");

        public ExecutorAction(Action0 actual, CompositeSubscription parent) {
            this.actual = actual;
            this.parent = parent;
        }

        @Override
        public void run() {
            if (this.isUnsubscribed()) {
                return;
            }
            try {
                this.actual.call();
            }
            catch (Throwable t) {
                RxJavaPlugins.getInstance().getErrorHandler().handleError(t);
                Thread thread = Thread.currentThread();
                thread.getUncaughtExceptionHandler().uncaughtException(thread, t);
            }
            finally {
                this.unsubscribe();
            }
        }

        @Override
        public boolean isUnsubscribed() {
            return this.unsubscribed != 0;
        }

        @Override
        public void unsubscribe() {
            if (UNSUBSCRIBED_UPDATER.compareAndSet(this, 0, 1)) {
                this.parent.remove(this);
            }
        }
    }

    static final class ExecutorSchedulerWorker
    extends Scheduler.Worker
    implements Runnable {
        final Executor executor;
        final CompositeSubscription tasks;
        final ConcurrentLinkedQueue<ExecutorAction> queue;
        final AtomicInteger wip;

        public ExecutorSchedulerWorker(Executor executor) {
            this.executor = executor;
            this.queue = new ConcurrentLinkedQueue();
            this.wip = new AtomicInteger();
            this.tasks = new CompositeSubscription();
        }

        @Override
        public Subscription schedule(Action0 action) {
            if (this.isUnsubscribed()) {
                return Subscriptions.unsubscribed();
            }
            ExecutorAction ea = new ExecutorAction(action, this.tasks);
            this.tasks.add(ea);
            this.queue.offer(ea);
            if (this.wip.getAndIncrement() == 0) {
                try {
                    this.executor.execute(this);
                }
                catch (RejectedExecutionException t) {
                    this.tasks.remove(ea);
                    this.wip.decrementAndGet();
                    RxJavaPlugins.getInstance().getErrorHandler().handleError(t);
                    throw t;
                }
            }
            return ea;
        }

        @Override
        public void run() {
            do {
                this.queue.poll().run();
            } while (this.wip.decrementAndGet() > 0);
        }

        @Override
        public Subscription schedule(final Action0 action, long delayTime, TimeUnit unit) {
            if (delayTime <= 0L) {
                return this.schedule(action);
            }
            if (this.isUnsubscribed()) {
                return Subscriptions.unsubscribed();
            }
            ScheduledExecutorService service = this.executor instanceof ScheduledExecutorService ? (ScheduledExecutorService)this.executor : GenericScheduledExecutorService.getInstance();
            final MultipleAssignmentSubscription mas = new MultipleAssignmentSubscription();
            try {
                ScheduledFuture<?> f = service.schedule(new Runnable(){

                    @Override
                    public void run() {
                        if (mas.isUnsubscribed()) {
                            return;
                        }
                        mas.set(ExecutorSchedulerWorker.this.schedule(action));
                    }
                }, delayTime, unit);
                mas.set(Subscriptions.from(f));
            }
            catch (RejectedExecutionException t) {
                RxJavaPlugins.getInstance().getErrorHandler().handleError(t);
                throw t;
            }
            return mas;
        }

        @Override
        public boolean isUnsubscribed() {
            return this.tasks.isUnsubscribed();
        }

        @Override
        public void unsubscribe() {
            this.tasks.unsubscribe();
        }
    }
}

