/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient.impl.actions;

import io.vertx.core.json.JsonArray;
import io.vertx.ext.jdbc.impl.actions.AbstractJDBCAction;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.jdbcclient.impl.actions.JDBCPreparedStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class JDBCPrepareStatementAction
extends AbstractJDBCAction<io.vertx.sqlclient.impl.PreparedStatement> {
    private final String sql;

    public JDBCPrepareStatementAction(JDBCStatementHelper helper, SQLOptions options, String sql) {
        super(helper, options);
        this.sql = sql;
    }

    @Override
    public io.vertx.sqlclient.impl.PreparedStatement execute(Connection conn) throws SQLException {
        PreparedStatement ps;
        boolean autoGeneratedIndexes;
        boolean autoGeneratedKeys = this.options == null || this.options.isAutoGeneratedKeys();
        boolean bl = autoGeneratedIndexes = this.options != null && this.options.getAutoGeneratedKeysIndexes() != null;
        if (autoGeneratedKeys && !autoGeneratedIndexes) {
            ps = conn.prepareStatement(this.sql, 1);
        } else if (autoGeneratedIndexes) {
            JsonArray indexes = this.options.getAutoGeneratedKeysIndexes();
            try {
                if (indexes.getValue(0) instanceof Number) {
                    int[] keys = new int[indexes.size()];
                    for (int i = 0; i < keys.length; ++i) {
                        keys[i] = indexes.getInteger(i);
                    }
                    ps = conn.prepareStatement(this.sql, keys);
                }
                if (indexes.getValue(0) instanceof String) {
                    String[] keys = new String[indexes.size()];
                    for (int i = 0; i < keys.length; ++i) {
                        keys[i] = indexes.getString(i);
                    }
                    ps = conn.prepareStatement(this.sql, keys);
                }
                throw new SQLException("Invalid type of index, only [int, String] allowed");
            }
            catch (RuntimeException e) {
                throw new SQLException(e);
            }
        } else {
            ps = conn.prepareStatement(this.sql);
        }
        return new JDBCPreparedStatement(this.sql, ps);
    }
}

