/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.impl.Arguments;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClientOptions;

@DataObject
public class MqttClientOptions
extends NetClientOptions {
    private static final int DEFAULT_PORT = 1883;
    private static final int DEFAULT_TSL_PORT = 8883;
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_WILL_QOS = 0;
    private static final int DEFAULT_KEEP_ALIVE_TIME_SECONDS = 30;
    private static final boolean DEFAULT_CLEAN_SESSION = true;
    private static final boolean DEFAULT_WILL_FLAG = false;
    private static final boolean DEFAULT_WILL_RETAIN = false;
    public static final int DEFAULT_MAX_MESSAGE_SIZE = -1;
    private int port = 1883;
    private String host = "localhost";
    private String clientId;
    private String username;
    private String password;
    private String willTopic;
    private String willMessage;
    private boolean cleanSession = true;
    private boolean willFlag = false;
    private int willQoS = 0;
    private boolean willRetain = false;
    private int keepAliveTimeSeconds = 30;
    private boolean isAutoKeepAlive = true;
    private boolean isAutoGeneratedClientId = true;
    private int maxMessageSize = -1;

    public MqttClientOptions() {
    }

    public MqttClientOptions(JsonObject json) {
        super(json);
    }

    public MqttClientOptions(MqttClientOptions other) {
        super((NetClientOptions)other);
    }

    public MqttClientOptions setPort(int port) {
        this.port = port;
        return this;
    }

    public MqttClientOptions setHost(String host) {
        this.host = host;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean hasUsername() {
        return this.username != null;
    }

    public boolean hasPassword() {
        return this.password != null;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    public boolean isWillFlag() {
        return this.willFlag;
    }

    public boolean isWillRetain() {
        return this.willRetain;
    }

    public int getWillQoS() {
        return this.willQoS;
    }

    public int getKeepAliveTimeSeconds() {
        return this.keepAliveTimeSeconds;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getWillTopic() {
        return this.willTopic;
    }

    public String getWillMessage() {
        return this.willMessage;
    }

    public MqttClientOptions setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public MqttClientOptions setUsername(String username) {
        this.username = username;
        return this;
    }

    public MqttClientOptions setPassword(String password) {
        this.password = password;
        return this;
    }

    public MqttClientOptions setWillTopic(String willTopic) {
        this.willTopic = willTopic;
        return this;
    }

    public MqttClientOptions setWillMessage(String willMessage) {
        this.willMessage = willMessage;
        return this;
    }

    public MqttClientOptions setCleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
        return this;
    }

    public MqttClientOptions setWillFlag(boolean willFlag) {
        this.willFlag = willFlag;
        return this;
    }

    public MqttClientOptions setWillQoS(int willQoS) {
        this.willQoS = willQoS;
        return this;
    }

    public MqttClientOptions setWillRetain(boolean willRetain) {
        this.willRetain = willRetain;
        return this;
    }

    public MqttClientOptions setKeepAliveTimeSeconds(int keepAliveTimeSeconds) {
        this.keepAliveTimeSeconds = keepAliveTimeSeconds;
        return this;
    }

    public MqttClientOptions setAutoKeepAlive(boolean isAutoKeepAlive) {
        this.isAutoKeepAlive = isAutoKeepAlive;
        return this;
    }

    public MqttClientOptions setAutoGeneratedClientId(boolean isAutoGeneratedClientId) {
        this.isAutoGeneratedClientId = isAutoGeneratedClientId;
        return this;
    }

    public boolean isAutoKeepAlive() {
        return this.isAutoKeepAlive;
    }

    public boolean isAutoGeneratedClientId() {
        return this.isAutoGeneratedClientId;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public MqttClientOptions setReceiveBufferSize(int receiveBufferSize) {
        if (this.maxMessageSize > 0 && receiveBufferSize > 0) {
            Arguments.require((receiveBufferSize >= this.maxMessageSize ? 1 : 0) != 0, (String)"Receiver buffer size can't be lower than max message size");
        }
        super.setReceiveBufferSize(receiveBufferSize);
        return this;
    }

    public MqttClientOptions setMaxMessageSize(int maxMessageSize) {
        Arguments.require((maxMessageSize > 0 || maxMessageSize == -1 ? 1 : 0) != 0, (String)"maxMessageSize must be > 0");
        if (maxMessageSize > 0 && this.getReceiveBufferSize() > 0) {
            Arguments.require((this.getReceiveBufferSize() >= maxMessageSize ? 1 : 0) != 0, (String)"Receiver buffer size can't be lower than max message size");
        }
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    public MqttClientOptions setSsl(boolean ssl) {
        super.setSsl(ssl);
        return this;
    }

    public String toString() {
        return "Options {clientId='" + this.clientId + '\'' + ", username='" + this.username + '\'' + ", password='" + this.password + '\'' + ", willTopic='" + this.willTopic + '\'' + ", willMessage='" + this.willMessage + '\'' + ", cleanSession=" + this.cleanSession + ", willFlag=" + this.willFlag + ", willQoS=" + this.willQoS + ", willRetain=" + this.willRetain + ", keepAliveTimeSeconds=" + this.keepAliveTimeSeconds + ", isAutoKeepAlive=" + this.isAutoKeepAlive + '}';
    }
}

