require 'vertx/util/utils.rb'
# Generated from io.vertx.mqtt.messages.MqttConnAckMessage
module VertxMqttServer
  #  Represents an MQTT CONNACK message
  class MqttConnAckMessage
    # @private
    # @param j_del [::VertxMqttServer::MqttConnAckMessage] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxMqttServer::MqttConnAckMessage] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MqttConnAckMessage
    end
    def @@j_api_type.wrap(obj)
      MqttConnAckMessage.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxMqttMessages::MqttConnAckMessage.java_class
    end
    #  Create a concrete instance of a Vert.x connack message
    # @param [:CONNECTION_ACCEPTED,:CONNECTION_REFUSED_UNACCEPTABLE_PROTOCOL_VERSION,:CONNECTION_REFUSED_IDENTIFIER_REJECTED,:CONNECTION_REFUSED_SERVER_UNAVAILABLE,:CONNECTION_REFUSED_BAD_USER_NAME_OR_PASSWORD,:CONNECTION_REFUSED_NOT_AUTHORIZED] code return code from the connection request
    # @param [true,false] isSessionPresent is an old session is present
    # @return [::VertxMqttServer::MqttConnAckMessage] 
    def self.create(code=nil,isSessionPresent=nil)
      if code.class == Symbol && (isSessionPresent.class == TrueClass || isSessionPresent.class == FalseClass) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxMqttMessages::MqttConnAckMessage.java_method(:create, [Java::IoNettyHandlerCodecMqtt::MqttConnectReturnCode.java_class,Java::boolean.java_class]).call(Java::IoNettyHandlerCodecMqtt::MqttConnectReturnCode.valueOf(code.to_s),isSessionPresent),::VertxMqttServer::MqttConnAckMessage)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{code},#{isSessionPresent})"
    end
    # @return [:CONNECTION_ACCEPTED,:CONNECTION_REFUSED_UNACCEPTABLE_PROTOCOL_VERSION,:CONNECTION_REFUSED_IDENTIFIER_REJECTED,:CONNECTION_REFUSED_SERVER_UNAVAILABLE,:CONNECTION_REFUSED_BAD_USER_NAME_OR_PASSWORD,:CONNECTION_REFUSED_NOT_AUTHORIZED] return code from the connection request
    def code
      if !block_given?
        if @cached_code != nil
          return @cached_code
        end
        return @cached_code = @j_del.java_method(:code, []).call().name.intern
      end
      raise ArgumentError, "Invalid arguments when calling code()"
    end
    # @return [true,false] is an old session is present
    def session_present?
      if !block_given?
        if @cached_is_session_present != nil
          return @cached_is_session_present
        end
        return @cached_is_session_present = @j_del.java_method(:isSessionPresent, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling session_present?()"
    end
  end
end
