require 'vertx-mqtt-server/mqtt_message'
require 'vertx/util/utils.rb'
# Generated from io.vertx.mqtt.messages.MqttSubAckMessage
module VertxMqttServer
  #  Represents an MQTT SUBACK message
  class MqttSubAckMessage
    include ::VertxMqttServer::MqttMessage
    # @private
    # @param j_del [::VertxMqttServer::MqttSubAckMessage] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxMqttServer::MqttSubAckMessage] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MqttSubAckMessage
    end
    def @@j_api_type.wrap(obj)
      MqttSubAckMessage.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxMqttMessages::MqttSubAckMessage.java_class
    end
    # @return [Fixnum] Message identifier
    def message_id
      if !block_given?
        if @cached_message_id != nil
          return @cached_message_id
        end
        return @cached_message_id = @j_del.java_method(:messageId, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling message_id()"
    end
    # @return [Array<Fixnum>] list of granted QoS levels
    def granted_qo_s_levels
      if !block_given?
        if @cached_granted_qo_s_levels != nil
          return @cached_granted_qo_s_levels
        end
        return @cached_granted_qo_s_levels = @j_del.java_method(:grantedQoSLevels, []).call().to_a.map { |elt| elt }
      end
      raise ArgumentError, "Invalid arguments when calling granted_qo_s_levels()"
    end
  end
end
