/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.mysqlclient.MySQLAuthOptions;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLSetOption;
import io.vertx.mysqlclient.impl.MySQLConnectionImpl;
import io.vertx.sqlclient.PreparedStatement;
import io.vertx.sqlclient.SqlConnection;

@VertxGen
public interface MySQLConnection
extends SqlConnection {
    public static void connect(Vertx vertx, MySQLConnectOptions connectOptions, Handler<AsyncResult<MySQLConnection>> handler) {
        Future<MySQLConnection> fut = MySQLConnection.connect(vertx, connectOptions);
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    public static Future<MySQLConnection> connect(Vertx vertx, MySQLConnectOptions connectOptions) {
        return MySQLConnectionImpl.connect((ContextInternal)vertx.getOrCreateContext(), connectOptions);
    }

    public static void connect(Vertx vertx, String connectionUri, Handler<AsyncResult<MySQLConnection>> handler) {
        MySQLConnection.connect(vertx, MySQLConnectOptions.fromUri(connectionUri), handler);
    }

    public static Future<MySQLConnection> connect(Vertx vertx, String connectionUri) {
        return MySQLConnection.connect(vertx, MySQLConnectOptions.fromUri(connectionUri));
    }

    @Fluent
    public MySQLConnection prepare(String var1, Handler<AsyncResult<PreparedStatement>> var2);

    @Fluent
    public MySQLConnection exceptionHandler(Handler<Throwable> var1);

    @Fluent
    public MySQLConnection closeHandler(Handler<Void> var1);

    @Fluent
    public MySQLConnection ping(Handler<AsyncResult<Void>> var1);

    public Future<Void> ping();

    @Fluent
    public MySQLConnection specifySchema(String var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> specifySchema(String var1);

    @Fluent
    public MySQLConnection getInternalStatistics(Handler<AsyncResult<String>> var1);

    public Future<String> getInternalStatistics();

    @Fluent
    public MySQLConnection setOption(MySQLSetOption var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> setOption(MySQLSetOption var1);

    @Fluent
    public MySQLConnection resetConnection(Handler<AsyncResult<Void>> var1);

    public Future<Void> resetConnection();

    @Fluent
    public MySQLConnection debug(Handler<AsyncResult<Void>> var1);

    public Future<Void> debug();

    @Fluent
    public MySQLConnection changeUser(MySQLAuthOptions var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> changeUser(MySQLAuthOptions var1);
}

