/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.vertx.core.Closeable;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLPool;
import io.vertx.mysqlclient.impl.MySQLConnectionFactory;
import io.vertx.mysqlclient.impl.MySQLConnectionImpl;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactory;
import io.vertx.sqlclient.impl.PoolBase;
import io.vertx.sqlclient.impl.SqlConnectionImpl;
import io.vertx.sqlclient.impl.tracing.QueryTracer;

public class MySQLPoolImpl
extends PoolBase<MySQLPoolImpl>
implements MySQLPool {
    private final MySQLConnectionFactory factory;

    public static MySQLPoolImpl create(VertxInternal vertx, boolean closeVertx, MySQLConnectOptions connectOptions, PoolOptions poolOptions) {
        QueryTracer tracer = vertx.tracer() == null ? null : new QueryTracer(vertx.tracer(), (SqlConnectOptions)connectOptions);
        VertxMetrics vertxMetrics = vertx.metricsSPI();
        ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(connectOptions.getSocketAddress(), "sql", connectOptions.getMetricsName()) : null;
        MySQLPoolImpl pool = new MySQLPoolImpl(vertx, new MySQLConnectionFactory(vertx, connectOptions), tracer, metrics, poolOptions);
        pool.init();
        CloseFuture closeFuture = pool.closeFuture();
        if (closeVertx) {
            closeFuture.future().onComplete(ar -> vertx.close());
        } else {
            ContextInternal ctx = vertx.getContext();
            if (ctx != null) {
                ctx.addCloseHook((Closeable)closeFuture);
            } else {
                vertx.addCloseHook((Closeable)closeFuture);
            }
        }
        return pool;
    }

    private MySQLPoolImpl(VertxInternal vertx, MySQLConnectionFactory factory, QueryTracer tracer, ClientMetrics metrics, PoolOptions poolOptions) {
        super(vertx, (ConnectionFactory)factory, tracer, metrics, 1, poolOptions);
        this.factory = factory;
    }

    protected SqlConnectionImpl wrap(ContextInternal context, Connection conn) {
        return new MySQLConnectionImpl(this.factory, context, conn, this.tracer, this.metrics);
    }
}

