/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLPool;
import io.vertx.mysqlclient.impl.MySQLConnectionImpl;
import io.vertx.mysqlclient.spi.MySQLDriver;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.PoolBase;
import io.vertx.sqlclient.impl.SqlConnectionImpl;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import io.vertx.sqlclient.spi.ConnectionFactory;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class MySQLPoolImpl
extends PoolBase<MySQLPoolImpl>
implements MySQLPool {
    public static MySQLPoolImpl create(VertxInternal vertx, List<? extends SqlConnectOptions> servers, PoolOptions poolOptions) {
        VertxInternal vx;
        MySQLConnectOptions baseConnectOptions = MySQLConnectOptions.wrap(servers.get(0));
        if (vertx == null) {
            if (Vertx.currentContext() != null) {
                throw new IllegalStateException("Running in a Vertx context => use MySQLPool#pool(Vertx, MySQLConnectOptions, PoolOptions) instead");
            }
            VertxOptions vertxOptions = new VertxOptions();
            if (baseConnectOptions.isUsingDomainSocket()) {
                vertxOptions.setPreferNativeTransport(true);
            }
            vx = (VertxInternal)Vertx.vertx((VertxOptions)vertxOptions);
        } else {
            vx = vertx;
        }
        QueryTracer tracer = vx.tracer() == null ? null : new QueryTracer(vx.tracer(), (SqlConnectOptions)baseConnectOptions);
        VertxMetrics vertxMetrics = vx.metricsSPI();
        ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(baseConnectOptions.getSocketAddress(), "sql", baseConnectOptions.getMetricsName()) : null;
        MySQLPoolImpl pool = new MySQLPoolImpl(vx, baseConnectOptions, null, tracer, metrics, poolOptions);
        pool.init();
        MySQLDriver driver = new MySQLDriver();
        List lst = servers.stream().map(options -> driver.createConnectionFactory((Vertx)vx, (SqlConnectOptions)options)).collect(Collectors.toList());
        ConnectionFactory factory = ConnectionFactory.roundRobinSelector(lst);
        pool.connectionProvider(arg_0 -> ((ConnectionFactory)factory).connect(arg_0));
        CloseFuture closeFuture = pool.closeFuture();
        closeFuture.add((Closeable)factory);
        if (vertx == null) {
            closeFuture.future().onComplete(ar -> vx.close());
        } else {
            ContextInternal ctx = vx.getContext();
            if (ctx != null) {
                ctx.addCloseHook((Closeable)closeFuture);
            } else {
                vx.addCloseHook((Closeable)closeFuture);
            }
        }
        return pool;
    }

    private MySQLPoolImpl(VertxInternal vertx, MySQLConnectOptions baseConnectOptions, Supplier<Future<SqlConnectOptions>> connectOptionsProvider, QueryTracer tracer, ClientMetrics metrics, PoolOptions poolOptions) {
        super(vertx, (SqlConnectOptions)baseConnectOptions, connectOptionsProvider, tracer, metrics, 1, poolOptions);
    }

    protected SqlConnectionImpl wrap(ContextInternal context, ConnectionFactory factory, Connection conn) {
        return new MySQLConnectionImpl(context, factory, conn, this.tracer, this.metrics);
    }

    @Override
    public MySQLPool connectHandler(Handler<SqlConnection> handler) {
        return (MySQLPool)super.connectHandler(handler);
    }
}

