/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.PreparedStatement;
import io.vertx.sqlclient.impl.QueryResultBuilder;
import io.vertx.sqlclient.impl.SqlResultBase;
import io.vertx.sqlclient.impl.TupleInternal;
import io.vertx.sqlclient.impl.command.CommandScheduler;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import io.vertx.sqlclient.impl.command.SimpleQueryCommand;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collector;

class QueryExecutor<T, R extends SqlResultBase<T>, L extends SqlResult<T>> {
    private final ClientMetrics metrics;
    private final QueryTracer tracer;
    private final Function<T, R> factory;
    private final Collector<Row, ?, T> collector;

    public QueryExecutor(QueryTracer tracer, ClientMetrics metrics, Function<T, R> factory, Collector<Row, ?, T> collector) {
        this.tracer = tracer;
        this.metrics = metrics;
        this.factory = factory;
        this.collector = collector;
    }

    QueryTracer tracer() {
        return this.tracer;
    }

    ClientMetrics metrics() {
        return this.metrics;
    }

    private QueryResultBuilder<T, R, L> createHandler(PromiseInternal<L> promise, Object payload) {
        return this.createHandler(promise, payload, null);
    }

    private QueryResultBuilder<T, R, L> createHandler(PromiseInternal<L> promise, Object payload, Object metric) {
        return new QueryResultBuilder<T, R, L>(this.factory, this.tracer, payload, this.metrics, metric, promise);
    }

    void executeSimpleQuery(CommandScheduler scheduler, String sql, boolean autoCommit, boolean singleton, PromiseInternal<L> promise) {
        Object metric;
        ContextInternal context = promise.context();
        Object payload = this.tracer != null ? this.tracer.sendRequest(context, sql) : null;
        if (this.metrics != null) {
            metric = this.metrics.requestBegin(sql, (Object)sql);
            this.metrics.requestEnd(metric);
        } else {
            metric = null;
        }
        QueryResultBuilder<T, R, L> handler = this.createHandler(promise, payload, metric);
        scheduler.schedule(new SimpleQueryCommand<T>(sql, singleton, autoCommit, this.collector, handler), handler);
    }

    QueryResultBuilder<T, R, L> executeExtendedQuery(CommandScheduler scheduler, PreparedStatement preparedStatement, boolean autoCommit, Tuple arguments, int fetch, String cursorId, boolean suspended, PromiseInternal<L> promise) {
        Object metric;
        ContextInternal context = promise.context();
        Object payload = this.tracer != null ? this.tracer.sendRequest(context, preparedStatement.sql(), arguments) : null;
        if (this.metrics != null) {
            metric = this.metrics.requestBegin(preparedStatement.sql(), (Object)preparedStatement.sql());
            this.metrics.requestEnd(metric);
        } else {
            metric = null;
        }
        QueryResultBuilder<T, R, L> handler = this.createHandler(promise, payload, metric);
        String msg = preparedStatement.prepare((TupleInternal)arguments);
        if (msg != null) {
            handler.fail(msg);
            return null;
        }
        ExtendedQueryCommand<T> cmd = ExtendedQueryCommand.createQuery(preparedStatement.sql(), preparedStatement, arguments, fetch, cursorId, suspended, autoCommit, this.collector, handler);
        scheduler.schedule(cmd, handler);
        return handler;
    }

    void executeExtendedQuery(CommandScheduler scheduler, String sql, boolean autoCommit, Tuple arguments, PromiseInternal<L> promise) {
        Object metric;
        ContextInternal context = promise.context();
        Object payload = this.tracer != null ? this.tracer.sendRequest(context, sql, arguments) : null;
        if (this.metrics != null) {
            metric = this.metrics.requestBegin(sql, (Object)sql);
            this.metrics.requestEnd(metric);
        } else {
            metric = null;
        }
        QueryResultBuilder<T, R, L> handler = this.createHandler(promise, payload, metric);
        ExtendedQueryCommand<T> cmd = this.createExtendedQueryCommand(sql, autoCommit, arguments, handler);
        scheduler.schedule(cmd, handler);
    }

    private ExtendedQueryCommand<T> createExtendedQueryCommand(String sql, boolean autoCommit, Tuple tuple, QueryResultBuilder<T, R, L> handler) {
        return ExtendedQueryCommand.createQuery(sql, null, tuple, autoCommit, this.collector, handler);
    }

    void executeBatchQuery(CommandScheduler scheduler, PreparedStatement preparedStatement, boolean autoCommit, List<Tuple> batch, PromiseInternal<L> promise) {
        Object metric;
        ContextInternal context = promise.context();
        Object payload = this.tracer != null ? this.tracer.sendRequest(context, preparedStatement.sql(), batch) : null;
        if (this.metrics != null) {
            metric = this.metrics.requestBegin(preparedStatement.sql(), (Object)preparedStatement.sql());
            this.metrics.requestEnd(metric);
        } else {
            metric = null;
        }
        QueryResultBuilder<T, R, L> handler = this.createHandler(promise, payload, metric);
        for (Tuple args : batch) {
            String msg = preparedStatement.prepare((TupleInternal)args);
            if (msg == null) continue;
            handler.fail(msg);
            return;
        }
        ExtendedQueryCommand<T> cmd = ExtendedQueryCommand.createBatch(preparedStatement.sql(), preparedStatement, batch, autoCommit, this.collector, handler);
        scheduler.schedule(cmd, handler);
    }

    void executeBatchQuery(CommandScheduler scheduler, String sql, boolean autoCommit, List<Tuple> batch, PromiseInternal<L> promise) {
        Object metric;
        ContextInternal context = promise.context();
        Object payload = this.tracer != null ? this.tracer.sendRequest(context, sql, batch) : null;
        if (this.metrics != null) {
            metric = this.metrics.requestBegin(sql, (Object)sql);
            this.metrics.requestEnd(metric);
        } else {
            metric = null;
        }
        QueryResultBuilder<T, R, L> handler = this.createHandler(promise, payload, metric);
        ExtendedQueryCommand<T> cmd = this.createBatchQueryCommand(sql, autoCommit, batch, handler);
        scheduler.schedule(cmd, handler);
    }

    private ExtendedQueryCommand<T> createBatchQueryCommand(String sql, boolean autoCommit, List<Tuple> argsList, QueryResultBuilder<T, R, L> handler) {
        return ExtendedQueryCommand.createBatch(sql, null, argsList, autoCommit, this.collector, handler);
    }
}

