/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.sqlclient.PreparedStatement;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.PreparedStatementImpl;
import io.vertx.sqlclient.impl.SqlClientBase;
import io.vertx.sqlclient.impl.command.PrepareStatementCommand;
import io.vertx.sqlclient.impl.tracing.QueryTracer;

public abstract class SqlConnectionBase<C extends SqlClient>
extends SqlClientBase<C> {
    protected final ContextInternal context;
    protected final Connection conn;

    protected SqlConnectionBase(ContextInternal context, Connection conn, QueryTracer tracer, ClientMetrics metrics) {
        super(tracer, metrics);
        this.context = context;
        this.conn = conn;
    }

    public C prepare(String sql, Handler<AsyncResult<PreparedStatement>> handler) {
        Future<PreparedStatement> fut = this.prepare(sql);
        if (handler != null) {
            fut.onComplete(handler);
        }
        return (C)this;
    }

    public Future<PreparedStatement> prepare(String sql) {
        PromiseInternal promise = this.promise();
        this.schedule(new PrepareStatementCommand(sql, true), promise);
        return promise.future().compose(cr -> Future.succeededFuture((Object)PreparedStatementImpl.create(this.conn, this.tracer, this.metrics, this.context, cr, this.autoCommit())), err -> {
            if (this.conn.isIndeterminatePreparedStatementError((Throwable)err)) {
                return Future.succeededFuture((Object)PreparedStatementImpl.create(this.conn, this.tracer, this.metrics, this.context, sql, this.autoCommit()));
            }
            return Future.failedFuture((Throwable)err);
        });
    }
}

