/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl.pool;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.pool.ConnectResult;
import io.vertx.core.net.impl.pool.ConnectionPool;
import io.vertx.core.net.impl.pool.Lease;
import io.vertx.core.net.impl.pool.PoolConnection;
import io.vertx.core.net.impl.pool.PoolConnector;
import io.vertx.core.net.impl.pool.PoolWaiter;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactoryBase;
import io.vertx.sqlclient.impl.SqlConnectionImpl;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.spi.ConnectionFactory;
import io.vertx.sqlclient.spi.DatabaseMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class SqlConnectionPool {
    private static final Logger log = LoggerFactory.getLogger(SqlConnectionPool.class);
    private final SqlConnectOptions baseConnectOptions;
    private final Supplier<Future<SqlConnectOptions>> connectOptionsProvider;
    private final Function<Context, Future<SqlConnection>> connectionProvider;
    private final VertxInternal vertx;
    private final ConnectionPool<PooledConnection> pool;
    private final Supplier<Handler<PooledConnection>> hook;
    private final int pipeliningLimit;
    private final long idleTimeout;
    private final int maxSize;
    private final PoolConnector<PooledConnection> connector = new PoolConnector<PooledConnection>(){

        public void connect(EventLoopContext context, PoolConnector.Listener listener, Handler<AsyncResult<ConnectResult<PooledConnection>>> handler) {
            Future future = (Future)SqlConnectionPool.this.connectionProvider.apply(context);
            future.onComplete(ar -> {
                if (ar.succeeded()) {
                    SqlConnectionImpl res = (SqlConnectionImpl)ar.result();
                    Connection conn = res.unwrap();
                    if (conn.isValid()) {
                        PooledConnection pooled = new PooledConnection(res.factory(), conn, listener);
                        conn.init(pooled);
                        handler.handle((Object)Future.succeededFuture((Object)new ConnectResult((Object)pooled, (long)SqlConnectionPool.this.pipeliningLimit, 0L)));
                    } else {
                        handler.handle((Object)Future.failedFuture((Throwable)ConnectionBase.CLOSED_EXCEPTION));
                    }
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            });
        }

        public boolean isValid(PooledConnection connection) {
            return true;
        }
    };

    public SqlConnectionPool(SqlConnectOptions baseConnectOptions, Supplier<Future<SqlConnectOptions>> connectOptionsProvider, Function<Context, Future<SqlConnection>> connectionProvider, Supplier<Handler<PooledConnection>> hook, VertxInternal vertx, long idleTimeout, int maxSize, int pipeliningLimit, int maxWaitQueueSize) {
        if (maxSize < 1) {
            throw new IllegalArgumentException("Pool max size must be > 0");
        }
        if (pipeliningLimit < 1) {
            throw new IllegalArgumentException("Pipelining limit must be > 0");
        }
        this.baseConnectOptions = baseConnectOptions;
        this.connectOptionsProvider = connectOptionsProvider;
        this.pool = ConnectionPool.pool(this.connector, (int[])new int[]{maxSize}, (int)maxWaitQueueSize);
        this.vertx = vertx;
        this.pipeliningLimit = pipeliningLimit;
        this.idleTimeout = idleTimeout;
        this.maxSize = maxSize;
        this.hook = hook;
        this.connectionProvider = connectionProvider;
        if (pipeliningLimit > 1) {
            this.pool.connectionSelector((waiter, list) -> {
                PoolConnection selected = null;
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    PoolConnection conn = (PoolConnection)list.get(i);
                    if (conn.concurrency() <= 0) continue;
                    if (selected == null) {
                        selected = conn;
                        continue;
                    }
                    if (((PooledConnection)conn.get()).inflight >= ((PooledConnection)selected.get()).inflight) continue;
                    selected = conn;
                }
                return selected;
            });
        }
    }

    public int available() {
        return this.maxSize - this.pool.size();
    }

    public int size() {
        return this.pool.size();
    }

    public void checkExpired() {
        long now = System.currentTimeMillis();
        this.pool.evict(conn -> conn.expirationTimestamp < now, ar -> {
            if (ar.succeeded()) {
                List res = (List)ar.result();
                for (PooledConnection conn : res) {
                    conn.close((Promise<Void>)Promise.promise());
                }
            }
        });
    }

    public <R> Future<R> execute(ContextInternal context, CommandBase<R> cmd) {
        PromiseInternal promise = context.promise();
        EventLoopContext eventLoopCtx = ConnectionFactoryBase.asEventLoopContext(context);
        this.pool.acquire(eventLoopCtx, 0, arg_0 -> this.lambda$execute$4(context, cmd, (Promise)promise, arg_0));
        return promise.future();
    }

    public void acquire(final ContextInternal context, final long timeout, final Handler<AsyncResult<PooledConnection>> handler) {
        EventLoopContext eventLoopContext = ConnectionFactoryBase.asEventLoopContext(context);
        class PoolRequest
        implements PoolWaiter.Listener<PooledConnection>,
        Handler<AsyncResult<Lease<PooledConnection>>> {
            private long timerID = -1L;

            PoolRequest() {
            }

            public void handle(AsyncResult<Lease<PooledConnection>> ar) {
                if (this.timerID != -1L) {
                    SqlConnectionPool.this.vertx.cancelTimer(this.timerID);
                }
                if (ar.succeeded()) {
                    Lease lease = (Lease)ar.result();
                    PooledConnection pooled = (PooledConnection)lease.get();
                    pooled.lease = lease;
                    if (!pooled.initialized) {
                        Handler connectionHandler = (Handler)SqlConnectionPool.this.hook.get();
                        if (connectionHandler != null) {
                            pooled.continuation = handler;
                            connectionHandler.handle((Object)pooled);
                            return;
                        }
                        pooled.initialized = true;
                    }
                    handler.handle((Object)Future.succeededFuture((Object)pooled));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }

            public void onEnqueue(PoolWaiter<PooledConnection> waiter) {
                if (timeout > 0L && this.timerID == -1L) {
                    this.timerID = context.setTimer(timeout, id -> SqlConnectionPool.this.pool.cancel(waiter, ar -> {
                        if (ar.succeeded() && ((Boolean)ar.result()).booleanValue()) {
                            handler.handle((Object)Future.failedFuture((String)"Timeout"));
                        }
                    }));
                }
            }

            public void onConnect(PoolWaiter<PooledConnection> waiter) {
                this.onEnqueue(waiter);
            }
        }
        PoolRequest request = new PoolRequest();
        this.pool.acquire(eventLoopContext, (PoolWaiter.Listener)request, 0, (Handler)request);
    }

    public Future<Void> close() {
        PromiseInternal promise = this.vertx.promise();
        this.pool.close(arg_0 -> SqlConnectionPool.lambda$close$5((Promise)promise, arg_0));
        return promise.future();
    }

    public void check(Handler<AsyncResult<List<Integer>>> handler) {
        ArrayList list = new ArrayList();
        this.pool.evict(pred -> {
            list.add(((PooledConnection)pred).num);
            return false;
        }, ar -> handler.handle((Object)Future.succeededFuture((Object)list)));
    }

    private static /* synthetic */ void lambda$close$5(Promise promise, AsyncResult ar) {
        promise.complete();
    }

    private /* synthetic */ void lambda$execute$4(ContextInternal context, CommandBase cmd, Promise promise, AsyncResult ar) {
        if (ar.succeeded()) {
            Lease lease = (Lease)ar.result();
            PooledConnection pooled = (PooledConnection)lease.get();
            pooled.inflight++;
            pooled.num++;
            pooled.schedule(context, cmd).onComplete((Handler)promise).onComplete(v -> {
                pooled.expirationTimestamp = System.currentTimeMillis() + this.idleTimeout;
                pooled.inflight--;
                lease.recycle();
            });
        } else {
            promise.fail(ar.cause());
        }
    }

    public class PooledConnection
    implements Connection,
    Connection.Holder {
        private final ConnectionFactory factory;
        private final Connection conn;
        private final PoolConnector.Listener listener;
        private Connection.Holder holder;
        private Lease<PooledConnection> lease;
        public long expirationTimestamp;
        private int inflight;
        private int num;
        private boolean initialized;
        private Handler<AsyncResult<PooledConnection>> continuation;

        PooledConnection(ConnectionFactory factory, Connection conn, PoolConnector.Listener listener) {
            this.factory = factory;
            this.conn = conn;
            this.listener = listener;
        }

        public ConnectionFactory factory() {
            return this.factory;
        }

        @Override
        public SocketAddress server() {
            return this.conn.server();
        }

        @Override
        public boolean isSsl() {
            return this.conn.isSsl();
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public DatabaseMetadata getDatabaseMetaData() {
            return this.conn.getDatabaseMetaData();
        }

        @Override
        public <R> Future<R> schedule(ContextInternal context, CommandBase<R> cmd) {
            return this.conn.schedule(context, cmd);
        }

        private void close(Promise<Void> promise) {
            this.conn.close(this, promise);
        }

        @Override
        public void init(Connection.Holder holder) {
            if (this.holder != null) {
                throw new IllegalStateException();
            }
            this.holder = holder;
        }

        @Override
        public void close(Connection.Holder holder, Promise<Void> promise) {
            this.doClose(holder, promise);
        }

        private void doClose(Connection.Holder holder, Promise<Void> promise) {
            if (holder != this.holder) {
                String msg = this.holder == null ? "Connection released twice" : "Connection released by " + holder + " owned by " + this.holder;
                promise.fail(msg);
            } else {
                this.holder = null;
                if (!this.initialized) {
                    this.initialized = true;
                    Handler<AsyncResult<PooledConnection>> c = this.continuation;
                    this.continuation = null;
                    c.handle((Object)Future.succeededFuture((Object)this));
                    return;
                }
                Lease<PooledConnection> l = this.lease;
                this.lease = null;
                this.expirationTimestamp = System.currentTimeMillis() + SqlConnectionPool.this.idleTimeout;
                l.recycle();
                promise.complete();
            }
        }

        @Override
        public void handleClosed() {
            Handler<AsyncResult<PooledConnection>> c;
            if (this.holder != null) {
                this.holder.handleClosed();
            }
            if ((c = this.continuation) != null) {
                this.continuation = null;
                c.handle((Object)Future.failedFuture((Throwable)ConnectionBase.CLOSED_EXCEPTION));
            }
            this.listener.onRemove();
        }

        @Override
        public void handleEvent(Object event) {
            if (this.holder != null) {
                this.holder.handleEvent(event);
            }
        }

        @Override
        public void handleException(Throwable err) {
            if (this.holder != null) {
                this.holder.handleException(err);
            }
        }

        @Override
        public int getProcessId() {
            return this.conn.getProcessId();
        }

        @Override
        public int getSecretKey() {
            return this.conn.getSecretKey();
        }
    }
}

