/*
 * Decompiled with CFR 0.152.
 */
package zipkin;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Locale;
import zipkin.internal.JsonCodec;
import zipkin.internal.Nullable;
import zipkin.internal.Util;

public final class Endpoint {
    public final String serviceName;
    public final int ipv4;
    @Nullable
    public final byte[] ipv6;
    @Nullable
    public final Short port;

    @Deprecated
    public static Endpoint create(String serviceName, int ipv4, int port) {
        return new Endpoint(serviceName, ipv4, null, port == 0 ? null : Short.valueOf((short)(port & 0xFFFF)));
    }

    public static Endpoint create(String serviceName, int ipv4) {
        return new Endpoint(serviceName, ipv4, null, null);
    }

    Endpoint(String serviceName, int ipv4, byte[] ipv6, Short port) {
        this.serviceName = Util.checkNotNull(serviceName, "serviceName").isEmpty() ? "" : serviceName.toLowerCase(Locale.ROOT);
        this.ipv4 = ipv4;
        this.ipv6 = ipv6;
        this.port = port;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Endpoint) {
            Endpoint that = (Endpoint)o;
            return this.serviceName.equals(that.serviceName) && this.ipv4 == that.ipv4 && Arrays.equals(this.ipv6, that.ipv6) && Util.equal(this.port, that.port);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.serviceName.hashCode();
        h *= 1000003;
        h ^= this.ipv4;
        h *= 1000003;
        h ^= Arrays.hashCode(this.ipv6);
        h *= 1000003;
        return h ^= this.port == null ? 0 : this.port.hashCode();
    }

    public String toString() {
        return new String(JsonCodec.writeEndpoint(this), Util.UTF_8);
    }

    public static final class Builder {
        private String serviceName;
        private Integer ipv4;
        private byte[] ipv6;
        private Short port;

        Builder() {
        }

        Builder(Endpoint source) {
            this.serviceName = source.serviceName;
            this.ipv4 = source.ipv4;
            this.ipv6 = source.ipv6;
            this.port = source.port;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder ipv4(int ipv4) {
            this.ipv4 = ipv4;
            return this;
        }

        public Builder ipv6(byte[] ipv6) {
            if (ipv6 == null) {
                return this;
            }
            Util.checkArgument(ipv6.length == 16, "ipv6 addresses are 16 bytes: " + ipv6.length, new Object[0]);
            for (int i = 0; i < 10; ++i) {
                if (ipv6[i] == 0) continue;
                this.ipv6 = ipv6;
                return this;
            }
            ByteBuffer buf = ByteBuffer.wrap(ipv6, 10, 6);
            short flag = buf.getShort();
            if (flag == 0 || flag == -1) {
                int ipv4 = buf.getInt();
                if (flag == 0 && ipv4 == 1) {
                    this.ipv6 = ipv6;
                } else {
                    this.ipv4 = ipv4;
                }
            } else {
                this.ipv6 = ipv6;
            }
            return this;
        }

        public Builder port(int port) {
            Util.checkArgument(port >= 0 && port <= 65535, "invalid port %s", port);
            this.port = port == 0 ? null : Short.valueOf((short)(port & 0xFFFF));
            return this;
        }

        public Builder port(Short port) {
            if (port == null || port != 0) {
                this.port = port;
            }
            return this;
        }

        public Endpoint build() {
            return new Endpoint(this.serviceName, this.ipv4 == null ? 0 : this.ipv4, this.ipv6, this.port);
        }
    }
}

