/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import zipkin.DependencyLink;
import zipkin.Span;
import zipkin.internal.ApplyTimestampAndDuration;
import zipkin.internal.CorrectForClockSkew;
import zipkin.internal.DependencyLinker;
import zipkin.internal.GroupByTraceId;
import zipkin.internal.MergeById;
import zipkin.internal.Nullable;
import zipkin.internal.Pair;
import zipkin.internal.Util;
import zipkin.storage.InMemorySpanStore$$Lambda$1;
import zipkin.storage.InMemoryStorage;
import zipkin.storage.QueryRequest;
import zipkin.storage.SpanStore;
import zipkin.storage.StorageAdapters;

public final class InMemorySpanStore
implements SpanStore {
    private final Multimap<Long, Span> traceIdToSpans = new LinkedListMultimap<Long, Span>();
    private final Set<Pair<Long>> traceIdTimeStamps = new TreeSet<Pair<Long>>(VALUE_2_DESCENDING);
    private final Multimap<String, Pair<Long>> serviceToTraceIdTimeStamp = new SortedByValue2Descending<String>();
    private final Multimap<String, String> serviceToSpanNames = new LinkedHashSetMultimap<String, String>();
    private final boolean strictTraceId;
    volatile int acceptedSpanCount;
    final StorageAdapters.SpanConsumer spanConsumer = new StorageAdapters.SpanConsumer(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(List<Span> spans) {
            for (Span span : spans) {
                Long timestamp = ApplyTimestampAndDuration.guessTimestamp(span);
                Pair<Long> traceIdTimeStamp = Pair.create(span.traceId, timestamp == null ? Long.MIN_VALUE : timestamp);
                String spanName = span.name;
                InMemorySpanStore inMemorySpanStore = InMemorySpanStore.this;
                synchronized (inMemorySpanStore) {
                    InMemorySpanStore.this.traceIdTimeStamps.add(traceIdTimeStamp);
                    InMemorySpanStore.this.traceIdToSpans.put(span.traceId, span);
                    ++InMemorySpanStore.this.acceptedSpanCount;
                    for (String serviceName : span.serviceNames()) {
                        InMemorySpanStore.this.serviceToTraceIdTimeStamp.put(serviceName, traceIdTimeStamp);
                        InMemorySpanStore.this.serviceToSpanNames.put(serviceName, spanName);
                    }
                }
            }
        }

        public String toString() {
            return "InMemorySpanConsumer";
        }
    };
    static final Comparator<Pair<Long>> VALUE_2_DESCENDING = InMemorySpanStore$$Lambda$1.lambdaFactory$();

    public InMemorySpanStore() {
        this(new InMemoryStorage.Builder());
    }

    InMemorySpanStore(InMemoryStorage.Builder builder) {
        this.strictTraceId = builder.strictTraceId;
    }

    @Deprecated
    public synchronized List<Long> traceIds() {
        return Util.sortedList(this.traceIdToSpans.keySet());
    }

    synchronized void clear() {
        this.acceptedSpanCount = 0;
        this.traceIdToSpans.clear();
        this.serviceToTraceIdTimeStamp.clear();
    }

    public synchronized List<List<Span>> getRawTraces() {
        ArrayList<List<Span>> result = new ArrayList<List<Span>>();
        for (long traceId : this.traceIdToSpans.keySet()) {
            Collection<Span> sameTraceId = this.traceIdToSpans.get(traceId);
            for (List<Span> next : GroupByTraceId.apply(sameTraceId, this.strictTraceId, false)) {
                result.add(next);
            }
        }
        Collections.sort(result, GroupByTraceId.TRACE_DESCENDING);
        return result;
    }

    @Override
    public synchronized List<List<Span>> getTraces(QueryRequest request) {
        Set<Long> traceIdsInTimerange = this.traceIdsDescendingByTimestamp(request);
        if (traceIdsInTimerange.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<List<Span>> result = new ArrayList<List<Span>>();
        Iterator<Long> traceId = traceIdsInTimerange.iterator();
        while (traceId.hasNext() && result.size() < request.limit) {
            Collection<Span> sameTraceId = this.traceIdToSpans.get(traceId.next());
            for (List<Span> next : GroupByTraceId.apply(sameTraceId, this.strictTraceId, true)) {
                if (!request.test(next)) continue;
                result.add(next);
            }
        }
        Collections.sort(result, GroupByTraceId.TRACE_DESCENDING);
        return result;
    }

    Set<Long> traceIdsDescendingByTimestamp(QueryRequest request) {
        Set<Pair<Long>> traceIdTimestamps = request.serviceName != null ? this.serviceToTraceIdTimeStamp.get(request.serviceName) : this.traceIdTimeStamps;
        long endTs = request.endTs * 1000L;
        long startTs = endTs - request.lookback * 1000L;
        if (traceIdTimestamps == null || traceIdTimestamps.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<Long> result = new LinkedHashSet<Long>();
        for (Pair pair : traceIdTimestamps) {
            if ((Long)pair._2 < startTs && (Long)pair._2 > endTs) continue;
            result.add((Long)pair._1);
        }
        return result;
    }

    @Override
    public List<Span> getTrace(long traceId) {
        return this.getTrace(0L, traceId);
    }

    @Override
    public List<Span> getTrace(long traceIdHigh, long traceIdLow) {
        List<Span> result = this.getRawTrace(traceIdHigh, traceIdLow);
        if (result == null) {
            return null;
        }
        return CorrectForClockSkew.apply(MergeById.apply(result));
    }

    @Override
    public List<Span> getRawTrace(long traceId) {
        return this.getRawTrace(0L, traceId);
    }

    @Override
    public synchronized List<Span> getRawTrace(long traceIdHigh, long traceId) {
        List spans = (List)this.traceIdToSpans.get(traceId);
        if (spans == null || spans.isEmpty()) {
            return null;
        }
        if (!this.strictTraceId) {
            return Util.sortedList(spans);
        }
        ArrayList<Span> filtered = new ArrayList<Span>(spans);
        Iterator iterator = filtered.iterator();
        while (iterator.hasNext()) {
            if (((Span)iterator.next()).traceIdHigh == traceIdHigh) continue;
            iterator.remove();
        }
        return filtered.isEmpty() ? null : filtered;
    }

    @Override
    public synchronized List<String> getServiceNames() {
        return Util.sortedList(this.serviceToTraceIdTimeStamp.keySet());
    }

    @Override
    public synchronized List<String> getSpanNames(String service) {
        if (service == null) {
            return Collections.emptyList();
        }
        service = service.toLowerCase();
        return Util.sortedList(this.serviceToSpanNames.get(service));
    }

    @Override
    public List<DependencyLink> getDependencies(long endTs, @Nullable Long lookback) {
        QueryRequest request = QueryRequest.builder().endTs(endTs).lookback(lookback).limit(Integer.MAX_VALUE).build();
        DependencyLinker linksBuilder = new DependencyLinker();
        for (Collection collection : this.getTraces(request)) {
            linksBuilder.putTrace(collection);
        }
        return linksBuilder.link();
    }

    static /* synthetic */ int lambda$static$0(Pair left, Pair right) {
        int result = ((Long)right._2).compareTo((Long)left._2);
        if (result != 0) {
            return result;
        }
        return ((Long)right._1).compareTo((Long)left._1);
    }

    static abstract class Multimap<K, V> {
        private final Map<K, Collection<V>> delegate = new LinkedHashMap<K, Collection<V>>();

        Multimap() {
        }

        abstract Collection<V> valueContainer();

        Set<K> keySet() {
            return this.delegate.keySet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void put(K key, V value) {
            Collection<V> valueContainer = this.delegate.get(key);
            if (valueContainer == null) {
                Map<K, Collection<V>> map = this.delegate;
                synchronized (map) {
                    if (!this.delegate.containsKey(key)) {
                        valueContainer = this.valueContainer();
                        this.delegate.put(key, valueContainer);
                    }
                }
            }
            valueContainer.add(value);
        }

        void clear() {
            this.delegate.clear();
        }

        Collection<V> get(K key) {
            return this.delegate.get(key);
        }
    }

    static final class LinkedHashSetMultimap<K, V>
    extends Multimap<K, V> {
        LinkedHashSetMultimap() {
        }

        @Override
        Collection<V> valueContainer() {
            return new LinkedHashSet();
        }
    }

    static final class SortedByValue2Descending<K>
    extends Multimap<K, Pair<Long>> {
        SortedByValue2Descending() {
        }

        @Override
        Set<Pair<Long>> valueContainer() {
            return new TreeSet<Pair<Long>>(VALUE_2_DESCENDING);
        }
    }

    static final class LinkedListMultimap<K, V>
    extends Multimap<K, V> {
        LinkedListMultimap() {
        }

        @Override
        Collection<V> valueContainer() {
            return new LinkedList();
        }
    }
}

