/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Constants;
import zipkin.Endpoint;
import zipkin.Span;
import zipkin.internal.ApplyTimestampAndDuration;
import zipkin.internal.Nullable;
import zipkin.internal.Util;

public final class QueryRequest {
    @Nullable
    public final String serviceName;
    @Nullable
    public final String spanName;
    public final List<String> annotations;
    public final Map<String, String> binaryAnnotations;
    @Nullable
    public final Long minDuration;
    @Nullable
    public final Long maxDuration;
    public final long endTs;
    public final long lookback;
    public final int limit;

    @Nullable
    public String toAnnotationQuery() {
        StringBuilder annotationQuery = new StringBuilder();
        Iterator<Object> i = this.binaryAnnotations.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, String> next = i.next();
            annotationQuery.append(next.getKey()).append('=').append(next.getValue());
            if (!i.hasNext() && this.annotations.isEmpty()) continue;
            annotationQuery.append(" and ");
        }
        i = this.annotations.iterator();
        while (i.hasNext()) {
            annotationQuery.append((String)i.next());
            if (!i.hasNext()) continue;
            annotationQuery.append(" and ");
        }
        return annotationQuery.length() > 0 ? annotationQuery.toString() : null;
    }

    QueryRequest(String serviceName, String spanName, List<String> annotations, Map<String, String> binaryAnnotations, Long minDuration, Long maxDuration, long endTs, long lookback, int limit) {
        Util.checkArgument(serviceName == null || !serviceName.isEmpty(), "serviceName was empty", new Object[0]);
        Util.checkArgument(spanName == null || !spanName.isEmpty(), "spanName was empty", new Object[0]);
        Util.checkArgument(endTs > 0L, "endTs should be positive, in epoch microseconds: was %d", endTs);
        Util.checkArgument(limit > 0, "limit should be positive: was %d", limit);
        this.serviceName = serviceName != null ? serviceName.toLowerCase() : null;
        this.spanName = spanName != null ? spanName.toLowerCase() : null;
        this.annotations = annotations;
        for (String string : annotations) {
            Util.checkArgument(!string.isEmpty(), "annotation was empty", new Object[0]);
            Util.checkArgument(!Constants.CORE_ANNOTATIONS.contains(string), "queries cannot be refined by core annotations: %s", string);
        }
        this.binaryAnnotations = binaryAnnotations;
        for (Map.Entry entry : binaryAnnotations.entrySet()) {
            Util.checkArgument(!((String)entry.getKey()).isEmpty(), "binary annotation key was empty", new Object[0]);
            Util.checkArgument(!((String)entry.getValue()).isEmpty(), "binary annotation value for %s was empty", entry.getKey());
        }
        if (minDuration != null) {
            Util.checkArgument(minDuration > 0L, "minDuration must be a positive number of microseconds", new Object[0]);
            this.minDuration = minDuration;
            if (maxDuration != null) {
                Util.checkArgument(maxDuration >= minDuration, "maxDuration should be >= minDuration", new Object[0]);
                this.maxDuration = maxDuration;
            } else {
                this.maxDuration = null;
            }
        } else {
            Util.checkArgument(maxDuration == null, "maxDuration is only valid with minDuration", new Object[0]);
            this.maxDuration = null;
            this.minDuration = null;
        }
        this.endTs = endTs;
        this.lookback = lookback;
        this.limit = limit;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "QueryRequest{serviceName=" + this.serviceName + ", " + "spanName=" + this.spanName + ", " + "annotations=" + this.annotations + ", " + "binaryAnnotations=" + this.binaryAnnotations + ", " + "minDuration=" + this.minDuration + ", " + "maxDuration=" + this.maxDuration + ", " + "endTs=" + this.endTs + ", " + "lookback=" + this.lookback + ", " + "limit=" + this.limit + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof QueryRequest) {
            QueryRequest that = (QueryRequest)o;
            return (this.serviceName == null ? that.serviceName == null : this.serviceName.equals(that.serviceName)) && (this.spanName == null ? that.spanName == null : this.spanName.equals(that.spanName)) && (this.annotations == null ? that.annotations == null : this.annotations.equals(that.annotations)) && (this.binaryAnnotations == null ? that.binaryAnnotations == null : this.binaryAnnotations.equals(that.binaryAnnotations)) && (this.minDuration == null ? that.minDuration == null : this.minDuration.equals(that.minDuration)) && (this.maxDuration == null ? that.maxDuration == null : this.maxDuration.equals(that.maxDuration)) && this.endTs == that.endTs && this.lookback == that.lookback && this.limit == that.limit;
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.serviceName == null ? 0 : this.serviceName.hashCode();
        h *= 1000003;
        h ^= this.spanName == null ? 0 : this.spanName.hashCode();
        h *= 1000003;
        h ^= this.annotations == null ? 0 : this.annotations.hashCode();
        h *= 1000003;
        h ^= this.binaryAnnotations == null ? 0 : this.binaryAnnotations.hashCode();
        h *= 1000003;
        h ^= this.minDuration == null ? 0 : this.minDuration.hashCode();
        h *= 1000003;
        h ^= this.maxDuration == null ? 0 : this.maxDuration.hashCode();
        h *= 1000003;
        h = (int)((long)h ^ (this.endTs >>> 32 ^ this.endTs));
        h *= 1000003;
        h = (int)((long)h ^ (this.lookback >>> 32 ^ this.lookback));
        h *= 1000003;
        return h ^= this.limit;
    }

    public boolean test(List<Span> spans) {
        Long timestamp = ApplyTimestampAndDuration.guessTimestamp(spans.get(0));
        if (timestamp == null || timestamp < (this.endTs - this.lookback) * 1000L || timestamp > this.endTs * 1000L) {
            return false;
        }
        LinkedHashSet<String> serviceNames = new LinkedHashSet<String>();
        boolean testedDuration = this.minDuration == null && this.maxDuration == null;
        String spanNameToMatch = this.spanName;
        LinkedHashSet<String> annotationsToMatch = new LinkedHashSet<String>(this.annotations);
        LinkedHashMap<String, String> binaryAnnotationsToMatch = new LinkedHashMap<String, String>(this.binaryAnnotations);
        LinkedHashSet<String> currentServiceNames = new LinkedHashSet<String>();
        for (Span span : spans) {
            currentServiceNames.clear();
            for (Annotation a : span.annotations) {
                if (QueryRequest.appliesToServiceName(a.endpoint, this.serviceName)) {
                    annotationsToMatch.remove(a.value);
                }
                if (a.endpoint == null) continue;
                serviceNames.add(a.endpoint.serviceName);
                currentServiceNames.add(a.endpoint.serviceName);
            }
            for (BinaryAnnotation b : span.binaryAnnotations) {
                if (QueryRequest.appliesToServiceName(b.endpoint, this.serviceName) && b.type == BinaryAnnotation.Type.STRING && new String(b.value, Util.UTF_8).equals(binaryAnnotationsToMatch.get(b.key))) {
                    binaryAnnotationsToMatch.remove(b.key);
                }
                if (b.endpoint == null) continue;
                serviceNames.add(b.endpoint.serviceName);
                currentServiceNames.add(b.endpoint.serviceName);
            }
            if ((this.serviceName == null || currentServiceNames.contains(this.serviceName)) && !testedDuration) {
                if (this.minDuration != null && this.maxDuration != null) {
                    testedDuration = span.duration >= this.minDuration && span.duration <= this.maxDuration;
                } else if (this.minDuration != null) {
                    boolean bl = testedDuration = span.duration >= this.minDuration;
                }
            }
            if (!span.name.equals(spanNameToMatch)) continue;
            spanNameToMatch = null;
        }
        return (this.serviceName == null || serviceNames.contains(this.serviceName)) && spanNameToMatch == null && annotationsToMatch.isEmpty() && binaryAnnotationsToMatch.isEmpty() && testedDuration;
    }

    private static boolean appliesToServiceName(Endpoint endpoint, String serviceName) {
        return serviceName == null || endpoint == null || endpoint.serviceName.equals(serviceName);
    }

    public static final class Builder {
        private String serviceName;
        private String spanName;
        private List<String> annotations = new LinkedList<String>();
        private Map<String, String> binaryAnnotations = new LinkedHashMap<String, String>();
        private Long minDuration;
        private Long maxDuration;
        private Long endTs;
        private Long lookback;
        private Integer limit;

        Builder() {
        }

        Builder(QueryRequest source) {
            this.serviceName = source.serviceName;
            this.spanName = source.spanName;
            this.annotations = source.annotations;
            this.binaryAnnotations = source.binaryAnnotations;
            this.minDuration = source.minDuration;
            this.maxDuration = source.maxDuration;
            this.endTs = source.endTs;
            this.lookback = source.lookback;
            this.limit = source.limit;
        }

        public Builder serviceName(@Nullable String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder spanName(@Nullable String spanName) {
            this.spanName = "all".equals(spanName) ? null : spanName;
            return this;
        }

        public Builder parseAnnotationQuery(String annotationQuery) {
            if (annotationQuery != null && !annotationQuery.isEmpty()) {
                for (String ann : annotationQuery.split(" and ")) {
                    int idx = ann.indexOf(61);
                    if (idx == -1) {
                        this.addAnnotation(ann);
                        continue;
                    }
                    String[] keyValue = ann.split("=");
                    this.addBinaryAnnotation(ann.substring(0, idx), keyValue.length < 2 ? "" : ann.substring(idx + 1));
                }
            }
            return this;
        }

        public Builder addAnnotation(String annotation) {
            this.annotations.add(annotation);
            return this;
        }

        public Builder addBinaryAnnotation(String key, String value) {
            this.binaryAnnotations.put(key, value);
            return this;
        }

        public Builder minDuration(Long minDuration) {
            this.minDuration = minDuration;
            return this;
        }

        public Builder maxDuration(Long maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public Builder endTs(Long endTs) {
            this.endTs = endTs;
            return this;
        }

        public Builder lookback(Long lookback) {
            this.lookback = lookback;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public QueryRequest build() {
            long selectedEndTs = this.endTs == null ? System.currentTimeMillis() : this.endTs;
            return new QueryRequest(this.serviceName, this.spanName, this.annotations, this.binaryAnnotations, this.minDuration, this.maxDuration, selectedEndTs, Math.min(this.lookback == null ? selectedEndTs : this.lookback, selectedEndTs), this.limit == null ? 10 : this.limit);
        }
    }
}

