/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Codec;
import zipkin.DependencyLink;
import zipkin.Endpoint;
import zipkin.Span;
import zipkin.internal.Base64;
import zipkin.internal.Buffer;
import zipkin.internal.Util;
import zipkin.internal.gson.stream.JsonReader;
import zipkin.internal.gson.stream.JsonToken;
import zipkin.internal.gson.stream.MalformedJsonException;

public final class JsonCodec
implements Codec {
    static final long MAX_SAFE_INTEGER = 0x1FFFFFFFFFFFFFL;
    static final String ENDPOINT_HEADER = ",\"endpoint\":";
    static final JsonAdapter<Endpoint> ENDPOINT_ADAPTER = new JsonAdapter<Endpoint>(){

        @Override
        public Endpoint fromJson(JsonReader reader) throws IOException {
            Endpoint.Builder result = Endpoint.builder();
            reader.beginObject();
            while (reader.hasNext()) {
                String nextName = reader.nextName();
                if (nextName.equals("serviceName")) {
                    result.serviceName(reader.nextString());
                    continue;
                }
                if (nextName.equals("ipv4") || nextName.equals("ipv6")) {
                    result.parseIp(reader.nextString());
                    continue;
                }
                if (nextName.equals("port")) {
                    result.port(reader.nextInt());
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            return result.build();
        }

        @Override
        public int sizeInBytes(Endpoint value) {
            int sizeInBytes = 0;
            sizeInBytes += Buffer.asciiSizeInBytes("{\"serviceName\":\"");
            sizeInBytes += Buffer.jsonEscapedSizeInBytes(value.serviceName) + 1;
            if (value.ipv4 != 0) {
                sizeInBytes += Buffer.asciiSizeInBytes(",\"ipv4\":\"");
                sizeInBytes += Buffer.asciiSizeInBytes(value.ipv4 >> 24 & 0xFF) + 1;
                sizeInBytes += Buffer.asciiSizeInBytes(value.ipv4 >> 16 & 0xFF) + 1;
                sizeInBytes += Buffer.asciiSizeInBytes(value.ipv4 >> 8 & 0xFF) + 1;
                sizeInBytes += Buffer.asciiSizeInBytes(value.ipv4 & 0xFF) + 1;
            }
            if (value.port != null && value.port != 0) {
                sizeInBytes += Buffer.asciiSizeInBytes(",\"port\":") + Buffer.asciiSizeInBytes(value.port & 0xFFFF);
            }
            if (value.ipv6 != null) {
                sizeInBytes += Buffer.asciiSizeInBytes(",\"ipv6\":\"") + Buffer.ipv6SizeInBytes(value.ipv6) + 1;
            }
            return ++sizeInBytes;
        }

        @Override
        public void write(Endpoint value, Buffer b) {
            b.writeAscii("{\"serviceName\":\"");
            b.writeJsonEscaped(value.serviceName).writeByte(34);
            if (value.ipv4 != 0) {
                b.writeAscii(",\"ipv4\":\"");
                b.writeAscii(value.ipv4 >> 24 & 0xFF).writeByte(46);
                b.writeAscii(value.ipv4 >> 16 & 0xFF).writeByte(46);
                b.writeAscii(value.ipv4 >> 8 & 0xFF).writeByte(46);
                b.writeAscii(value.ipv4 & 0xFF).writeByte(34);
            }
            if (value.port != null && value.port != 0) {
                b.writeAscii(",\"port\":").writeAscii((long)(value.port & 0xFFFF));
            }
            if (value.ipv6 != null) {
                b.writeAscii(",\"ipv6\":\"").writeIpV6(value.ipv6).writeByte(34);
            }
            b.writeByte(125);
        }
    };
    static final JsonAdapter<Annotation> ANNOTATION_ADAPTER = new JsonAdapter<Annotation>(){

        @Override
        public Annotation fromJson(JsonReader reader) throws IOException {
            Annotation.Builder result = Annotation.builder();
            reader.beginObject();
            while (reader.hasNext()) {
                String nextName = reader.nextName();
                if (nextName.equals("timestamp")) {
                    result.timestamp(reader.nextLong());
                    continue;
                }
                if (nextName.equals("value")) {
                    result.value(reader.nextString());
                    continue;
                }
                if (nextName.equals("endpoint") && reader.peek() != JsonToken.NULL) {
                    result.endpoint(ENDPOINT_ADAPTER.fromJson(reader));
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            return result.build();
        }

        @Override
        public int sizeInBytes(Annotation value) {
            int sizeInBytes = 0;
            sizeInBytes += Buffer.asciiSizeInBytes("{\"timestamp\":") + Buffer.asciiSizeInBytes(value.timestamp);
            sizeInBytes += Buffer.asciiSizeInBytes(",\"value\":\"") + Buffer.jsonEscapedSizeInBytes(value.value) + 1;
            if (value.endpoint != null) {
                sizeInBytes += JsonCodec.ENDPOINT_HEADER.length() + ENDPOINT_ADAPTER.sizeInBytes(value.endpoint);
            }
            return ++sizeInBytes;
        }

        @Override
        public void write(Annotation value, Buffer b) {
            b.writeAscii("{\"timestamp\":").writeAscii(value.timestamp);
            b.writeAscii(",\"value\":\"").writeJsonEscaped(value.value).writeByte(34);
            if (value.endpoint != null) {
                b.writeAscii(JsonCodec.ENDPOINT_HEADER);
                ENDPOINT_ADAPTER.write(value.endpoint, b);
            }
            b.writeByte(125);
        }
    };
    static final JsonAdapter<BinaryAnnotation> BINARY_ANNOTATION_ADAPTER = new JsonAdapter<BinaryAnnotation>(){

        @Override
        public BinaryAnnotation fromJson(JsonReader reader) throws IOException {
            byte[] value;
            BinaryAnnotation.Builder result = BinaryAnnotation.builder();
            String key = null;
            BinaryAnnotation.Type type = BinaryAnnotation.Type.STRING;
            boolean valueSet = false;
            String number = null;
            String string = null;
            reader.beginObject();
            block10: while (reader.hasNext()) {
                String nextName = reader.nextName();
                if (nextName.equals("key")) {
                    key = reader.nextString();
                    result.key(key);
                    continue;
                }
                if (nextName.equals("value")) {
                    valueSet = true;
                    switch (reader.peek()) {
                        case BOOLEAN: {
                            byte[] byArray;
                            type = BinaryAnnotation.Type.BOOL;
                            if (reader.nextBoolean()) {
                                byte[] byArray2 = new byte[1];
                                byArray = byArray2;
                                byArray2[0] = 1;
                            } else {
                                byte[] byArray3 = new byte[1];
                                byArray = byArray3;
                                byArray3[0] = 0;
                            }
                            result.value(byArray);
                            continue block10;
                        }
                        case STRING: {
                            string = reader.nextString();
                            continue block10;
                        }
                        case NUMBER: {
                            number = reader.nextString();
                            continue block10;
                        }
                    }
                    throw new MalformedJsonException("Expected value to be a boolean, string or number but was " + (Object)((Object)reader.peek()) + " at path " + reader.getPath());
                }
                if (nextName.equals("type")) {
                    type = BinaryAnnotation.Type.valueOf(reader.nextString());
                    continue;
                }
                if (nextName.equals("endpoint") && reader.peek() != JsonToken.NULL) {
                    result.endpoint(ENDPOINT_ADAPTER.fromJson(reader));
                    continue;
                }
                reader.skipValue();
            }
            if (key == null) {
                throw new MalformedJsonException("No key at " + reader.getPath());
            }
            if (!valueSet) {
                throw new MalformedJsonException("No value for key " + key + " at " + reader.getPath());
            }
            reader.endObject();
            result.type(type);
            switch (type) {
                case BOOL: {
                    return result.build();
                }
                case STRING: {
                    return result.value(string.getBytes(Util.UTF_8)).build();
                }
                case BYTES: {
                    return result.value(Base64.decode(string)).build();
                }
            }
            if (type == BinaryAnnotation.Type.I16) {
                short v = Short.parseShort(number);
                value = ByteBuffer.allocate(2).putShort(0, v).array();
            } else if (type == BinaryAnnotation.Type.I32) {
                int v = Integer.parseInt(number);
                value = ByteBuffer.allocate(4).putInt(0, v).array();
            } else if (type == BinaryAnnotation.Type.I64 || type == BinaryAnnotation.Type.DOUBLE) {
                if (number == null) {
                    number = string;
                }
                long v = type == BinaryAnnotation.Type.I64 ? Long.parseLong(number) : Double.doubleToRawLongBits(Double.parseDouble(number));
                value = ByteBuffer.allocate(8).putLong(0, v).array();
            } else {
                throw new AssertionError((Object)("BinaryAnnotationType " + (Object)((Object)type) + " was added, but not handled"));
            }
            return result.value(value).build();
        }

        @Override
        public int sizeInBytes(BinaryAnnotation value) {
            int sizeInBytes = 0;
            sizeInBytes += Buffer.asciiSizeInBytes("{\"key\":\"") + Buffer.jsonEscapedSizeInBytes(value.key);
            sizeInBytes += Buffer.asciiSizeInBytes("\",\"value\":");
            switch (value.type) {
                case BOOL: {
                    sizeInBytes += Buffer.asciiSizeInBytes(value.value[0] == 1 ? "true" : "false");
                    break;
                }
                case STRING: {
                    sizeInBytes += Buffer.jsonEscapedSizeInBytes(value.value) + 2;
                    break;
                }
                case BYTES: {
                    sizeInBytes += Buffer.base64UrlSizeInBytes(value.value) + 2;
                    break;
                }
                case I16: {
                    sizeInBytes += Buffer.asciiSizeInBytes(ByteBuffer.wrap(value.value).getShort());
                    break;
                }
                case I32: {
                    sizeInBytes += Buffer.asciiSizeInBytes(ByteBuffer.wrap(value.value).getInt());
                    break;
                }
                case I64: {
                    long number = ByteBuffer.wrap(value.value).getLong();
                    sizeInBytes += Buffer.asciiSizeInBytes(number);
                    if (number <= 0x1FFFFFFFFFFFFFL) break;
                    sizeInBytes += 2;
                    break;
                }
                case DOUBLE: {
                    double wrapped = Double.longBitsToDouble(ByteBuffer.wrap(value.value).getLong());
                    sizeInBytes += Buffer.asciiSizeInBytes(Double.toString(wrapped));
                    break;
                }
            }
            if (value.type != BinaryAnnotation.Type.STRING && value.type != BinaryAnnotation.Type.BOOL) {
                sizeInBytes += Buffer.asciiSizeInBytes(",\"type\":\"") + Buffer.utf8SizeInBytes(value.type.name()) + 1;
            }
            if (value.endpoint != null) {
                sizeInBytes += JsonCodec.ENDPOINT_HEADER.length() + ENDPOINT_ADAPTER.sizeInBytes(value.endpoint);
            }
            return ++sizeInBytes;
        }

        @Override
        public void write(BinaryAnnotation value, Buffer b) {
            b.writeAscii("{\"key\":\"").writeJsonEscaped(value.key);
            b.writeAscii("\",\"value\":");
            switch (value.type) {
                case BOOL: {
                    b.writeAscii(value.value[0] == 1 ? "true" : "false");
                    break;
                }
                case STRING: {
                    b.writeByte(34).writeJsonEscaped(value.value).writeByte(34);
                    break;
                }
                case BYTES: {
                    b.writeByte(34).writeBase64Url(value.value).writeByte(34);
                    break;
                }
                case I16: {
                    b.writeAscii(ByteBuffer.wrap(value.value).getShort());
                    break;
                }
                case I32: {
                    b.writeAscii(ByteBuffer.wrap(value.value).getInt());
                    break;
                }
                case I64: {
                    long number = ByteBuffer.wrap(value.value).getLong();
                    if (number > 0x1FFFFFFFFFFFFFL) {
                        b.writeByte(34);
                    }
                    b.writeAscii(number);
                    if (number <= 0x1FFFFFFFFFFFFFL) break;
                    b.writeByte(34);
                    break;
                }
                case DOUBLE: {
                    double wrapped = Double.longBitsToDouble(ByteBuffer.wrap(value.value).getLong());
                    b.writeAscii(Double.toString(wrapped));
                    break;
                }
            }
            if (value.type != BinaryAnnotation.Type.STRING && value.type != BinaryAnnotation.Type.BOOL) {
                b.writeAscii(",\"type\":\"").writeAscii(value.type.name()).writeByte(34);
            }
            if (value.endpoint != null) {
                b.writeAscii(JsonCodec.ENDPOINT_HEADER);
                ENDPOINT_ADAPTER.write(value.endpoint, b);
            }
            b.writeByte(125);
        }
    };
    static final JsonAdapter<Span> SPAN_ADAPTER = new JsonAdapter<Span>(){

        @Override
        public Span fromJson(JsonReader reader) throws IOException {
            Span.Builder result = Span.builder();
            reader.beginObject();
            while (reader.hasNext()) {
                String nextName = reader.nextName();
                if (nextName.equals("traceId")) {
                    String traceId = reader.nextString();
                    if (traceId.length() == 32) {
                        result.traceIdHigh(Util.lowerHexToUnsignedLong(traceId, 0));
                    }
                    result.traceId(Util.lowerHexToUnsignedLong(traceId));
                    continue;
                }
                if (nextName.equals("name")) {
                    result.name(reader.nextString());
                    continue;
                }
                if (nextName.equals("id")) {
                    result.id(Util.lowerHexToUnsignedLong(reader.nextString()));
                    continue;
                }
                if (nextName.equals("parentId") && reader.peek() != JsonToken.NULL) {
                    result.parentId(Util.lowerHexToUnsignedLong(reader.nextString()));
                    continue;
                }
                if (nextName.equals("timestamp") && reader.peek() != JsonToken.NULL) {
                    result.timestamp(reader.nextLong());
                    continue;
                }
                if (nextName.equals("duration") && reader.peek() != JsonToken.NULL) {
                    result.duration(reader.nextLong());
                    continue;
                }
                if (nextName.equals("annotations")) {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        result.addAnnotation(ANNOTATION_ADAPTER.fromJson(reader));
                    }
                    reader.endArray();
                    continue;
                }
                if (nextName.equals("binaryAnnotations")) {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        result.addBinaryAnnotation(BINARY_ANNOTATION_ADAPTER.fromJson(reader));
                    }
                    reader.endArray();
                    continue;
                }
                if (nextName.equals("debug") && reader.peek() != JsonToken.NULL) {
                    if (!reader.nextBoolean()) continue;
                    result.debug(true);
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            return result.build();
        }

        @Override
        public int sizeInBytes(Span value) {
            int sizeInBytes = 0;
            if (value.traceIdHigh != 0L) {
                sizeInBytes += 16;
            }
            sizeInBytes += Buffer.asciiSizeInBytes("{\"traceId\":\"") + 16;
            sizeInBytes += Buffer.asciiSizeInBytes("\",\"id\":\"") + 16;
            sizeInBytes += Buffer.asciiSizeInBytes("\",\"name\":\"") + Buffer.jsonEscapedSizeInBytes(value.name) + 1;
            if (value.parentId != null) {
                sizeInBytes += Buffer.asciiSizeInBytes(",\"parentId\":\"") + 16 + 1;
            }
            if (value.timestamp != null) {
                sizeInBytes += Buffer.asciiSizeInBytes(",\"timestamp\":") + Buffer.asciiSizeInBytes(value.timestamp);
            }
            if (value.duration != null) {
                sizeInBytes += Buffer.asciiSizeInBytes(",\"duration\":") + Buffer.asciiSizeInBytes(value.duration);
            }
            if (!value.annotations.isEmpty()) {
                sizeInBytes += Buffer.asciiSizeInBytes(",\"annotations\":");
                sizeInBytes += JsonCodec.sizeInBytes(ANNOTATION_ADAPTER, value.annotations);
            }
            if (!value.binaryAnnotations.isEmpty()) {
                sizeInBytes += Buffer.asciiSizeInBytes(",\"binaryAnnotations\":");
                sizeInBytes += JsonCodec.sizeInBytes(BINARY_ANNOTATION_ADAPTER, value.binaryAnnotations);
            }
            if (value.debug != null && value.debug.booleanValue()) {
                sizeInBytes += Buffer.asciiSizeInBytes(",\"debug\":true");
            }
            return ++sizeInBytes;
        }

        @Override
        public void write(Span value, Buffer b) {
            b.writeAscii("{\"traceId\":\"");
            if (value.traceIdHigh != 0L) {
                b.writeLowerHex(value.traceIdHigh);
            }
            b.writeLowerHex(value.traceId);
            b.writeAscii("\",\"id\":\"").writeLowerHex(value.id);
            b.writeAscii("\",\"name\":\"").writeJsonEscaped(value.name).writeByte(34);
            if (value.parentId != null) {
                b.writeAscii(",\"parentId\":\"").writeLowerHex(value.parentId).writeByte(34);
            }
            if (value.timestamp != null) {
                b.writeAscii(",\"timestamp\":").writeAscii(value.timestamp);
            }
            if (value.duration != null) {
                b.writeAscii(",\"duration\":").writeAscii(value.duration);
            }
            if (!value.annotations.isEmpty()) {
                b.writeAscii(",\"annotations\":");
                JsonCodec.writeList(ANNOTATION_ADAPTER, value.annotations, b);
            }
            if (!value.binaryAnnotations.isEmpty()) {
                b.writeAscii(",\"binaryAnnotations\":");
                JsonCodec.writeList(BINARY_ANNOTATION_ADAPTER, value.binaryAnnotations, b);
            }
            if (value.debug != null && value.debug.booleanValue()) {
                b.writeAscii(",\"debug\":true");
            }
            b.writeByte(125);
        }

        public String toString() {
            return "Span";
        }
    };
    static final JsonAdapter<DependencyLink> DEPENDENCY_LINK_ADAPTER = new JsonAdapter<DependencyLink>(){

        @Override
        public DependencyLink fromJson(JsonReader reader) throws IOException {
            DependencyLink.Builder result = DependencyLink.builder();
            reader.beginObject();
            while (reader.hasNext()) {
                String nextName = reader.nextName();
                if (nextName.equals("parent")) {
                    result.parent(reader.nextString());
                    continue;
                }
                if (nextName.equals("child")) {
                    result.child(reader.nextString());
                    continue;
                }
                if (nextName.equals("callCount")) {
                    result.callCount(reader.nextLong());
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            return result.build();
        }

        @Override
        public int sizeInBytes(DependencyLink value) {
            int sizeInBytes = 0;
            sizeInBytes += Buffer.asciiSizeInBytes("{\"parent\":\"") + Buffer.jsonEscapedSizeInBytes(value.parent);
            sizeInBytes += Buffer.asciiSizeInBytes("\",\"child\":\"") + Buffer.jsonEscapedSizeInBytes(value.child);
            sizeInBytes += Buffer.asciiSizeInBytes("\",\"callCount\":") + Buffer.asciiSizeInBytes(value.callCount);
            return ++sizeInBytes;
        }

        @Override
        public void write(DependencyLink value, Buffer b) {
            b.writeAscii("{\"parent\":\"").writeJsonEscaped(value.parent);
            b.writeAscii("\",\"child\":\"").writeJsonEscaped(value.child);
            b.writeAscii("\",\"callCount\":").writeAscii(value.callCount).writeByte(125);
        }

        public String toString() {
            return "DependencyLink";
        }
    };
    static final JsonAdapter<String> STRING_ADAPTER = new JsonAdapter<String>(){

        @Override
        public String fromJson(JsonReader reader) throws IOException {
            return reader.nextString();
        }

        @Override
        public int sizeInBytes(String value) {
            return Buffer.jsonEscapedSizeInBytes(value) + 2;
        }

        @Override
        public void write(String value, Buffer buffer) {
            buffer.writeByte(34).writeJsonEscaped(value).writeByte(34);
        }
    };

    @Override
    public Span readSpan(byte[] bytes) {
        Util.checkArgument(bytes.length > 0, "Empty input reading Span", new Object[0]);
        try {
            return SPAN_ADAPTER.fromJson(JsonCodec.jsonReader(bytes));
        }
        catch (Exception e) {
            throw JsonCodec.exceptionReading("Span", bytes, e);
        }
    }

    @Override
    public int sizeInBytes(Span value) {
        return SPAN_ADAPTER.sizeInBytes(value);
    }

    @Override
    public byte[] writeSpan(Span value) {
        return JsonCodec.write(SPAN_ADAPTER, value);
    }

    public static byte[] writeEndpoint(Endpoint value) {
        return JsonCodec.write(ENDPOINT_ADAPTER, value);
    }

    public static String escape(String value) {
        return Buffer.jsonEscape(value);
    }

    @Override
    public List<Span> readSpans(byte[] bytes) {
        Util.checkArgument(bytes.length > 0, "Empty input reading List<Span>", new Object[0]);
        return JsonCodec.readList(SPAN_ADAPTER, bytes);
    }

    @Override
    public byte[] writeSpans(List<Span> value) {
        if (value.isEmpty()) {
            return new byte[]{91, 93};
        }
        Buffer result = new Buffer(JsonCodec.sizeInBytes(SPAN_ADAPTER, value));
        JsonCodec.writeList(SPAN_ADAPTER, value, result);
        return result.toByteArray();
    }

    @Override
    public byte[] writeTraces(List<List<Span>> traces) {
        int sizeInBytes = JsonCodec.overheadInBytes(traces);
        for (int i = 0; i < traces.size(); ++i) {
            List<Span> spans = traces.get(i);
            sizeInBytes += JsonCodec.overheadInBytes(spans);
            for (int j = 0; j < spans.size(); ++j) {
                sizeInBytes += SPAN_ADAPTER.sizeInBytes(spans.get(j));
            }
        }
        Buffer out = new Buffer(sizeInBytes);
        out.writeByte(91);
        Iterator<List<Span>> trace = traces.iterator();
        while (trace.hasNext()) {
            JsonCodec.writeList(SPAN_ADAPTER, trace.next(), out);
            if (!trace.hasNext()) continue;
            out.writeByte(44);
        }
        out.writeByte(93);
        return out.toByteArray();
    }

    public List<List<Span>> readTraces(byte[] bytes) {
        JsonReader reader = JsonCodec.jsonReader(bytes);
        LinkedList<List<Span>> result = new LinkedList<List<Span>>();
        try {
            reader.beginArray();
            while (reader.hasNext()) {
                reader.beginArray();
                LinkedList<Span> trace = new LinkedList<Span>();
                while (reader.hasNext()) {
                    trace.add(SPAN_ADAPTER.fromJson(reader));
                }
                reader.endArray();
                result.add(trace);
            }
            reader.endArray();
            return result;
        }
        catch (Exception e) {
            throw JsonCodec.exceptionReading("List<List<Span>>", bytes, e);
        }
    }

    @Override
    public DependencyLink readDependencyLink(byte[] bytes) {
        Util.checkArgument(bytes.length > 0, "Empty input reading DependencyLink", new Object[0]);
        try {
            return DEPENDENCY_LINK_ADAPTER.fromJson(JsonCodec.jsonReader(bytes));
        }
        catch (Exception e) {
            throw JsonCodec.exceptionReading("Span", bytes, e);
        }
    }

    @Override
    public byte[] writeDependencyLink(DependencyLink value) {
        return JsonCodec.write(DEPENDENCY_LINK_ADAPTER, value);
    }

    @Override
    public List<DependencyLink> readDependencyLinks(byte[] bytes) {
        Util.checkArgument(bytes.length > 0, "Empty input reading List<DependencyLink>", new Object[0]);
        return JsonCodec.readList(DEPENDENCY_LINK_ADAPTER, bytes);
    }

    @Override
    public byte[] writeDependencyLinks(List<DependencyLink> value) {
        Buffer result = new Buffer(JsonCodec.sizeInBytes(DEPENDENCY_LINK_ADAPTER, value));
        JsonCodec.writeList(DEPENDENCY_LINK_ADAPTER, value, result);
        return result.toByteArray();
    }

    public List<String> readStrings(byte[] bytes) {
        Util.checkArgument(bytes.length > 0, "Empty input reading List<String>", new Object[0]);
        return JsonCodec.readList(STRING_ADAPTER, bytes);
    }

    public byte[] writeStrings(List<String> value) {
        Buffer result = new Buffer(JsonCodec.sizeInBytes(STRING_ADAPTER, value));
        JsonCodec.writeList(STRING_ADAPTER, value, result);
        return result.toByteArray();
    }

    static <T> List<T> readList(JsonAdapter<T> adapter, byte[] bytes) {
        JsonReader reader = JsonCodec.jsonReader(bytes);
        try {
            reader.beginArray();
            List result = reader.hasNext() ? new LinkedList() : Collections.emptyList();
            while (reader.hasNext()) {
                result.add(adapter.fromJson(reader));
            }
            reader.endArray();
            return result;
        }
        catch (Exception e) {
            throw JsonCodec.exceptionReading("List<" + adapter + ">", bytes, e);
        }
    }

    private static JsonReader jsonReader(byte[] bytes) {
        return new JsonReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), Util.UTF_8));
    }

    static <T> byte[] write(Buffer.Writer<T> writer, T value) {
        Buffer b = new Buffer(writer.sizeInBytes(value));
        try {
            writer.write(value, b);
        }
        catch (RuntimeException e) {
            byte[] bytesWritten;
            byte[] bytes = b.toByteArray();
            int lengthWritten = bytes.length;
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] != 0) continue;
                lengthWritten = i;
                break;
            }
            if (lengthWritten == bytes.length) {
                bytesWritten = bytes;
            } else {
                bytesWritten = new byte[lengthWritten];
                System.arraycopy(bytes, 0, bytesWritten, 0, lengthWritten);
            }
            String written = new String(bytesWritten, Util.UTF_8);
            String message = String.format("Bug found using %s to write %s as json. Wrote %s/%s bytes: %s", writer.getClass().getSimpleName(), value.getClass().getSimpleName(), lengthWritten, bytes.length, written);
            throw Util.assertionError(message, e);
        }
        return b.toByteArray();
    }

    static <T> int sizeInBytes(Buffer.Writer<T> writer, List<T> value) {
        int sizeInBytes = JsonCodec.overheadInBytes(value);
        int length = value.size();
        for (int i = 0; i < length; ++i) {
            sizeInBytes += writer.sizeInBytes(value.get(i));
        }
        return sizeInBytes;
    }

    static <T> int overheadInBytes(List<T> value) {
        int sizeInBytes = 2;
        if (value.size() > 1) {
            sizeInBytes += value.size() - 1;
        }
        return sizeInBytes;
    }

    static <T> void writeList(Buffer.Writer<T> writer, List<T> value, Buffer b) {
        b.writeByte(91);
        int i = 0;
        int length = value.size();
        while (i < length) {
            writer.write(value.get(i++), b);
            if (i >= length) continue;
            b.writeByte(44);
        }
        b.writeByte(93);
    }

    static IllegalArgumentException exceptionReading(String type, byte[] bytes, Exception e) {
        String cause;
        String string = cause = e.getMessage() == null ? "Error" : e.getMessage();
        if (cause.indexOf("malformed") != -1) {
            cause = "Malformed";
        }
        String message = String.format("%s reading %s from json: %s", cause, type, new String(bytes, Util.UTF_8));
        throw new IllegalArgumentException(message, e);
    }

    static abstract class JsonAdapter<T>
    implements Buffer.Writer<T> {
        JsonAdapter() {
        }

        abstract T fromJson(JsonReader var1) throws IOException;
    }
}

