/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server;

import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.GaugeService;
import zipkin.collector.CollectorMetrics;
import zipkin.internal.Nullable;
import zipkin.internal.Util;

final class ActuateCollectorMetrics
implements CollectorMetrics {
    private final CounterService counterService;
    private final GaugeService gaugeService;
    private final String messages;
    private final String messagesDropped;
    private final String messageBytes;
    private final String messageSpans;
    private final String bytes;
    private final String spans;
    private final String spansDropped;

    ActuateCollectorMetrics(CounterService counterService, GaugeService gaugeService) {
        this(counterService, gaugeService, null);
    }

    ActuateCollectorMetrics(CounterService counterService, GaugeService gaugeService, @Nullable String transport) {
        this.counterService = counterService;
        this.gaugeService = gaugeService;
        String footer = transport == null ? "" : "." + transport;
        this.messages = "zipkin_collector.messages" + footer;
        this.messagesDropped = "zipkin_collector.messages_dropped" + footer;
        this.messageBytes = "zipkin_collector.message_bytes" + footer;
        this.messageSpans = "zipkin_collector.message_spans" + footer;
        this.bytes = "zipkin_collector.bytes" + footer;
        this.spans = "zipkin_collector.spans" + footer;
        this.spansDropped = "zipkin_collector.spans_dropped" + footer;
    }

    public ActuateCollectorMetrics forTransport(String transportType) {
        Util.checkNotNull((Object)transportType, (String)"transportType");
        return new ActuateCollectorMetrics(this.counterService, this.gaugeService, transportType);
    }

    public void incrementMessages() {
        this.counterService.increment(this.messages);
    }

    public void incrementMessagesDropped() {
        this.counterService.increment(this.messagesDropped);
    }

    public void incrementSpans(int quantity) {
        this.gaugeService.submit(this.messageSpans, (double)quantity);
        for (int i = 0; i < quantity; ++i) {
            this.counterService.increment(this.spans);
        }
    }

    public void incrementBytes(int quantity) {
        this.gaugeService.submit(this.messageBytes, (double)quantity);
        for (int i = 0; i < quantity; ++i) {
            this.counterService.increment(this.bytes);
        }
    }

    public void incrementSpansDropped(int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.counterService.increment(this.spansDropped);
        }
    }

    void reset() {
        this.counterService.reset(this.messages);
        this.counterService.reset(this.messagesDropped);
        this.counterService.reset(this.bytes);
        this.counterService.reset(this.spans);
        this.counterService.reset(this.spansDropped);
        this.gaugeService.submit(this.messageSpans, 0.0);
        this.gaugeService.submit(this.messageBytes, 0.0);
    }
}

