/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.atomic.AtomicInteger;
import zipkin2.collector.CollectorMetrics;
import zipkin2.internal.Nullable;

public final class ActuateCollectorMetrics
implements CollectorMetrics {
    final MeterRegistry registryInstance;
    final Counter messages;
    final Counter messagesDropped;
    final Counter bytes;
    final Counter spans;
    final Counter spansDropped;
    final AtomicInteger messageBytes;
    final AtomicInteger messageSpans;

    public ActuateCollectorMetrics(MeterRegistry registry) {
        this(null, registry);
    }

    ActuateCollectorMetrics(@Nullable String transport, MeterRegistry meterRegistry) {
        this.registryInstance = meterRegistry;
        if (transport == null) {
            this.spansDropped = null;
            this.spans = null;
            this.bytes = null;
            this.messagesDropped = null;
            this.messages = null;
            this.messageSpans = null;
            this.messageBytes = null;
            return;
        }
        this.messages = Counter.builder((String)"zipkin_collector.messages").description("cumulative amount of messages received").tag("transport", transport).register(this.registryInstance);
        this.messagesDropped = Counter.builder((String)"zipkin_collector.messages_dropped").description("cumulative amount of messages received that were later dropped").tag("transport", transport).register(this.registryInstance);
        this.bytes = Counter.builder((String)"zipkin_collector.bytes").description("cumulative amount of bytes received").tag("transport", transport).baseUnit("bytes").register(this.registryInstance);
        this.spans = Counter.builder((String)"zipkin_collector.spans").description("cumulative amount of spans received").tag("transport", transport).register(this.registryInstance);
        this.spansDropped = Counter.builder((String)"zipkin_collector.spans_dropped").description("cumulative amount of spans received that were later dropped").tag("transport", transport).register(this.registryInstance);
        this.messageSpans = new AtomicInteger(0);
        Gauge.builder((String)"zipkin_collector.message_spans", (Object)this.messageSpans, AtomicInteger::get).description("count of spans per message").tag("transport", transport).register(this.registryInstance);
        this.messageBytes = new AtomicInteger(0);
        Gauge.builder((String)"zipkin_collector.message_bytes", (Object)this.messageBytes, AtomicInteger::get).description("size of a message containing serialized spans").tag("transport", transport).baseUnit("bytes").register(this.registryInstance);
    }

    public ActuateCollectorMetrics forTransport(String transportType) {
        if (transportType == null) {
            throw new NullPointerException("transportType == null");
        }
        return new ActuateCollectorMetrics(transportType, this.registryInstance);
    }

    public void incrementMessages() {
        this.checkScoped();
        this.messages.increment();
    }

    public void incrementMessagesDropped() {
        this.checkScoped();
        this.messagesDropped.increment();
    }

    public void incrementSpans(int quantity) {
        this.checkScoped();
        this.messageSpans.set(quantity);
        this.spans.increment((double)quantity);
    }

    public void incrementBytes(int quantity) {
        this.checkScoped();
        this.messageBytes.set(quantity);
        this.bytes.increment((double)quantity);
    }

    public void incrementSpansDropped(int quantity) {
        this.checkScoped();
        this.spansDropped.increment((double)quantity);
    }

    void checkScoped() {
        if (this.messages == null) {
            throw new IllegalStateException("always scope with ActuateCollectorMetrics.forTransport");
        }
    }
}

