/*
 * Decompiled with CFR 0.152.
 */
package com.recognition.software.jdeskew;

import com.recognition.software.jdeskew.ImageUtil;
import java.awt.image.BufferedImage;

public class ImageDeskew {
    private BufferedImage cImage;
    private double cAlphaStart = -20.0;
    private double cAlphaStep = 0.2;
    private int cSteps = 200;
    private double[] cSinA;
    private double[] cCosA;
    private double cDMin;
    private double cDStep = 1.0;
    private int cDCount;
    private int[] cHMatrix;

    public ImageDeskew(BufferedImage bufferedImage) {
        this.cImage = bufferedImage;
    }

    public double getSkewAngle() {
        double d = 0.0;
        int n = 0;
        this.calc();
        HoughLine[] houghLineArray = this.getTop(20);
        if (houghLineArray.length >= 20) {
            for (int i = 0; i < 19; ++i) {
                d += houghLineArray[i].alpha;
                ++n;
            }
            return d / (double)n;
        }
        return 0.0;
    }

    private HoughLine[] getTop(int n) {
        int n2;
        int n3;
        HoughLine[] houghLineArray = new HoughLine[n];
        for (int i = 0; i < n; ++i) {
            houghLineArray[i] = new HoughLine();
        }
        for (n3 = 0; n3 < this.cHMatrix.length - 1; ++n3) {
            if (this.cHMatrix[n3] <= houghLineArray[n - 1].count) continue;
            houghLineArray[n - 1].count = this.cHMatrix[n3];
            houghLineArray[n - 1].index = n3;
            for (n2 = n - 1; n2 > 0 && houghLineArray[n2].count > houghLineArray[n2 - 1].count; --n2) {
                HoughLine houghLine = houghLineArray[n2];
                houghLineArray[n2] = houghLineArray[n2 - 1];
                houghLineArray[n2 - 1] = houghLine;
            }
        }
        for (int i = 0; i < n; ++i) {
            n2 = houghLineArray[i].index / this.cSteps;
            n3 = houghLineArray[i].index - n2 * this.cSteps;
            houghLineArray[i].alpha = this.getAlpha(n3);
            houghLineArray[i].d = (double)n2 + this.cDMin;
        }
        return houghLineArray;
    }

    private void calc() {
        int n = (int)((double)this.cImage.getHeight() / 4.0);
        int n2 = (int)((double)this.cImage.getHeight() * 3.0 / 4.0);
        this.init();
        for (int i = n; i < n2; ++i) {
            for (int j = 1; j < this.cImage.getWidth() - 2; ++j) {
                if (!ImageUtil.isBlack(this.cImage, j, i) || ImageUtil.isBlack(this.cImage, j, i + 1)) continue;
                this.calc(j, i);
            }
        }
    }

    private void calc(int n, int n2) {
        for (int i = 0; i < this.cSteps - 1; ++i) {
            double d = (double)n2 * this.cCosA[i] - (double)n * this.cSinA[i];
            int n3 = (int)(d - this.cDMin);
            int n4 = n3 * this.cSteps + i;
            try {
                int n5 = n4;
                this.cHMatrix[n5] = this.cHMatrix[n5] + 1;
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
        }
    }

    private void init() {
        this.cSinA = new double[this.cSteps - 1];
        this.cCosA = new double[this.cSteps - 1];
        for (int i = 0; i < this.cSteps - 1; ++i) {
            double d = this.getAlpha(i) * Math.PI / 180.0;
            this.cSinA[i] = Math.sin(d);
            this.cCosA[i] = Math.cos(d);
        }
        this.cDMin = -this.cImage.getWidth();
        this.cDCount = (int)(2.0 * (double)(this.cImage.getWidth() + this.cImage.getHeight()) / this.cDStep);
        this.cHMatrix = new int[this.cDCount * this.cSteps];
    }

    public double getAlpha(int n) {
        return this.cAlphaStart + (double)n * this.cAlphaStep;
    }

    public class HoughLine {
        public int count = 0;
        public int index = 0;
        public double alpha;
        public double d;
    }
}

