/*
 * Decompiled with CFR 0.152.
 */
package gnu.cajo.invoke;

import gnu.cajo.invoke.Loader;
import gnu.cajo.invoke.NoSecurityManager;
import gnu.cajo.invoke.Remote;
import gnu.cajo.invoke.RemoteInvoke;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.rmi.MarshalledObject;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import javax.swing.JComponent;
import javax.swing.JFrame;

public final class Client
extends Applet {
    private static final long serialVersionUID = 1L;
    private static Object proxy;
    private Graphics gbuffer;
    private Image ibuffer;

    public String getAppletInfo() {
        return "cajo Proxy Applet, Copyright \u00a9 1999 by John Catherino";
    }

    public String[][] getParameterInfo() {
        return new String[][]{{"proxyName", "String", "Server's proxy's registry name"}, {"proxyPort", "Integer", "Server's proxy's port number"}, {"clientHost", "String", "Client's external host name"}, {"clientPort", "Integer", "Client's external port number"}, {"localPort", "Integer", "Client's internal port number"}};
    }

    public void init() {
        try {
            int lPort;
            String proxyName = this.getParameter("proxyName");
            String proxyPort = this.getParameter("proxyPort");
            String clientHost = this.getParameter("clientHost");
            String clientPort = this.getParameter("clientPort");
            String localPort = this.getParameter("localPort");
            int pPort = proxyPort != null ? Integer.parseInt(proxyPort) : 1099;
            int cPort = clientPort != null ? Integer.parseInt(clientPort) : 0;
            int n = lPort = localPort != null ? Integer.parseInt(localPort) : 0;
            if (proxyName == null) {
                proxyName = "main";
            }
            Remote.config("0.0.0.0", lPort, clientHost, cPort);
            proxy = LocateRegistry.getRegistry(this.getCodeBase().getHost(), pPort);
            proxy = ((Registry)proxy).lookup(proxyName);
            proxy = Remote.invoke(proxy, "getProxy", null);
            if (proxy instanceof MarshalledObject) {
                proxy = ((MarshalledObject)proxy).get();
            }
            if (!(proxy instanceof RemoteInvoke)) {
                try {
                    proxy = Remote.invoke(proxy, "init", new Remote(proxy));
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            if (proxy instanceof Component) {
                this.setLayout(new BorderLayout());
                this.add((Component)proxy);
                this.validate();
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void start() {
        try {
            Remote.invoke(proxy, "start", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        try {
            Remote.invoke(proxy, "stop", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroy() {
        try {
            Remote.invoke(proxy, "destroy", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void update(Graphics g) {
        int tempW = this.getWidth();
        int tempH = this.getHeight();
        if (this.ibuffer == null || this.ibuffer.getWidth(null) != tempW || this.ibuffer.getHeight(null) != tempH) {
            if (this.ibuffer != null) {
                this.ibuffer.flush();
            }
            this.ibuffer = this.createImage(tempW, tempH);
            if (this.gbuffer != null) {
                this.gbuffer.dispose();
            }
            this.gbuffer = this.ibuffer.getGraphics();
        }
        this.gbuffer.clearRect(0, 0, tempW, tempH);
        this.paint(this.gbuffer);
        g.drawImage(this.ibuffer, 0, 0, null);
    }

    public static Frame frame(Component component, String title) {
        if (component instanceof JComponent) {
            JFrame frame = new JFrame(title);
            if (component instanceof WindowListener) {
                frame.addWindowListener((WindowListener)((Object)component));
            }
            frame.setDefaultCloseOperation(3);
            frame.getContentPane().add((JComponent)component);
            frame.pack();
            frame.setVisible(true);
            return frame;
        }
        CFrame frame = new CFrame(title);
        if (component instanceof WindowListener) {
            frame.addWindowListener((WindowListener)((Object)component));
        }
        frame.add(component);
        frame.pack();
        frame.setVisible(true);
        return frame;
    }

    public static void main(String[] args) throws Exception {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new NoSecurityManager());
        }
        if (args.length > 0) {
            int clientPort = args.length > 1 ? Integer.parseInt(args[1]) : 0;
            String clientHost = args.length > 2 ? args[2] : null;
            int localPort = args.length > 3 ? Integer.parseInt(args[3]) : 0;
            String localHost = args.length > 4 ? args[4] : "0.0.0.0";
            Remote.config(localHost, localPort, clientHost, clientPort);
            proxy = Remote.getItem(args[0]);
            proxy = Remote.invoke(proxy, "getProxy", null);
            if (proxy instanceof MarshalledObject) {
                proxy = ((MarshalledObject)proxy).get();
            }
            if (!(proxy instanceof RemoteInvoke)) {
                proxy = Remote.invoke(proxy, "init", new Remote(proxy));
            }
            if (proxy instanceof Component) {
                String title = "cajo Proxy Viewer";
                try {
                    title = System.getProperty("gnu.cajo.invoke.Client.title");
                }
                catch (Exception x) {
                    // empty catch block
                }
                proxy = Client.frame((Component)proxy, title + " - " + args[0]);
            }
        } else {
            new Loader();
        }
    }

    private static final class CFrame
    extends Frame
    implements WindowListener {
        private static final long serialVersionUID = 1L;

        public CFrame(String title) {
            super(title);
            this.addWindowListener(this);
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            this.dispose();
        }

        public void windowClosed(WindowEvent e) {
            System.exit(0);
        }
    }
}

