/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tess4j;

import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import net.sourceforge.tess4j.ITessAPI;
import net.sourceforge.tess4j.ITesseract;
import net.sourceforge.tess4j.TessAPI1;
import net.sourceforge.tess4j.TesseractException;
import net.sourceforge.tess4j.util.ImageIOHelper;
import net.sourceforge.tess4j.util.PdfUtilities;
import net.sourceforge.tess4j.util.Utils;

public class Tesseract1
extends TessAPI1
implements ITesseract {
    private String language = "eng";
    private String datapath = "./";
    private ITesseract.RenderedFormat renderedFormat = ITesseract.RenderedFormat.TEXT;
    private int psm = -1;
    private int ocrEngineMode = 3;
    private final Properties prop = new Properties();
    private final List<String> configList = new ArrayList<String>();
    private ITessAPI.TessBaseAPI handle;
    private static final Logger logger = Logger.getLogger(Tesseract1.class.getName());

    protected ITessAPI.TessBaseAPI getHandle() {
        return this.handle;
    }

    @Override
    public void setDatapath(String string) {
        this.datapath = string;
    }

    @Override
    public void setLanguage(String string) {
        this.language = string;
    }

    @Override
    public void setOcrEngineMode(int n) {
        this.ocrEngineMode = n;
    }

    @Override
    public void setPageSegMode(int n) {
        this.psm = n;
    }

    public void setHocr(boolean bl) {
        this.renderedFormat = bl ? ITesseract.RenderedFormat.HOCR : ITesseract.RenderedFormat.TEXT;
        this.prop.setProperty("tessedit_create_hocr", bl ? "1" : "0");
    }

    @Override
    public void setTessVariable(String string, String string2) {
        this.prop.setProperty(string, string2);
    }

    @Override
    public void setConfigs(List<String> list) {
        this.configList.clear();
        if (list != null) {
            this.configList.addAll(list);
        }
    }

    @Override
    public String doOCR(File file) throws TesseractException {
        return this.doOCR(file, null);
    }

    @Override
    public String doOCR(File file, Rectangle rectangle) throws TesseractException {
        try {
            return this.doOCR(ImageIOHelper.getIIOImageList(file), file.getPath(), rectangle);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getMessage(), exception);
            throw new TesseractException(exception);
        }
    }

    @Override
    public String doOCR(BufferedImage bufferedImage) throws TesseractException {
        return this.doOCR(bufferedImage, null);
    }

    @Override
    public String doOCR(BufferedImage bufferedImage, Rectangle rectangle) throws TesseractException {
        try {
            return this.doOCR(ImageIOHelper.getIIOImageList(bufferedImage), rectangle);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getMessage(), exception);
            throw new TesseractException(exception);
        }
    }

    @Override
    public String doOCR(List<IIOImage> list, Rectangle rectangle) throws TesseractException {
        return this.doOCR(list, null, rectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doOCR(List<IIOImage> list, String string, Rectangle rectangle) throws TesseractException {
        this.init();
        this.setTessVariables();
        try {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            for (IIOImage iIOImage : list) {
                ++n;
                try {
                    this.setImage(iIOImage.getRenderedImage(), rectangle);
                    stringBuilder.append(this.getOCRText(string, n));
                }
                catch (IOException iOException) {
                    logger.log(Level.SEVERE, iOException.getMessage(), iOException);
                }
            }
            if (this.renderedFormat == ITesseract.RenderedFormat.HOCR) {
                stringBuilder.insert(0, "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n<title></title>\n<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\" />\n<meta name='ocr-system' content='tesseract'/>\n</head>\n<body>\n").append("</body>\n</html>\n");
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        finally {
            this.dispose();
        }
    }

    @Override
    public String doOCR(int n, int n2, ByteBuffer byteBuffer, Rectangle rectangle, int n3) throws TesseractException {
        return this.doOCR(n, n2, byteBuffer, null, rectangle, n3);
    }

    @Override
    public String doOCR(int n, int n2, ByteBuffer byteBuffer, String string, Rectangle rectangle, int n3) throws TesseractException {
        this.init();
        this.setTessVariables();
        try {
            this.setImage(n, n2, byteBuffer, rectangle, n3);
            String string2 = this.getOCRText(string, 1);
            return string2;
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getMessage(), exception);
            throw new TesseractException(exception);
        }
        finally {
            this.dispose();
        }
    }

    protected void init() {
        this.handle = Tesseract1.TessBaseAPICreate();
        StringArray stringArray = new StringArray(this.configList.toArray(new String[0]));
        PointerByReference pointerByReference = new PointerByReference();
        pointerByReference.setPointer(stringArray);
        Tesseract1.TessBaseAPIInit1(this.handle, this.datapath, this.language, this.ocrEngineMode, pointerByReference, this.configList.size());
        if (this.psm > -1) {
            Tesseract1.TessBaseAPISetPageSegMode(this.handle, this.psm);
        }
    }

    protected void setTessVariables() {
        Enumeration<?> enumeration = this.prop.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Tesseract1.TessBaseAPISetVariable(this.handle, string, this.prop.getProperty(string));
        }
    }

    protected void setImage(RenderedImage renderedImage, Rectangle rectangle) throws IOException {
        this.setImage(renderedImage.getWidth(), renderedImage.getHeight(), ImageIOHelper.getImageByteBuffer(renderedImage), rectangle, renderedImage.getColorModel().getPixelSize());
    }

    protected void setImage(int n, int n2, ByteBuffer byteBuffer, Rectangle rectangle, int n3) {
        int n4 = n3 / 8;
        int n5 = (int)Math.ceil((double)(n * n3) / 8.0);
        Tesseract1.TessBaseAPISetImage(this.handle, byteBuffer, n, n2, n4, n5);
        if (rectangle != null && !rectangle.isEmpty()) {
            Tesseract1.TessBaseAPISetRectangle(this.handle, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected String getOCRText(String string, int n) {
        if (string != null && !string.isEmpty()) {
            Tesseract1.TessBaseAPISetInputName(this.handle, string);
        }
        Pointer pointer = this.renderedFormat == ITesseract.RenderedFormat.HOCR ? Tesseract1.TessBaseAPIGetHOCRText(this.handle, n - 1) : Tesseract1.TessBaseAPIGetUTF8Text(this.handle);
        String string2 = pointer.getString(0L);
        Tesseract1.TessDeleteText(pointer);
        return string2;
    }

    private ITessAPI.TessResultRenderer createRenderers(List<ITesseract.RenderedFormat> list) {
        ITessAPI.TessResultRenderer tessResultRenderer = null;
        for (ITesseract.RenderedFormat renderedFormat : list) {
            switch (renderedFormat) {
                case TEXT: {
                    if (tessResultRenderer == null) {
                        tessResultRenderer = Tesseract1.TessTextRendererCreate();
                        break;
                    }
                    Tesseract1.TessResultRendererInsert(tessResultRenderer, Tesseract1.TessTextRendererCreate());
                    break;
                }
                case HOCR: {
                    if (tessResultRenderer == null) {
                        tessResultRenderer = Tesseract1.TessHOcrRendererCreate();
                        break;
                    }
                    Tesseract1.TessResultRendererInsert(tessResultRenderer, Tesseract1.TessHOcrRendererCreate());
                    break;
                }
                case PDF: {
                    String string = Tesseract1.TessBaseAPIGetDatapath(this.handle);
                    if (tessResultRenderer == null) {
                        tessResultRenderer = Tesseract1.TessPDFRendererCreate(string);
                        break;
                    }
                    Tesseract1.TessResultRendererInsert(tessResultRenderer, Tesseract1.TessPDFRendererCreate(string));
                    break;
                }
                case BOX: {
                    if (tessResultRenderer == null) {
                        tessResultRenderer = Tesseract1.TessBoxTextRendererCreate();
                        break;
                    }
                    Tesseract1.TessResultRendererInsert(tessResultRenderer, Tesseract1.TessBoxTextRendererCreate());
                    break;
                }
                case UNLV: {
                    if (tessResultRenderer == null) {
                        tessResultRenderer = Tesseract1.TessUnlvRendererCreate();
                        break;
                    }
                    Tesseract1.TessResultRendererInsert(tessResultRenderer, Tesseract1.TessUnlvRendererCreate());
                }
            }
        }
        return tessResultRenderer;
    }

    @Override
    public void createDocuments(String string, String string2, List<ITesseract.RenderedFormat> list) throws TesseractException {
        this.createDocuments(new String[]{string}, new String[]{string2}, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDocuments(String[] stringArray, String[] stringArray2, List<ITesseract.RenderedFormat> list) throws TesseractException {
        if (stringArray.length != stringArray2.length) {
            throw new RuntimeException("The two arrays must match in length.");
        }
        this.init();
        this.setTessVariables();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                File file = null;
                try {
                    String string = stringArray[i];
                    if (string.toLowerCase().endsWith(".pdf")) {
                        file = PdfUtilities.convertPdf2Tiff(new File(string));
                        string = file.getPath();
                    }
                    ITessAPI.TessResultRenderer tessResultRenderer = this.createRenderers(list);
                    this.createDocuments(string, stringArray2[i], tessResultRenderer);
                    continue;
                }
                catch (Exception exception) {
                    logger.log(Level.SEVERE, exception.getMessage(), exception);
                    continue;
                }
                finally {
                    if (file != null && file.exists()) {
                        file.delete();
                    }
                }
            }
        }
        finally {
            this.dispose();
        }
    }

    private void createDocuments(String string, String string2, ITessAPI.TessResultRenderer tessResultRenderer) throws TesseractException {
        Tesseract1.TessBaseAPISetInputName(this.handle, string);
        Tesseract1.TessResultRendererBeginDocument(tessResultRenderer, string);
        int n = Tesseract1.TessBaseAPIProcessPages1(this.handle, string, null, 0, tessResultRenderer);
        Tesseract1.TessResultRendererEndDocument(tessResultRenderer);
        this.writeToFiles(string2, tessResultRenderer);
    }

    private void writeToFiles(String string, ITessAPI.TessResultRenderer tessResultRenderer) throws TesseractException {
        Map<String, byte[]> map = this.getRendererOutput(tessResultRenderer);
        for (Map.Entry<String, byte[]> entry : map.entrySet()) {
            String string2 = entry.getKey();
            byte[] byArray = entry.getValue();
            try {
                File file = new File(string + "." + string2);
                Utils.writeFile(byArray, file);
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }
    }

    private Map<String, byte[]> getRendererOutput(ITessAPI.TessResultRenderer tessResultRenderer) throws TesseractException {
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        while (tessResultRenderer != null) {
            String string = Tesseract1.TessResultRendererExtention(tessResultRenderer).getString(0L);
            PointerByReference pointerByReference = new PointerByReference();
            IntByReference intByReference = new IntByReference();
            int n = Tesseract1.TessResultRendererGetOutput(tessResultRenderer, pointerByReference, intByReference);
            if (n == 1) {
                int n2 = intByReference.getValue();
                byte[] byArray = pointerByReference.getValue().getByteArray(0L, n2);
                hashMap.put(string, byArray);
            }
            tessResultRenderer = Tesseract1.TessResultRendererNext(tessResultRenderer);
        }
        return hashMap;
    }

    protected void dispose() {
        Tesseract1.TessBaseAPIDelete(this.handle);
    }
}

