/*
 * Decompiled with CFR 0.152.
 */
package org.ghost4j;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.ghost4j.Component;
import org.ghost4j.Ghostscript;
import org.ghost4j.GhostscriptException;
import org.ghost4j.document.Document;
import org.ghost4j.document.DocumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComponent
implements Component {
    private static final List<String> AVAILABLE_DEVICE_NAMES = new ArrayList<String>();
    protected Class<?>[] supportedDocumentClasses;

    protected void assertDocumentSupported(Document document) throws DocumentException {
        if (this.supportedDocumentClasses != null) {
            for (Class<?> clazz : this.supportedDocumentClasses) {
                if (!clazz.getName().equals(document.getClass().getName())) continue;
                return;
            }
            throw new DocumentException("Documents of class " + document.getClass().getName() + " are not supported by the component");
        }
    }

    @Override
    public void copySettings(Map<String, Object> settings) throws IllegalAccessException, InvocationTargetException {
        if (settings.get("maxProcessCount") != null) {
            settings.remove("maxProcessCount");
        }
        BeanUtils.populate(this, settings);
    }

    @Override
    public Map<String, Object> extractSettings() throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Map result = PropertyUtils.describe(this);
        if (result.get("maxProcessCount") != null) {
            result.remove("maxProcessCount");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean isDeviceSupported(String deviceName) throws GhostscriptException {
        if (AVAILABLE_DEVICE_NAMES.size() == 0) {
            Ghostscript gs = Ghostscript.getInstance();
            try {
                String[] deviceNames;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                String[] gsArgs = new String[]{"-dQUIET", "-dNOPAUSE", "-dBATCH", "-dNODISPLAY"};
                Ghostscript ghostscript = gs;
                synchronized (ghostscript) {
                    gs.setStdOut(baos);
                    gs.initialize(gsArgs);
                    gs.runString("devicenames ==");
                    gs.exit();
                }
                String result = new String(baos.toByteArray());
                String[] lines = result.split("\n");
                int i = 0;
                while (!lines[i].startsWith("[")) {
                    ++i;
                }
                for (String string : deviceNames = lines[i].substring(1, lines[i].length() - 2).split("/")) {
                    AVAILABLE_DEVICE_NAMES.add(string.trim());
                }
            }
            catch (GhostscriptException e) {
                throw e;
            }
            finally {
                Ghostscript.deleteInstance();
            }
        }
        return AVAILABLE_DEVICE_NAMES.contains(deviceName);
    }

    protected void assertDeviceSupported(String deviceName) throws GhostscriptException {
        if (!this.isDeviceSupported(deviceName)) {
            throw new GhostscriptException("device " + deviceName + " is not supported by the current Ghostscript interpreter.");
        }
    }
}

