/*
 * Decompiled with CFR 0.152.
 */
package org.ghost4j.analyzer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.ghost4j.Ghostscript;
import org.ghost4j.GhostscriptException;
import org.ghost4j.analyzer.AbstractRemoteAnalyzer;
import org.ghost4j.analyzer.AnalysisItem;
import org.ghost4j.analyzer.AnalyzerException;
import org.ghost4j.analyzer.FontAnalysisItem;
import org.ghost4j.document.Document;
import org.ghost4j.document.DocumentException;
import org.ghost4j.document.PDFDocument;
import org.ghost4j.util.DiskStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontAnalyzer
extends AbstractRemoteAnalyzer {
    public FontAnalyzer() {
        this.supportedDocumentClasses = new Class[1];
        this.supportedDocumentClasses[0] = PDFDocument.class;
    }

    public static void main(String[] args) throws AnalyzerException {
        FontAnalyzer.startRemoteAnalyzer(new FontAnalyzer());
    }

    @Override
    public List<AnalysisItem> run(Document document) throws IOException, AnalyzerException, DocumentException {
        this.assertDocumentSupported(document);
        return this.run((PDFDocument)document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<AnalysisItem> run(PDFDocument document) throws IOException, AnalyzerException {
        ArrayList<AnalysisItem> arrayList;
        Ghostscript gs = Ghostscript.getInstance();
        DiskStore diskStore = DiskStore.getInstance();
        String inputDiskStoreKey = diskStore.generateUniqueKey();
        document.write(diskStore.addFile(inputDiskStoreKey));
        String[] gsArgs = new String[]{"-fonta", "-dQUIET", "-dNOPAUSE", "-dBATCH", "-dNODISPLAY", "-sFile=" + diskStore.getFile(inputDiskStoreKey).getAbsolutePath(), "-sOutputFile=%stdout", "-f", "-"};
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("script/AnalyzePDFFonts.ps");
        try {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Ghostscript ghostscript = gs;
                synchronized (ghostscript) {
                    gs.setStdIn(is);
                    gs.setStdOut(baos);
                    gs.initialize(gsArgs);
                }
                ArrayList<AnalysisItem> result = new ArrayList<AnalysisItem>();
                String scriptResult = baos.toString();
                String[] lines = scriptResult.split("\n");
                boolean inResults = false;
                for (String line : lines) {
                    String[] columns;
                    if (line.equals("---")) {
                        inResults = true;
                        continue;
                    }
                    if (!inResults || (columns = line.split(" ")).length != 2) continue;
                    FontAnalysisItem font = new FontAnalysisItem();
                    String name = columns[0];
                    String[] nameParts = name.split("\\+");
                    if (nameParts.length > 1) {
                        name = nameParts[1];
                        font.setSubSet(true);
                    }
                    font.setName(name);
                    font.setEmbedded(false);
                    if (columns[1].equals("EM") || columns[1].equals("SU")) {
                        font.setEmbedded(true);
                    }
                    result.add(font);
                }
                baos.close();
                arrayList = result;
                Object var21_21 = null;
            }
            catch (GhostscriptException e) {
                throw new AnalyzerException(e);
            }
        }
        catch (Throwable throwable) {
            Object var21_22 = null;
            IOUtils.closeQuietly(is);
            try {
                Ghostscript.deleteInstance();
            }
            catch (GhostscriptException e2) {
                throw new AnalyzerException(e2);
            }
            diskStore.removeFile(inputDiskStoreKey);
            throw throwable;
        }
        IOUtils.closeQuietly(is);
        try {}
        catch (GhostscriptException e2) {
            throw new AnalyzerException(e2);
        }
        Ghostscript.deleteInstance();
        diskStore.removeFile(inputDiskStoreKey);
        return arrayList;
    }
}

