/*
 * Decompiled with CFR 0.152.
 */
package org.ghost4j.converter;

import gnu.cajo.invoke.Remote;
import gnu.cajo.utils.ItemServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.ghost4j.AbstractRemoteComponent;
import org.ghost4j.converter.ConverterException;
import org.ghost4j.converter.RemoteConverter;
import org.ghost4j.document.Document;
import org.ghost4j.document.DocumentException;
import org.ghost4j.util.JavaFork;

public abstract class AbstractRemoteConverter
extends AbstractRemoteComponent
implements RemoteConverter {
    protected abstract void run(Document var1, OutputStream var2) throws IOException, ConverterException, DocumentException;

    protected static void startRemoteConverter(RemoteConverter remoteConverter) throws ConverterException {
        try {
            if (System.getenv("cajo.port") == null) {
                throw new ConverterException("No Cajo port defined for remote converter");
            }
            int cajoPort = Integer.parseInt(System.getenv("cajo.port"));
            RemoteConverter converterCopy = (RemoteConverter)remoteConverter.getClass().newInstance();
            converterCopy.setMaxProcessCount(0);
            Remote.config(null, cajoPort, null, 0);
            ItemServer.bind(converterCopy, RemoteConverter.class.getCanonicalName());
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    public byte[] remoteConvert(Document document) throws IOException, ConverterException, DocumentException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.run(document, baos);
        byte[] result = baos.toByteArray();
        baos.close();
        return result;
    }

    public void convert(Document document, OutputStream outputStream) throws IOException, ConverterException, DocumentException {
        if (this.maxProcessCount == 0) {
            this.run(document, outputStream);
        } else {
            this.waitForFreeProcess();
            ++this.processCount;
            if (!this.isStandAloneModeSupported()) {
                throw new ConverterException("Standalone mode is not supported by this converter: no 'main' method found");
            }
            JavaFork fork = this.buildJavaFork();
            int documentMbSize = document.getSize() / 1024 / 1024 + 1;
            int xmxValue = 64 + documentMbSize;
            fork.setXmx(xmxValue + "m");
            int cajoPort = 0;
            try {
                try {
                    cajoPort = this.startRemoteServer(fork);
                    Object remote = this.getRemoteComponent(cajoPort, RemoteConverter.class);
                    Remote.invoke(remote, "copySettings", this.extractSettings());
                    byte[] result = (byte[])Remote.invoke(remote, "remoteConvert", document);
                    outputStream.write(result);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ConverterException(e);
                }
                Object var10_11 = null;
                --this.processCount;
                fork.stop();
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                --this.processCount;
                fork.stop();
                throw throwable;
            }
        }
    }
}

