/*
 * Decompiled with CFR 0.152.
 */
package org.ghost4j.converter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.ghost4j.Ghostscript;
import org.ghost4j.GhostscriptException;
import org.ghost4j.converter.AbstractRemoteConverter;
import org.ghost4j.converter.ConverterException;
import org.ghost4j.document.Document;
import org.ghost4j.document.DocumentException;
import org.ghost4j.document.PDFDocument;
import org.ghost4j.document.PSDocument;
import org.ghost4j.document.PaperSize;
import org.ghost4j.util.DiskStore;

public class PSConverter
extends AbstractRemoteConverter {
    public static final int OPTION_DEVICE_AUTO = 0;
    public static final int OPTION_DEVICE_PSWRITE = 1;
    public static final int OPTION_DEVICE_PS2WRITE = 2;
    private int device = 0;
    private int languageLevel = 3;
    private PaperSize paperSize = PaperSize.LETTER;

    public PSConverter() {
        this.supportedDocumentClasses = new Class[2];
        this.supportedDocumentClasses[0] = PSDocument.class;
        this.supportedDocumentClasses[1] = PDFDocument.class;
    }

    public static void main(String[] args) throws ConverterException {
        PSConverter.startRemoteConverter(new PSConverter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(Document document, OutputStream outputStream) throws IOException, ConverterException, DocumentException {
        if (outputStream == null) {
            return;
        }
        this.assertDocumentSupported(document);
        String deviceName = "";
        try {
            switch (this.device) {
                case 1: {
                    deviceName = "pswrite";
                    break;
                }
                case 2: {
                    deviceName = "ps2write";
                    break;
                }
                case 0: {
                    if (this.isDeviceSupported("ps2write")) {
                        deviceName = "ps2write";
                        break;
                    }
                    deviceName = "pswrite";
                    break;
                }
                default: {
                    deviceName = "pswrite";
                    break;
                }
            }
        }
        catch (GhostscriptException e) {
            throw new ConverterException(e);
        }
        Ghostscript gs = Ghostscript.getInstance();
        DiskStore diskStore = DiskStore.getInstance();
        String outputDiskStoreKey = diskStore.generateUniqueKey();
        String inputDiskStoreKey = diskStore.generateUniqueKey();
        document.write(diskStore.addFile(inputDiskStoreKey));
        String[] gsArgs = new String[]{"-psconv", "-dNOPAUSE", "-dBATCH", "-dSAFER", "-dLanguageLevel=" + this.languageLevel, "-dDEVICEWIDTHPOINTS=" + this.paperSize.getWidth(), "-dDEVICEHEIGHTPOINTS=" + this.paperSize.getHeight(), "-sDEVICE=" + deviceName, "-sOutputFile=" + diskStore.addFile(outputDiskStoreKey).getAbsolutePath(), "-q", "-f", diskStore.getFile(inputDiskStoreKey).getAbsolutePath()};
        try {
            try {
                Ghostscript ghostscript = gs;
                synchronized (ghostscript) {
                    gs.initialize(gsArgs);
                    gs.exit();
                }
                File outputFile = diskStore.getFile(outputDiskStoreKey);
                if (outputFile == null) {
                    throw new ConverterException("Cannot retrieve file with key " + outputDiskStoreKey + " from disk store");
                }
                FileInputStream fis = new FileInputStream(outputFile);
                byte[] content = new byte[(int)outputFile.length()];
                fis.read(content);
                fis.close();
                outputStream.write(content);
            }
            catch (GhostscriptException e) {
                throw new ConverterException(e);
            }
            Object var13_14 = null;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            try {
                Ghostscript.deleteInstance();
            }
            catch (GhostscriptException e) {
                throw new ConverterException(e);
            }
            diskStore.removeFile(outputDiskStoreKey);
            diskStore.removeFile(inputDiskStoreKey);
            throw throwable;
        }
        try {}
        catch (GhostscriptException e) {
            throw new ConverterException(e);
        }
        Ghostscript.deleteInstance();
        diskStore.removeFile(outputDiskStoreKey);
        diskStore.removeFile(inputDiskStoreKey);
    }

    public int getLanguageLevel() {
        return this.languageLevel;
    }

    public void setLanguageLevel(int languageLevel) {
        this.languageLevel = languageLevel;
    }

    public PaperSize getPaperSize() {
        return this.paperSize;
    }

    public void setPaperSize(PaperSize paperSize) {
        this.paperSize = paperSize;
    }

    public int getDevice() {
        return this.device;
    }

    public void setDevice(int device) {
        this.device = device;
    }
}

