/*
 * Decompiled with CFR 0.152.
 */
package org.ghost4j.document;

import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.ghost4j.document.AbstractDocument;
import org.ghost4j.document.Document;
import org.ghost4j.document.DocumentException;

public class PDFDocument
extends AbstractDocument {
    private static final long serialVersionUID = 6331191005700202153L;

    public void load(InputStream inputStream) throws IOException {
        super.load(inputStream);
        ByteArrayInputStream bais = null;
        PdfReader reader = null;
        try {
            try {
                bais = new ByteArrayInputStream(this.content);
                reader = new PdfReader(bais);
            }
            catch (Exception e) {
                throw new IOException("PDF document is not valid");
            }
            Object var6_4 = null;
            if (reader != null) {
                reader.close();
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (reader != null) {
                reader.close();
            }
            IOUtils.closeQuietly(bais);
            throw throwable;
        }
        IOUtils.closeQuietly(bais);
    }

    public int getPageCount() throws DocumentException {
        int pageCount = 0;
        if (this.content == null) {
            return pageCount;
        }
        ByteArrayInputStream bais = null;
        PdfReader reader = null;
        try {
            try {
                bais = new ByteArrayInputStream(this.content);
                reader = new PdfReader(bais);
                pageCount = reader.getNumberOfPages();
            }
            catch (Exception e) {
                throw new DocumentException(e);
            }
            Object var6_4 = null;
            if (reader != null) {
                reader.close();
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (reader != null) {
                reader.close();
            }
            IOUtils.closeQuietly(bais);
            throw throwable;
        }
        IOUtils.closeQuietly(bais);
        return pageCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Document extract(int begin, int end) throws DocumentException {
        this.assertValidPageRange(begin, end);
        PDFDocument result = new PDFDocument();
        ByteArrayInputStream bais = null;
        ByteArrayOutputStream baos = null;
        if (this.content == null) return result;
        com.lowagie.text.Document document = new com.lowagie.text.Document();
        try {
            try {
                bais = new ByteArrayInputStream(this.content);
                baos = new ByteArrayOutputStream();
                PdfReader inputPDF = new PdfReader(bais);
                PdfWriter writer = PdfWriter.getInstance(document, baos);
                document.open();
                PdfContentByte cb = writer.getDirectContent();
                while (begin <= end) {
                    document.newPage();
                    PdfImportedPage page = writer.getImportedPage(inputPDF, begin);
                    cb.addTemplate(page, 0.0f, 0.0f);
                    ++begin;
                }
                document.close();
                result.load(new ByteArrayInputStream(baos.toByteArray()));
            }
            catch (Exception e) {
                throw new DocumentException(e);
            }
            Object var12_12 = null;
            if (document.isOpen()) {
                document.close();
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (document.isOpen()) {
                document.close();
            }
            IOUtils.closeQuietly(bais);
            IOUtils.closeQuietly(baos);
            throw throwable;
        }
        IOUtils.closeQuietly(bais);
        IOUtils.closeQuietly(baos);
        return result;
    }

    public void append(Document document) throws DocumentException {
        super.append(document);
        ByteArrayOutputStream baos = null;
        com.lowagie.text.Document mergedDocument = new com.lowagie.text.Document();
        try {
            try {
                baos = new ByteArrayOutputStream();
                PdfCopy copy = new PdfCopy(mergedDocument, (OutputStream)baos);
                mergedDocument.open();
                PdfReader reader = new PdfReader(this.content);
                int pageCount = reader.getNumberOfPages();
                int i = 0;
                while (i < pageCount) {
                    copy.addPage(copy.getImportedPage(reader, ++i));
                }
                reader = new PdfReader(document.getContent());
                pageCount = reader.getNumberOfPages();
                i = 0;
                while (i < pageCount) {
                    copy.addPage(copy.getImportedPage(reader, ++i));
                }
                mergedDocument.close();
                this.content = baos.toByteArray();
            }
            catch (Exception e) {
                throw new DocumentException(e);
            }
            Object var9_9 = null;
            if (mergedDocument.isOpen()) {
                mergedDocument.close();
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (mergedDocument.isOpen()) {
                mergedDocument.close();
            }
            IOUtils.closeQuietly(baos);
            throw throwable;
        }
        IOUtils.closeQuietly(baos);
    }

    public String getType() {
        return "PDF";
    }
}

