/*
 * Decompiled with CFR 0.152.
 */
package org.ghost4j.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class NetworkUtil {
    public static synchronized int findAvailablePort(String hostname, int startPort, int endPort) {
        for (int port = startPort; port < endPort + 1; ++port) {
            try {
                Socket socket = new Socket(InetAddress.getByName(hostname), port);
                socket.close();
                continue;
            }
            catch (IOException e) {
                return port;
            }
        }
        return 0;
    }

    public static void waitUntilPortListening(String hostname, int port, int timeout) throws IOException {
        int i = 0;
        while (i < timeout) {
            try {
                Socket socket = new Socket(InetAddress.getByName(hostname), port);
                socket.close();
                return;
            }
            catch (IOException e) {
                ++i;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e2) {}
            }
        }
        throw new IOException("Timeout waiting for port " + port + " to listen");
    }
}

