/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.Log;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.PreCleanStats;
import kafka.log.SkimpyOffsetMap;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\rea\u0001\u0002 @\u0001\u0011C\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006IA\u0018\u0005\tE\u0002\u0011)\u0019!C\u0001G\"A\u0001\u0010\u0001B\u0001B\u0003%A\r\u0003\u0005z\u0001\t\u0015\r\u0011\"\u0001{\u0011%\tI\u0002\u0001B\u0001B\u0003%1\u0010\u0003\u0006\u0002\u001c\u0001\u0011)\u0019!C\u0001\u0003;A!\"!\n\u0001\u0005\u0003\u0005\u000b\u0011BA\u0010\u0011)\t9\u0003\u0001B\u0001B\u0003%\u0011\u0011\u0006\u0005\b\u0003g\u0001A\u0011AA\u001b\u0011%\t\u0019\u0005\u0001a\u0001\n\u0013\t)\u0005C\u0005\u0002H\u0001\u0001\r\u0011\"\u0003\u0002J!9\u0011Q\u000b\u0001!B\u0013q\u0006BCA0\u0001\t\u0007I\u0011A \u0002b!A\u0011\u0011\u000e\u0001!\u0002\u0013\t\u0019\u0007C\u0005\u0002l\u0001\u0011\r\u0011\"\u0003\u0002n!A\u0011Q\u000f\u0001!\u0002\u0013\ty\u0007C\u0005\u0002x\u0001\u0011\r\u0011\"\u0003\u0002z!A!\u0011\b\u0001!\u0002\u0013\tY\bC\u0004\u0003<\u0001!\t!a=\t\u000f\tu\u0002\u0001\"\u0001\u0002t\"9!q\b\u0001\u0005B\t\u0005\u0003b\u0002B&\u0001\u0011\u0005#Q\n\u0005\b\u00053\u0002A\u0011\tB.\u0011\u001d\u0011\u0019\u0007\u0001C\u0001\u0005KBqA!\u001b\u0001\t\u0003\u0011Y\u0007C\u0004\u0003r\u0001!\tAa\u001d\t\u000f\t}\u0004\u0001\"\u0001\u0003\u0002\"9!q\u0011\u0001\u0005\u0002\t%\u0005b\u0002BJ\u0001\u0011\u0005!Q\u0013\u0005\b\u00053\u0003A\u0011\u0001BN\u0011\u001d\u00119\u000b\u0001C\u0001\u0005SC\u0011Ba-\u0001#\u0003%\tA!.\t\u000f\t-\u0007\u0001\"\u0001\u0003N\"A!q\u001b\u0001\u0005\u0002\u0005\u000b)\u0005\u0003\u0005\u0003Z\u0002!\ta\u0010Bn\r\u0019\ty\t\u0001\u0003\u0002\u0012\"Q\u0011\u0011\u0014\u0013\u0003\u0002\u0003\u0006I!a'\t\u000f\u0005MB\u0005\"\u0001\u0002\"\"9\u0011Q\u0015\u0013\u0005R\u0005\u001d\u0006\"CA[I\t\u0007I\u0011AA\\\u0011!\ty\f\nQ\u0001\n\u0005e\u0006\"CAaI\u0001\u0007I\u0011AAb\u0011%\tY\r\na\u0001\n\u0003\ti\r\u0003\u0005\u0002R\u0012\u0002\u000b\u0015BAc\u0011%\t)\u000e\na\u0001\n\u0003\t9\u000eC\u0005\u0002`\u0012\u0002\r\u0011\"\u0001\u0002b\"A\u0011Q\u001d\u0013!B\u0013\tI\u000eC\u0004\u0002j\u0012\"I!a;\t\u000f\u0005EH\u0005\"\u0011\u0002t\"9\u0011Q\u001f\u0013\u0005\n\u0005]\bbBA\u0000I\u0011%!\u0011\u0001\u0005\b\u0005\u001b!C\u0011\u0001B\b\u000f\u001d\u0011in\u0010E\u0001\u0005?4aAP \t\u0002\t\u0005\bbBA\u001am\u0011\u0005!1\u001d\u0005\n\u0005K4$\u0019!C\u0001\u0005OD\u0001Ba;7A\u0003%!\u0011\u001e\u0005\b\u0005[4D\u0011\u0001Bx\u0011\u001d\u0011\u0019P\u000eC\u0001\u0005kDqaa\u00017\t\u0003\u0019)\u0001C\u0005\u0004\u0014Y\n\n\u0011\"\u0001\u0004\u0016\tQAj\\4DY\u0016\fg.\u001a:\u000b\u0005\u0001\u000b\u0015a\u00017pO*\t!)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u000b\u0001)5*U,\u0011\u0005\u0019KU\"A$\u000b\u0003!\u000bQa]2bY\u0006L!AS$\u0003\r\u0005s\u0017PU3g!\tau*D\u0001N\u0015\tq\u0015)A\u0003vi&d7/\u0003\u0002Q\u001b\n9Aj\\4hS:<\u0007C\u0001*V\u001b\u0005\u0019&B\u0001+B\u0003\u001diW\r\u001e:jGNL!AV*\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b\u000f\u0005\u0002Y76\t\u0011L\u0003\u0002[\u0003\u000611/\u001a:wKJL!\u0001X-\u0003)\t\u0013xn[3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u00035Ig.\u001b;jC2\u001cuN\u001c4jOB\u0011q\fY\u0007\u0002\u007f%\u0011\u0011m\u0010\u0002\u000e\u00072,\u0017M\\3s\u0007>tg-[4\u0002\u000f1|w\rR5sgV\tA\rE\u0002f[Bt!AZ6\u000f\u0005\u001dTW\"\u00015\u000b\u0005%\u001c\u0015A\u0002\u001fs_>$h(C\u0001I\u0013\taw)A\u0004qC\u000e\\\u0017mZ3\n\u00059|'aA*fc*\u0011An\u0012\t\u0003cZl\u0011A\u001d\u0006\u0003gR\f!![8\u000b\u0003U\fAA[1wC&\u0011qO\u001d\u0002\u0005\r&dW-\u0001\u0005m_\u001e$\u0015N]:!\u0003\u0011awnZ:\u0016\u0003m\u0004R\u0001\u0014?\u007f\u0003'I!!`'\u0003\tA{w\u000e\u001c\t\u0004\u007f\u0006=QBAA\u0001\u0015\u0011\t\u0019!!\u0002\u0002\r\r|W.\\8o\u0015\r\u0011\u0015q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u001b\t1a\u001c:h\u0013\u0011\t\t\"!\u0001\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0019q,!\u0006\n\u0007\u0005]qHA\u0002M_\u001e\fQ\u0001\\8hg\u0002\nA\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016dWCAA\u0010!\rA\u0016\u0011E\u0005\u0004\u0003GI&\u0001\u0006'pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G.A\u000bm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\u001c\u0011\u0002\tQLW.\u001a\t\u0005\u0003W\ty#\u0004\u0002\u0002.)\u0019a*!\u0001\n\t\u0005E\u0012Q\u0006\u0002\u0005)&lW-\u0001\u0004=S:LGO\u0010\u000b\r\u0003o\tI$a\u000f\u0002>\u0005}\u0012\u0011\t\t\u0003?\u0002AQ!X\u0005A\u0002yCQAY\u0005A\u0002\u0011DQ!_\u0005A\u0002mDq!a\u0007\n\u0001\u0004\ty\u0002C\u0005\u0002(%\u0001\n\u00111\u0001\u0002*\u000511m\u001c8gS\u001e,\u0012AX\u0001\u000bG>tg-[4`I\u0015\fH\u0003BA&\u0003#\u00022ARA'\u0013\r\tye\u0012\u0002\u0005+:LG\u000f\u0003\u0005\u0002T-\t\t\u00111\u0001_\u0003\rAH%M\u0001\bG>tg-[4!Q\ra\u0011\u0011\f\t\u0004\r\u0006m\u0013bAA/\u000f\nAao\u001c7bi&dW-\u0001\bdY\u0016\fg.\u001a:NC:\fw-\u001a:\u0016\u0005\u0005\r\u0004cA0\u0002f%\u0019\u0011qM \u0003#1{wm\u00117fC:,'/T1oC\u001e,'/A\bdY\u0016\fg.\u001a:NC:\fw-\u001a:!\u0003%!\bN]8ui2,'/\u0006\u0002\u0002pA\u0019A*!\u001d\n\u0007\u0005MTJA\u0005UQJ|G\u000f\u001e7fe\u0006QA\u000f\u001b:piRdWM\u001d\u0011\u0002\u0011\rdW-\u00198feN,\"!a\u001f\u0011\r\u0005u\u0014qQAF\u001b\t\tyH\u0003\u0003\u0002\u0002\u0006\r\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u000b;\u0015AC2pY2,7\r^5p]&!\u0011\u0011RA@\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0007\u00055E%D\u0001\u0001\u00055\u0019E.Z1oKJ$\u0006N]3bIN\u0019A%a%\u0011\u00071\u000b)*C\u0002\u0002\u00186\u0013!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bI\u0006AA\u000f\u001b:fC\u0012LE\rE\u0002G\u0003;K1!a(H\u0005\rIe\u000e\u001e\u000b\u0005\u0003\u0017\u000b\u0019\u000bC\u0004\u0002\u001a\u001a\u0002\r!a'\u0002\u00151|wmZ3s\u001d\u0006lW-\u0006\u0002\u0002*B!\u00111VAY\u001b\t\tiKC\u0002\u00020R\fA\u0001\\1oO&!\u00111WAW\u0005\u0019\u0019FO]5oO\u000691\r\\3b]\u0016\u0014XCAA]!\ry\u00161X\u0005\u0004\u0003{{$aB\"mK\u0006tWM]\u0001\tG2,\u0017M\\3sA\u0005IA.Y:u'R\fGo]\u000b\u0003\u0003\u000b\u00042aXAd\u0013\r\tIm\u0010\u0002\r\u00072,\u0017M\\3s'R\fGo]\u0001\u000eY\u0006\u001cHo\u0015;biN|F%Z9\u0015\t\u0005-\u0013q\u001a\u0005\n\u0003'Z\u0013\u0011!a\u0001\u0003\u000b\f!\u0002\\1tiN#\u0018\r^:!Q\ra\u0013\u0011L\u0001\u0012Y\u0006\u001cH\u000f\u0015:f\u00072,\u0017M\\*uCR\u001cXCAAm!\ry\u00161\\\u0005\u0004\u0003;|$!\u0004)sK\u000ecW-\u00198Ti\u0006$8/A\u000bmCN$\bK]3DY\u0016\fgn\u0015;biN|F%Z9\u0015\t\u0005-\u00131\u001d\u0005\n\u0003'r\u0013\u0011!a\u0001\u00033\f!\u0003\\1tiB\u0013Xm\u00117fC:\u001cF/\u0019;tA!\u001aq&!\u0017\u0002\u0013\rDWmY6E_:,G\u0003BA&\u0003[Da!a<1\u0001\u0004q\u0018A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0007I><vN]6\u0015\u0005\u0005-\u0013!E2mK\u0006tg)\u001b7uQ&,7\u000f\u001e'pOR\u0011\u0011\u0011 \t\u0004\r\u0006m\u0018bAA\u007f\u000f\n9!i\\8mK\u0006t\u0017\u0001C2mK\u0006tGj\\4\u0015\t\u0005-#1\u0001\u0005\b\u0005\u000b\u0019\u0004\u0019\u0001B\u0004\u0003%\u0019G.Z1oC\ndW\rE\u0002`\u0005\u0013I1Aa\u0003@\u0005)aun\u001a+p\u00072,\u0017M\\\u0001\fe\u0016\u001cwN\u001d3Ti\u0006$8\u000f\u0006\u0007\u0002L\tE!Q\u0003B\u0014\u0005c\u0011)\u0004C\u0004\u0003\u0014Q\u0002\r!a'\u0002\u0005%$\u0007b\u0002B\fi\u0001\u0007!\u0011D\u0001\u0005]\u0006lW\r\u0005\u0003\u0003\u001c\t\rb\u0002\u0002B\u000f\u0005?\u0001\"aZ$\n\u0007\t\u0005r)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003g\u0013)CC\u0002\u0003\"\u001dCqA!\u000b5\u0001\u0004\u0011Y#\u0001\u0003ge>l\u0007c\u0001$\u0003.%\u0019!qF$\u0003\t1{gn\u001a\u0005\b\u0005g!\u0004\u0019\u0001B\u0016\u0003\t!x\u000eC\u0004\u00038Q\u0002\r!!2\u0002\u000bM$\u0018\r^:\u0002\u0013\rdW-\u00198feN\u0004\u0013aB:uCJ$X\u000f]\u0001\tg\",H\u000fZ8x]\u0006)\"/Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001cXC\u0001B\"!\u0019\u0011)Ea\u0012\u0003\u001a5\u0011\u00111Q\u0005\u0005\u0005\u0013\n\u0019IA\u0002TKR\fqC^1mS\u0012\fG/\u001a*fG>tg-[4ve\u0006$\u0018n\u001c8\u0015\t\u0005-#q\n\u0005\b\u0005#2\u0002\u0019\u0001B*\u0003%qWm^\"p]\u001aLw\rE\u0002Y\u0005+J1Aa\u0016Z\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0017I,7m\u001c8gS\u001e,(/\u001a\u000b\u0007\u0003\u0017\u0012iF!\u0019\t\u000f\t}s\u00031\u0001\u0003T\u0005Iq\u000e\u001c3D_:4\u0017n\u001a\u0005\b\u0005#:\u0002\u0019\u0001B*\u00035\t'm\u001c:u\u00072,\u0017M\\5oOR!\u00111\nB4\u0011\u0019\ty\u000f\u0007a\u0001}\u0006\tR\u000f\u001d3bi\u0016\u001c\u0005.Z2la>Lg\u000e^:\u0015\t\u0005-#Q\u000e\u0005\u0007\u0005_J\u0002\u0019\u00019\u0002\u000f\u0011\fG/\u0019#je\u0006\u0011\u0012\r\u001c;fe\u000eCWmY6q_&tG\u000fR5s)!\tYE!\u001e\u0003x\tm\u0004BBAx5\u0001\u0007a\u0010\u0003\u0004\u0003zi\u0001\r\u0001]\u0001\rg>,(oY3M_\u001e$\u0015N\u001d\u0005\u0007\u0005{R\u0002\u0019\u00019\u0002\u0015\u0011,7\u000f\u001e'pO\u0012K'/A\niC:$G.\u001a'pO\u0012K'OR1jYV\u0014X\r\u0006\u0003\u0002L\t\r\u0005b\u0002BC7\u0001\u0007!\u0011D\u0001\u0004I&\u0014\u0018aF7bs\n,GK];oG\u0006$Xm\u00115fG.\u0004x.\u001b8u)!\tYEa#\u0003\u000e\n=\u0005B\u0002B89\u0001\u0007\u0001\u000f\u0003\u0004\u0002pr\u0001\rA \u0005\b\u0005#c\u0002\u0019\u0001B\u0016\u0003\u0019ygMZ:fi\u0006)\u0012MY8si\u0006sG\rU1vg\u0016\u001cE.Z1oS:<G\u0003BA&\u0005/Ca!a<\u001e\u0001\u0004q\u0018A\u0004:fgVlWm\u00117fC:Lgn\u001a\u000b\u0005\u0003\u0017\u0012i\nC\u0004\u0003 z\u0001\rA!)\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N\u0004RA!\u0012\u0003$zLAA!*\u0002\u0004\nA\u0011\n^3sC\ndW-\u0001\u0007bo\u0006LGo\u00117fC:,G\r\u0006\u0005\u0002z\n-&Q\u0016BX\u0011\u0019\tyo\ba\u0001}\"9!\u0011S\u0010A\u0002\t-\u0002\"\u0003BY?A\u0005\t\u0019\u0001B\u0016\u0003%i\u0017\r_,bSRl5/\u0001\fbo\u0006LGo\u00117fC:,G\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u00119L\u000b\u0003\u0003,\te6F\u0001B^!\u0011\u0011iLa2\u000e\u0005\t}&\u0002\u0002Ba\u0005\u0007\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u0015w)\u0001\u0006b]:|G/\u0019;j_:LAA!3\u0003@\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002MA\fWo]3DY\u0016\fg.\u001b8h\r>\u0014hj\u001c8D_6\u0004\u0018m\u0019;fIB\u000b'\u000f^5uS>t7\u000f\u0006\u0002\u0003PB1!Q\tBR\u0005#\u0004bA\u0012Bj}\u0006M\u0011b\u0001Bk\u000f\n1A+\u001e9mKJ\nQbY;se\u0016tGoQ8oM&<\u0017\u0001D2mK\u0006tWM]\"pk:$XCAAN\u0003)aunZ\"mK\u0006tWM\u001d\t\u0003?Z\u001a\"AN#\u0015\u0005\t}\u0017!\u0006*fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u000b\u0003\u0005S\u0004bA!\u0012\u0003H\u0005%\u0016A\u0006*fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm\u001d\u0011\u0002\u001b\rdW-\u00198fe\u000e{gNZ5h)\rq&\u0011\u001f\u0005\b\u0003\u0007R\u0004\u0019\u0001B*\u0003]\u0019'/Z1uK:+wo\u00117fC:,GmU3h[\u0016tG\u000f\u0006\u0004\u0003x\nu(q \t\u0004?\ne\u0018b\u0001B~\u007f\tQAj\\4TK\u001elWM\u001c;\t\r\u0001[\u0004\u0019AA\n\u0011\u001d\u0019\ta\u000fa\u0001\u0005W\t!BY1tK>3gm]3u\u0003]\u0019\u0017\r\\2vY\u0006$Xm\u00117fC:\f'\r\\3CsR,7\u000f\u0006\u0005\u0004\b\r%11BB\b!\u001d1%1\u001bB\u0016\u0005WAa\u0001\u0011\u001fA\u0002\u0005M\u0001bBB\u0007y\u0001\u0007!1F\u0001\u0011M&\u00148\u000f\u001e#jeRLxJ\u001a4tKRDqa!\u0005=\u0001\u0004\u0011Y#A\tv]\u000edW-\u00198bE2,wJ\u001a4tKR\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TCAB\fU\u0011\tIC!/")
public class LogCleaner
implements KafkaMetricsGroup,
BrokerReconfigurable {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, Log> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private volatile CleanerConfig kafka$log$LogCleaner$$config;
    private final LogCleanerManager cleanerManager;
    private final Throttler kafka$log$LogCleaner$$throttler;
    private final ArrayBuffer<CleanerThread> kafka$log$LogCleaner$$cleaners;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return LogCleaner$.MODULE$.$lessinit$greater$default$5();
    }

    public static Tuple2<Object, Object> calculateCleanableBytes(Log log, long l, long l2) {
        return LogCleaner$.MODULE$.calculateCleanableBytes(log, l, l2);
    }

    public static LogSegment createNewCleanedSegment(Log log, long l) {
        return LogCleaner$.MODULE$.createNewCleanedSegment(log, l);
    }

    public static CleanerConfig cleanerConfig(KafkaConfig kafkaConfig) {
        return LogCleaner$.MODULE$.cleanerConfig(kafkaConfig);
    }

    public static Set<String> ReconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogCleaner logCleaner = this;
        synchronized (logCleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public CleanerConfig kafka$log$LogCleaner$$config() {
        return this.kafka$log$LogCleaner$$config;
    }

    private void kafka$log$LogCleaner$$config_$eq(CleanerConfig x$1) {
        this.kafka$log$LogCleaner$$config = x$1;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler kafka$log$LogCleaner$$throttler() {
        return this.kafka$log$LogCleaner$$throttler;
    }

    public ArrayBuffer<CleanerThread> kafka$log$LogCleaner$$cleaners() {
        return this.kafka$log$LogCleaner$$cleaners;
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting the log cleaner");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$log$LogCleaner$$config().numThreads()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            CleanerThread cleaner = new CleanerThread(i);
            this.kafka$log$LogCleaner$$cleaners().$plus$eq((Object)cleaner);
            cleaner.start();
        });
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down the log cleaner.");
        this.kafka$log$LogCleaner$$cleaners().foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.shutdown();
            return BoxedUnit.UNIT;
        });
        this.kafka$log$LogCleaner$$cleaners().clear();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        CleanerConfig newCleanerConfig = LogCleaner$.MODULE$.cleanerConfig(newConfig);
        int numThreads = newCleanerConfig.numThreads();
        int currentThreads = this.kafka$log$LogCleaner$$config().numThreads();
        if (numThreads < 1) {
            throw new ConfigException("Log cleaner threads should be at least 1");
        }
        if (numThreads < currentThreads / 2) {
            throw new ConfigException(new StringBuilder(74).append("Log cleaner threads cannot be reduced to less than half the current value ").append(currentThreads).toString());
        }
        if (numThreads > currentThreads * 2) {
            throw new ConfigException(new StringBuilder(78).append("Log cleaner threads cannot be increased to more than double the current value ").append(currentThreads).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.kafka$log$LogCleaner$$config_$eq(LogCleaner$.MODULE$.cleanerConfig(newConfig));
        this.shutdown();
        this.startup();
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir) {
        this.cleanerManager().updateCheckpoints(dataDir, (Option<Tuple2<TopicPartition, Object>>)None$.MODULE$);
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        this.cleanerManager().alterCheckpointDir(topicPartition, sourceLogDir, destLogDir);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        this.cleanerManager().resumeCleaning(topicPartitions);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public Iterable<Tuple2<TopicPartition, Log>> pauseCleaningForNonCompactedPartitions() {
        return this.cleanerManager().pauseCleaningForNonCompactedPartitions();
    }

    public CleanerConfig currentConfig() {
        return this.kafka$log$LogCleaner$$config();
    }

    public int cleanerCount() {
        return this.kafka$log$LogCleaner$$cleaners().size();
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$11 -> x$11 >= offset$1));
    }

    public LogCleaner(CleanerConfig initialConfig, Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.kafka$log$LogCleaner$$config = initialConfig;
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.kafka$log$LogCleaner$$throttler = new Throttler(this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond(), 300L, true, "cleaner-io", "bytes", time);
        this.kafka$log$LogCleaner$$cleaners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.newGauge("max-buffer-utilization-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.lastStats(), ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)$anon$1.$anonfun$value$2(x$2)), ArrayBuffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }

            public static final /* synthetic */ double $anonfun$value$2(CleanerStats x$2) {
                return (double)100 * x$2.bufferUtilization();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$2$adapted(kafka.log.CleanerStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.newGauge("cleaner-recopy-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                ArrayBuffer stats = (ArrayBuffer)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.lastStats(), ArrayBuffer$.MODULE$.canBuildFrom());
                double recopyRate = (double)BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)$anon$2.$anonfun$value$4(x$4)), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)$anon$2.$anonfun$value$5(x$5)), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
                return (int)((double)100 * recopyRate);
            }

            public static final /* synthetic */ long $anonfun$value$4(CleanerStats x$4) {
                return x$4.bytesWritten();
            }

            public static final /* synthetic */ long $anonfun$value$5(CleanerStats x$5) {
                return x$5.bytesRead();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$3(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$4$adapted(kafka.log.CleanerStats ), $anonfun$value$5$adapted(kafka.log.CleanerStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.newGauge("max-clean-time-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.lastStats(), ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToDouble((double)$anon$3.$anonfun$value$7(x$7)), ArrayBuffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }

            public static final /* synthetic */ double $anonfun$value$7(CleanerStats x$7) {
                return x$7.elapsedSecs();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$6(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$7$adapted(kafka.log.CleanerStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.newGauge("max-compaction-delay-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return Math.max(0, (int)(BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.lastPreCleanStats(), ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)$anon$4.$anonfun$value$9(x$9)), ArrayBuffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)) / 1000L));
            }

            public static final /* synthetic */ long $anonfun$value$9(PreCleanStats x$9) {
                return x$9.maxCompactionDelayMs();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$8(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$9$adapted(kafka.log.PreCleanStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
    }

    public class CleanerThread
    extends ShutdownableThread {
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private volatile PreCleanStats lastPreCleanStats;

        @Override
        public String loggerName() {
            return LogCleaner.class.getName();
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        public PreCleanStats lastPreCleanStats() {
            return this.lastPreCleanStats;
        }

        public void lastPreCleanStats_$eq(PreCleanStats x$1) {
            this.lastPreCleanStats = x$1;
        }

        private void checkDone(TopicPartition topicPartition) {
            if (!this.isRunning()) {
                throw new ThreadShutdownException();
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
        }

        @Override
        public void doWork() {
            block0: {
                boolean cleaned = this.cleanFilthiestLog();
                if (cleaned) break block0;
                this.pause(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().backOffMs(), TimeUnit.MILLISECONDS);
            }
        }

        private boolean cleanFilthiestLog() {
            boolean bl;
            ObjectRef currentLog = ObjectRef.create((Object)None$.MODULE$);
            try {
                boolean bl2;
                PreCleanStats preCleanStats = new PreCleanStats();
                Option<LogToClean> option = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time, preCleanStats);
                if (None$.MODULE$.equals(option)) {
                    bl2 = false;
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    LogToClean cleanable = (LogToClean)some.value();
                    this.lastPreCleanStats_$eq(preCleanStats);
                    currentLog.elem = new Some((Object)cleanable.log());
                    this.cleanLog(cleanable);
                    bl2 = true;
                } else {
                    throw new MatchError(option);
                }
                boolean cleaned = bl2;
                Iterable<Tuple2<TopicPartition, Log>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
                try {
                    deletable.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)CleanerThread.$anonfun$cleanFilthiestLog$1(currentLog, x0$1)));
                }
                finally {
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)deletable.map((Function1 & Serializable & scala.Serializable)x$12 -> (TopicPartition)x$12._1(), Iterable$.MODULE$.canBuildFrom())));
                }
                bl = cleaned;
            }
            catch (Throwable throwable) {
                Exception exception;
                Throwable throwable2 = throwable;
                boolean bl3 = throwable2 instanceof ThreadShutdownException ? true : throwable2 instanceof ControlThrowable;
                if (bl3) {
                    throw throwable2;
                }
                if (throwable2 instanceof Exception) {
                    exception = (Exception)throwable2;
                    if (((Option)currentLog.elem).isEmpty()) {
                        throw new IllegalStateException("currentLog cannot be empty on an unexpected exception", exception);
                    }
                } else {
                    throw throwable;
                }
                Log erroneousLog = (Log)((Option)currentLog.elem).get();
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Unexpected exception thrown when cleaning log ").append(erroneousLog).append(". Marking its partition (").append(erroneousLog.topicPartition()).append(") as uncleanable").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> exception);
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().markPartitionUncleanable(erroneousLog.dir().getParent(), erroneousLog.topicPartition());
                boolean bl4 = false;
                bl = bl4;
            }
            return bl;
        }

        private void cleanLog(LogToClean cleanable) {
            long endOffset = cleanable.firstDirtyOffset();
            try {
                try {
                    Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    long nextDirtyOffset = tuple2._1$mcJ$sp();
                    CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)nextDirtyOffset), (Object)cleanerStats);
                    Tuple2 tuple23 = tuple22;
                    long nextDirtyOffset2 = tuple23._1$mcJ$sp();
                    CleanerStats cleanerStats2 = (CleanerStats)tuple23._2();
                    this.recordStats(this.cleaner().id(), cleanable.log().name(), cleanable.firstDirtyOffset(), endOffset, cleanerStats2);
                    endOffset = nextDirtyOffset2;
                }
                catch (LogCleaningAbortedException logCleaningAbortedException) {
                }
                catch (KafkaStorageException kafkaStorageException) {
                }
                catch (IOException e) {
                    String logDirectory = cleanable.log().dir().getParent();
                    String msg = new StringBuilder(54).append("Failed to clean up log for ").append(cleanable.topicPartition()).append(" in dir ").append(logDirectory).append(" due to IOException").toString();
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(logDirectory, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg, e);
                }
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
            }
        }

        public void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            block1: {
                this.lastStats_$eq(stats);
                String message = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)CleanerThread.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append(new StringOps(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                if (this.lastPreCleanStats().delayedPartitions() > 0) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\tCleanable partitions: %d, Delayed partitions: %d, max delay: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().cleanablePartitions()), BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().delayedPartitions()), BoxesRunTime.boxToLong((long)this.lastPreCleanStats().maxCompactionDelayMs())})));
                }
                if (stats.invalidMessagesRead() <= 0L) break block1;
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())})));
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        public static final /* synthetic */ int $anonfun$cleanFilthiestLog$1(ObjectRef currentLog$1, Tuple2 x0$1) {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Log log = (Log)tuple2._2();
            currentLog$1.elem = new Some((Object)log);
            int n = log.deleteOldSegments();
            return n;
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringBuilder(25).append("kafka-log-cleaner-thread-").append(threadId).toString(), false);
            if (LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...");
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads(), Integer.MAX_VALUE), LogCleaner.this.kafka$log$LogCleaner$$config().hashAlgorithm()), LogCleaner.this.kafka$log$LogCleaner$$config().ioBufferSize() / LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() / 2, LogCleaner.this.kafka$log$LogCleaner$$config().maxMessageSize(), LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferLoadFactor(), LogCleaner.this.kafka$log$LogCleaner$$throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable & scala.Serializable)topicPartition -> {
                this.checkDone(topicPartition);
                return BoxedUnit.UNIT;
            });
            this.lastStats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
            this.lastPreCleanStats = new PreCleanStats();
        }
    }
}

