/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.BuildFailureException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.InvalidPluginException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.version.PluginVersionNotFoundException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.plugins.enforcer.utils.EnforcerRuleUtils;
import org.apache.maven.plugins.enforcer.utils.PluginWrapper;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.ReflectionUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class RequirePluginVersions
extends AbstractNonCacheableEnforcerRule {
    private EnforcerRuleHelper helper;
    private boolean banLatest = true;
    private boolean banRelease = true;
    private boolean banSnapshots = true;
    private boolean banTimestamps = true;
    private String phases = "clean,deploy,site";
    private List<String> additionalPlugins;
    private List<String> unCheckedPlugins;
    private String unCheckedPluginList;
    private PluginManager pluginManager;
    private Map<String, Lifecycle> phaseToLifecycleMap;
    private Collection<Lifecycle> lifecycles;
    ArtifactFactory factory;
    ArtifactResolver resolver;
    ArtifactRepository local;
    List<ArtifactRepository> remoteRepositories;
    Log log;
    MavenSession session;
    EnforcerRuleUtils utils;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        block25: {
            this.log = helper.getLog();
            this.helper = helper;
            try {
                MavenProject project = (MavenProject)helper.evaluate("${project}");
                LifecycleExecutor life = (LifecycleExecutor)helper.getComponent(LifecycleExecutor.class);
                Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)"defaultLifeCycles", life.getClass());
                if (field != null) {
                    Object defaultLifeCycles = ReflectionUtils.getValueIncludingSuperclasses((String)"defaultLifeCycles", (Object)life);
                    Map lifecyclesMap = (Map)ReflectionUtils.getValueIncludingSuperclasses((String)"lifecycles", (Object)defaultLifeCycles);
                    this.lifecycles = lifecyclesMap.values();
                } else {
                    this.lifecycles = (Collection)ReflectionUtils.getValueIncludingSuperclasses((String)"lifecycles", (Object)life);
                }
                this.session = (MavenSession)helper.evaluate("${session}");
                this.pluginManager = (PluginManager)helper.getComponent(PluginManager.class);
                this.factory = (ArtifactFactory)helper.getComponent(ArtifactFactory.class);
                this.resolver = (ArtifactResolver)helper.getComponent(ArtifactResolver.class);
                this.local = (ArtifactRepository)helper.evaluate("${localRepository}");
                this.remoteRepositories = project.getRemoteArtifactRepositories();
                this.utils = new EnforcerRuleUtils(helper);
                Set<Plugin> allPlugins = this.getBoundPlugins(life, project, this.phases);
                allPlugins = this.addAdditionalPlugins(allPlugins, this.additionalPlugins);
                allPlugins.addAll(this.getProfilePlugins(project));
                allPlugins = this.removeUncheckedPlugins(this.combineUncheckedPlugins(this.unCheckedPlugins, this.unCheckedPluginList), allPlugins);
                if (allPlugins.isEmpty()) {
                    this.log.info((CharSequence)"No plugin bindings found.");
                    return;
                }
                this.log.debug((CharSequence)("All Plugins in use: " + allPlugins));
                List<PluginWrapper> pluginWrappers = this.getAllPluginEntries(project);
                ArrayList<Plugin> failures = new ArrayList<Plugin>();
                for (Plugin plugin : allPlugins) {
                    if (this.hasValidVersionSpecified(helper, plugin, pluginWrappers)) continue;
                    failures.add(plugin);
                }
                if (failures.isEmpty()) break block25;
                StringBuilder newMsg = new StringBuilder();
                newMsg.append("Some plugins are missing valid versions:");
                if (this.banLatest || this.banRelease || this.banSnapshots || this.banTimestamps) {
                    newMsg.append("(");
                    if (this.banLatest) {
                        newMsg.append("LATEST ");
                    }
                    if (this.banRelease) {
                        newMsg.append("RELEASE ");
                    }
                    if (this.banSnapshots || this.banTimestamps) {
                        newMsg.append("SNAPSHOT ");
                    }
                    newMsg.append("are not allowed )\n");
                }
                for (Plugin plugin : failures) {
                    newMsg.append(plugin.getGroupId());
                    newMsg.append(":");
                    newMsg.append(plugin.getArtifactId());
                    try {
                        newMsg.append(". \tThe version currently in use is ");
                        Plugin currentPlugin = this.findCurrentPlugin(plugin, project);
                        if (currentPlugin != null) {
                            newMsg.append(currentPlugin.getVersion());
                        } else {
                            newMsg.append("unknown");
                        }
                    }
                    catch (Exception e) {
                        this.log.debug((CharSequence)"Exception while determining plugin Version.", (Throwable)e);
                        newMsg.append(". Unable to determine the plugin version.");
                    }
                    newMsg.append("\n");
                }
                String string = this.getMessage();
                if (StringUtils.isNotEmpty((String)string)) {
                    newMsg.append(string);
                }
                throw new EnforcerRuleException(newMsg.toString());
            }
            catch (ExpressionEvaluationException e) {
                throw new EnforcerRuleException("Unable to Evaluate an Expression:" + e.getLocalizedMessage());
            }
            catch (ComponentLookupException e) {
                throw new EnforcerRuleException("Unable to lookup a component:" + e.getLocalizedMessage());
            }
            catch (IllegalAccessException e) {
                throw new EnforcerRuleException(e.getLocalizedMessage());
            }
            catch (LifecycleExecutionException e) {
                throw new EnforcerRuleException(e.getLocalizedMessage());
            }
            catch (PluginNotFoundException e) {
                throw new EnforcerRuleException(e.getLocalizedMessage());
            }
            catch (ArtifactResolutionException e) {
                throw new EnforcerRuleException(e.getLocalizedMessage());
            }
            catch (ArtifactNotFoundException e) {
                throw new EnforcerRuleException(e.getLocalizedMessage());
            }
            catch (IOException e) {
                throw new EnforcerRuleException(e.getLocalizedMessage());
            }
            catch (XmlPullParserException e) {
                throw new EnforcerRuleException(e.getLocalizedMessage());
            }
            catch (MojoExecutionException e) {
                throw new EnforcerRuleException(e.getLocalizedMessage());
            }
        }
    }

    public Set<Plugin> removeUncheckedPlugins(Collection<String> uncheckedPlugins, Set<Plugin> plugins) throws MojoExecutionException {
        if (uncheckedPlugins != null && !uncheckedPlugins.isEmpty()) {
            for (String pluginKey : uncheckedPlugins) {
                Plugin plugin = this.parsePluginString(pluginKey, "UncheckedPlugins");
                plugins.remove(plugin);
            }
        }
        return plugins;
    }

    public Collection<String> combineUncheckedPlugins(Collection<String> uncheckedPlugins, String uncheckedPluginsList) {
        if (StringUtils.isNotEmpty((String)uncheckedPluginsList)) {
            if (uncheckedPlugins == null) {
                uncheckedPlugins = new HashSet<String>();
            } else if (!uncheckedPlugins.isEmpty() && this.log != null) {
                this.log.warn((CharSequence)"The parameter 'unCheckedPlugins' is deprecated. Use 'unCheckedPluginList' instead");
            }
            uncheckedPlugins.addAll(Arrays.asList(uncheckedPluginsList.split(",")));
        }
        return uncheckedPlugins;
    }

    public Set<Plugin> addAdditionalPlugins(Set<Plugin> existing, List<String> additional) throws MojoExecutionException {
        if (additional != null) {
            for (String pluginString : additional) {
                Plugin plugin = this.parsePluginString(pluginString, "AdditionalPlugins");
                if (existing == null) {
                    existing = new HashSet<Plugin>();
                    existing.add(plugin);
                    continue;
                }
                if (existing.contains(plugin)) continue;
                existing.add(plugin);
            }
        }
        return existing;
    }

    protected Plugin parsePluginString(String pluginString, String field) throws MojoExecutionException {
        if (pluginString != null) {
            String[] pluginStrings = pluginString.split(":");
            if (pluginStrings.length == 2) {
                Plugin plugin = new Plugin();
                plugin.setGroupId(StringUtils.strip((String)pluginStrings[0]));
                plugin.setArtifactId(StringUtils.strip((String)pluginStrings[1]));
                return plugin;
            }
            throw new MojoExecutionException("Invalid " + field + " string: " + pluginString);
        }
        throw new MojoExecutionException("Invalid " + field + " string: " + pluginString);
    }

    public Set<Plugin> getProfilePlugins(MavenProject project) {
        HashSet<Plugin> result = new HashSet<Plugin>();
        List profiles = project.getActiveProfiles();
        if (profiles != null && !profiles.isEmpty()) {
            for (Profile p : profiles) {
                List plugins;
                BuildBase b = p.getBuild();
                if (b == null || (plugins = b.getPlugins()) == null) continue;
                result.addAll(plugins);
            }
        }
        return result;
    }

    protected Plugin findCurrentPlugin(Plugin plugin, MavenProject project) {
        Plugin found = null;
        try {
            Model model = project.getModel();
            Map plugins = model.getBuild().getPluginsAsMap();
            found = (Plugin)plugins.get(plugin.getKey());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (found == null) {
            found = this.resolvePlugin(plugin, project);
        }
        return found;
    }

    protected Plugin resolvePlugin(Plugin plugin, MavenProject project) {
        List pluginRepositories = project.getPluginArtifactRepositories();
        Artifact artifact = this.factory.createPluginArtifact(plugin.getGroupId(), plugin.getArtifactId(), VersionRange.createFromVersion((String)"LATEST"));
        try {
            this.resolver.resolve(artifact, pluginRepositories, this.local);
            plugin.setVersion(artifact.getVersion());
        }
        catch (ArtifactResolutionException artifactResolutionException) {
        }
        catch (ArtifactNotFoundException artifactNotFoundException) {
            // empty catch block
        }
        return plugin;
    }

    protected Set<Plugin> getBoundPlugins(LifecycleExecutor life, MavenProject project, String thePhases) throws PluginNotFoundException, LifecycleExecutionException, IllegalAccessException {
        HashSet<Plugin> allPlugins = new HashSet<Plugin>();
        String[] lifecyclePhases = thePhases.split(",");
        for (int i = 0; i < lifecyclePhases.length; ++i) {
            String lifecyclePhase = lifecyclePhases[i];
            if (!StringUtils.isNotEmpty((String)lifecyclePhase)) continue;
            try {
                Lifecycle lifecycle = this.getLifecycleForPhase(lifecyclePhase);
                allPlugins.addAll(this.getAllPlugins(project, lifecycle));
                continue;
            }
            catch (BuildFailureException buildFailureException) {
                // empty catch block
            }
        }
        return allPlugins;
    }

    protected boolean hasValidVersionSpecified(EnforcerRuleHelper helper, Plugin source, List<PluginWrapper> pluginWrappers) {
        boolean found = false;
        boolean status = false;
        for (PluginWrapper plugin : pluginWrappers) {
            if (!source.getArtifactId().equals(plugin.getArtifactId()) || !source.getGroupId().equals(plugin.getGroupId())) continue;
            found = true;
            String version = plugin.getVersion();
            try {
                version = (String)helper.evaluate(version);
            }
            catch (ExpressionEvaluationException e) {
                return false;
            }
            if (!StringUtils.isNotEmpty((String)version) || StringUtils.isWhitespace((String)version)) continue;
            if (this.banRelease && version.equals("RELEASE")) {
                return false;
            }
            if (this.banLatest && version.equals("LATEST")) {
                return false;
            }
            if (this.banSnapshots && this.isSnapshot(version)) {
                return false;
            }
            status = true;
            if (this.banRelease || this.banLatest || this.banSnapshots) continue;
            break;
        }
        if (!found) {
            this.log.debug((CharSequence)("plugin " + source.getGroupId() + ":" + source.getArtifactId() + " not found"));
        }
        return status;
    }

    protected boolean isSnapshot(String baseVersion) {
        if (this.banTimestamps) {
            return Artifact.VERSION_FILE_PATTERN.matcher(baseVersion).matches() || baseVersion.endsWith("SNAPSHOT");
        }
        return baseVersion.endsWith("SNAPSHOT");
    }

    private Set<Plugin> getAllPlugins(MavenProject project, Lifecycle lifecycle) throws PluginNotFoundException, LifecycleExecutionException {
        this.log.debug((CharSequence)"RequirePluginVersions.getAllPlugins:");
        HashSet<Plugin> plugins = new HashSet<Plugin>();
        Map<String, String> mappings = this.findMappingsForLifecycle(project, lifecycle);
        for (Map.Entry<String, String> entry : mappings.entrySet()) {
            String[] pluginList;
            this.log.debug((CharSequence)("  lifecycleMapping = " + entry.getKey()));
            String pluginsForLifecycle = entry.getValue();
            this.log.debug((CharSequence)("  plugins = " + pluginsForLifecycle));
            if (!StringUtils.isNotEmpty((String)pluginsForLifecycle)) continue;
            for (String plugin : pluginList = pluginsForLifecycle.split(",")) {
                plugin = StringUtils.strip((String)plugin);
                this.log.debug((CharSequence)("    plugin = " + plugin));
                String[] tokens = plugin.split(":");
                this.log.debug((CharSequence)("    GAV = " + Arrays.asList(tokens)));
                Plugin p = new Plugin();
                p.setGroupId(tokens[0]);
                p.setArtifactId(tokens[1]);
                plugins.add(p);
            }
        }
        List<String> mojos = this.findOptionalMojosForLifecycle(project, lifecycle);
        for (String value : mojos) {
            String[] tokens = value.split(":");
            Plugin plugin = new Plugin();
            plugin.setGroupId(tokens[0]);
            plugin.setArtifactId(tokens[1]);
            plugins.add(plugin);
        }
        plugins.addAll(project.getBuildPlugins());
        return plugins;
    }

    public Map<String, Lifecycle> getPhaseToLifecycleMap() throws LifecycleExecutionException {
        if (this.phaseToLifecycleMap == null) {
            this.phaseToLifecycleMap = new HashMap<String, Lifecycle>();
            for (Lifecycle lifecycle : this.lifecycles) {
                List phases = lifecycle.getPhases();
                for (String phase : phases) {
                    if (this.phaseToLifecycleMap.containsKey(phase)) {
                        Lifecycle prevLifecycle = this.phaseToLifecycleMap.get(phase);
                        throw new LifecycleExecutionException("Phase '" + phase + "' is defined in more than one lifecycle: '" + lifecycle.getId() + "' and '" + prevLifecycle.getId() + "'");
                    }
                    this.phaseToLifecycleMap.put(phase, lifecycle);
                }
            }
        }
        return this.phaseToLifecycleMap;
    }

    private Lifecycle getLifecycleForPhase(String phase) throws BuildFailureException, LifecycleExecutionException {
        Lifecycle lifecycle = this.getPhaseToLifecycleMap().get(phase);
        if (lifecycle == null) {
            throw new BuildFailureException("Unable to find lifecycle for phase '" + phase + "'");
        }
        return lifecycle;
    }

    private Map<String, String> findMappingsForLifecycle(MavenProject project, Lifecycle lifecycle) throws LifecycleExecutionException, PluginNotFoundException {
        Map defaultMappings;
        Map mappings;
        String packaging;
        block6: {
            packaging = project.getPackaging();
            mappings = null;
            LifecycleMapping m = (LifecycleMapping)this.findExtension(project, LifecycleMapping.ROLE, packaging, this.session.getSettings(), this.session.getLocalRepository());
            if (m != null) {
                mappings = m.getPhases(lifecycle.getId());
            }
            defaultMappings = lifecycle.getDefaultPhases();
            if (mappings == null) {
                try {
                    m = (LifecycleMapping)this.helper.getComponent(LifecycleMapping.class, packaging);
                    mappings = m.getPhases(lifecycle.getId());
                }
                catch (ComponentLookupException e) {
                    if (defaultMappings != null) break block6;
                    throw new LifecycleExecutionException("Cannot find lifecycle mapping for packaging: '" + packaging + "'.", (Throwable)e);
                }
            }
        }
        if (mappings == null) {
            if (defaultMappings == null) {
                throw new LifecycleExecutionException("Cannot find lifecycle mapping for packaging: '" + packaging + "', and there is no default");
            }
            mappings = defaultMappings;
        }
        return mappings;
    }

    private List<String> findOptionalMojosForLifecycle(MavenProject project, Lifecycle lifecycle) throws LifecycleExecutionException, PluginNotFoundException {
        String packaging = project.getPackaging();
        List optionalMojos = null;
        LifecycleMapping m = (LifecycleMapping)this.findExtension(project, LifecycleMapping.ROLE, packaging, this.session.getSettings(), this.session.getLocalRepository());
        if (m != null) {
            optionalMojos = m.getOptionalMojos(lifecycle.getId());
        }
        if (optionalMojos == null) {
            try {
                m = (LifecycleMapping)this.helper.getComponent(LifecycleMapping.class, packaging);
                optionalMojos = m.getOptionalMojos(lifecycle.getId());
            }
            catch (ComponentLookupException e) {
                this.log.debug((CharSequence)("Error looking up lifecycle mapping to retrieve optional mojos. Lifecycle ID: " + lifecycle.getId() + ". Error: " + e.getMessage()), (Throwable)e);
            }
        }
        if (optionalMojos == null) {
            optionalMojos = Collections.emptyList();
        }
        return optionalMojos;
    }

    private Object findExtension(MavenProject project, String role, String roleHint, Settings settings, ArtifactRepository localRepository) throws LifecycleExecutionException, PluginNotFoundException {
        Object pluginComponent = null;
        List buildPlugins = project.getBuildPlugins();
        for (Plugin plugin : buildPlugins) {
            if (!plugin.isExtensions()) continue;
            this.verifyPlugin(plugin, project, settings, localRepository);
            try {
                pluginComponent = this.pluginManager.getPluginComponent(plugin, role, roleHint);
                if (pluginComponent == null) continue;
                break;
            }
            catch (ComponentLookupException e) {
                this.log.debug((CharSequence)"Unable to find the lifecycle component in the extension", (Throwable)e);
            }
            catch (PluginManagerException e) {
                throw new LifecycleExecutionException("Error getting extensions from the plugin '" + plugin.getKey() + "': " + e.getMessage(), (Throwable)e);
            }
        }
        return pluginComponent;
    }

    private PluginDescriptor verifyPlugin(Plugin plugin, MavenProject project, Settings settings, ArtifactRepository localRepository) throws LifecycleExecutionException, PluginNotFoundException {
        PluginDescriptor pluginDescriptor;
        try {
            pluginDescriptor = this.pluginManager.verifyPlugin(plugin, project, settings, localRepository);
        }
        catch (PluginManagerException e) {
            throw new LifecycleExecutionException("Internal error in the plugin manager getting plugin '" + plugin.getKey() + "': " + e.getMessage(), (Throwable)e);
        }
        catch (PluginVersionResolutionException e) {
            throw new LifecycleExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new LifecycleExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidPluginException e) {
            throw new LifecycleExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            throw new LifecycleExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (ArtifactResolutionException e) {
            throw new LifecycleExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (PluginVersionNotFoundException e) {
            throw new LifecycleExecutionException(e.getMessage(), (Throwable)e);
        }
        return pluginDescriptor;
    }

    protected List<PluginWrapper> getAllPluginEntries(MavenProject project) throws ArtifactResolutionException, ArtifactNotFoundException, IOException, XmlPullParserException {
        ArrayList<PluginWrapper> plugins = new ArrayList<PluginWrapper>();
        ArrayList<Model> models = new ArrayList<Model>();
        List sortedProjects = this.session.getProjectDependencyGraph().getSortedProjects();
        for (MavenProject mavenProject : sortedProjects) {
            models.add(mavenProject.getOriginalModel());
        }
        for (Model model : models) {
            List modelPlugins2;
            try {
                modelPlugins2 = model.getBuild().getPlugins();
                plugins.addAll(PluginWrapper.addAll(this.utils.resolvePlugins(modelPlugins2), model.getId() + ".build.plugins"));
            }
            catch (NullPointerException modelPlugins2) {
                // empty catch block
            }
            try {
                List modelReportPlugins = model.getReporting().getPlugins();
                plugins.addAll(PluginWrapper.addAll(this.utils.resolveReportPlugins(modelReportPlugins), model.getId() + ".reporting"));
            }
            catch (NullPointerException modelReportPlugins) {
                // empty catch block
            }
            try {
                modelPlugins2 = model.getBuild().getPluginManagement().getPlugins();
                plugins.addAll(PluginWrapper.addAll(this.utils.resolvePlugins(modelPlugins2), model.getId() + ".build.pluginManagement.plugins"));
            }
            catch (NullPointerException modelPlugins3) {
                // empty catch block
            }
            List profiles = model.getProfiles();
            for (Profile profile : profiles) {
                List modelPlugins42;
                try {
                    modelPlugins42 = profile.getBuild().getPlugins();
                    plugins.addAll(PluginWrapper.addAll(this.utils.resolvePlugins(modelPlugins42), model.getId() + ".profiles.profile[" + profile.getId() + "].build.plugins"));
                }
                catch (NullPointerException modelPlugins42) {
                    // empty catch block
                }
                try {
                    List modelReportPlugins = profile.getReporting().getPlugins();
                    plugins.addAll(PluginWrapper.addAll(this.utils.resolveReportPlugins(modelReportPlugins), model.getId() + "profile[" + profile.getId() + "].reporting.plugins"));
                }
                catch (NullPointerException modelReportPlugins) {
                    // empty catch block
                }
                try {
                    modelPlugins42 = profile.getBuild().getPluginManagement().getPlugins();
                    plugins.addAll(PluginWrapper.addAll(this.utils.resolvePlugins(modelPlugins42), model.getId() + "profile[" + profile.getId() + "].build.pluginManagement.plugins"));
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
        return plugins;
    }

    protected boolean isBanLatest() {
        return this.banLatest;
    }

    protected void setBanLatest(boolean theBanLatest) {
        this.banLatest = theBanLatest;
    }

    protected boolean isBanRelease() {
        return this.banRelease;
    }

    protected void setBanRelease(boolean theBanRelease) {
        this.banRelease = theBanRelease;
    }

    protected EnforcerRuleUtils getUtils() {
        return this.utils;
    }

    protected void setUtils(EnforcerRuleUtils theUtils) {
        this.utils = theUtils;
    }

    public boolean isBanSnapshots() {
        return this.banSnapshots;
    }

    public void setBanSnapshots(boolean theBanSnapshots) {
        this.banSnapshots = theBanSnapshots;
    }

    public boolean isBanTimestamps() {
        return this.banTimestamps;
    }

    public void setBanTimestamps(boolean theBanTimestamps) {
        this.banTimestamps = theBanTimestamps;
    }

    public List<String> getUnCheckedPlugins() {
        return this.unCheckedPlugins;
    }

    public void setUnCheckedPlugins(List<String> unCheckedPlugins) {
        this.unCheckedPlugins = unCheckedPlugins;
    }

    public final void setPhases(String phases) {
        this.phases = phases;
    }

    public final String getPhases() {
        return this.phases;
    }

    public final void setAdditionalPlugins(List<String> additionalPlugins) {
        this.additionalPlugins = additionalPlugins;
    }

    public final List<String> getAdditionalPlugins() {
        return this.additionalPlugins;
    }
}

