/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse;

import com.google.common.base.Optional;
import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.cache.ParsingResultCache;
import org.apache.shardingsphere.core.parse.old.parser.sql.SQLParserFactory;
import org.apache.shardingsphere.core.rule.EncryptRule;

public final class EncryptSQLParsingEngine {
    private final DatabaseType dbType;
    private final EncryptRule encryptRule;
    private final ShardingTableMetaData shardingTableMetaData;
    private final ParsingResultCache parsingResultCache;

    public EncryptSQLParsingEngine(DatabaseType dbType, EncryptRule encryptRule, ShardingTableMetaData shardingTableMetaData) {
        this.dbType = dbType;
        this.encryptRule = encryptRule;
        this.shardingTableMetaData = shardingTableMetaData;
        this.parsingResultCache = new ParsingResultCache();
    }

    public SQLStatement parse(boolean useCache, String sql) {
        Optional<SQLStatement> cachedSQLStatement = this.getSQLStatementFromCache(useCache, sql);
        if (cachedSQLStatement.isPresent()) {
            return (SQLStatement)cachedSQLStatement.get();
        }
        SQLStatement result = SQLParserFactory.newInstance(this.dbType, this.encryptRule, this.shardingTableMetaData, sql).parse();
        if (useCache) {
            this.parsingResultCache.put(sql, result);
        }
        return result;
    }

    private Optional<SQLStatement> getSQLStatementFromCache(boolean useCache, String sql) {
        return useCache ? Optional.fromNullable((Object)this.parsingResultCache.getSQLStatement(sql)) : Optional.absent();
    }
}

