/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse;

import java.beans.ConstructorProperties;
import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dal.DALStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dal.SetStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dcl.DCLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.ddl.DDLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.DMLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.DQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.SelectStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.tcl.TCLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.token.SchemaToken;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngineFactory;
import org.apache.shardingsphere.core.parse.old.lexer.dialect.mysql.MySQLKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Assist;
import org.apache.shardingsphere.core.parse.old.lexer.token.DefaultKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Keyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Symbol;
import org.apache.shardingsphere.core.parse.old.lexer.token.TokenType;
import org.apache.shardingsphere.core.parse.old.parser.dialect.mysql.statement.DescribeStatement;
import org.apache.shardingsphere.core.parse.old.parser.dialect.mysql.statement.ShowColumnsStatement;
import org.apache.shardingsphere.core.parse.old.parser.dialect.mysql.statement.ShowCreateTableStatement;
import org.apache.shardingsphere.core.parse.old.parser.dialect.mysql.statement.ShowDatabasesStatement;
import org.apache.shardingsphere.core.parse.old.parser.dialect.mysql.statement.ShowIndexStatement;
import org.apache.shardingsphere.core.parse.old.parser.dialect.mysql.statement.ShowOtherStatement;
import org.apache.shardingsphere.core.parse.old.parser.dialect.mysql.statement.ShowTableStatusStatement;
import org.apache.shardingsphere.core.parse.old.parser.dialect.mysql.statement.ShowTablesStatement;
import org.apache.shardingsphere.core.parse.old.parser.dialect.mysql.statement.UseStatement;
import org.apache.shardingsphere.core.parse.old.parser.exception.SQLParsingException;

public final class SQLJudgeEngine {
    private final String sql;

    public SQLStatement judge() {
        TokenType tokenType;
        LexerEngine lexerEngine = LexerEngineFactory.newInstance(DatabaseType.MySQL, this.sql);
        lexerEngine.nextToken();
        do {
            if ((tokenType = lexerEngine.getCurrentToken().getType()) instanceof Keyword) {
                if (DQLStatement.isDQL(tokenType)) {
                    return this.getDQLStatement();
                }
                if (DMLStatement.isDML(tokenType)) {
                    return this.getDMLStatement(tokenType);
                }
                if (TCLStatement.isTCL(tokenType)) {
                    return this.getTCLStatement();
                }
                if (DALStatement.isDAL(tokenType)) {
                    return this.getDALStatement(tokenType, lexerEngine);
                }
                lexerEngine.nextToken();
                TokenType secondaryTokenType = lexerEngine.getCurrentToken().getType();
                if (DDLStatement.isDDL(tokenType, secondaryTokenType)) {
                    return this.getDDLStatement();
                }
                if (DCLStatement.isDCL(tokenType, secondaryTokenType)) {
                    return this.getDCLStatement();
                }
                if (TCLStatement.isTCLUnsafe(DatabaseType.MySQL, tokenType, lexerEngine)) {
                    return this.getTCLStatement();
                }
                if (!DefaultKeyword.SET.equals(tokenType)) continue;
                return new SetStatement();
            }
            lexerEngine.nextToken();
        } while (!(tokenType instanceof Assist) || Assist.END != tokenType);
        throw new SQLParsingException("Unsupported SQL statement: [%s]", this.sql);
    }

    private SQLStatement getDQLStatement() {
        return new SelectStatement();
    }

    private SQLStatement getDMLStatement(TokenType tokenType) {
        if (DefaultKeyword.INSERT == tokenType) {
            return new InsertStatement();
        }
        return new DMLStatement();
    }

    private SQLStatement getDDLStatement() {
        return new DDLStatement();
    }

    private SQLStatement getDCLStatement() {
        return new DCLStatement();
    }

    private SQLStatement getTCLStatement() {
        return new TCLStatement();
    }

    private SQLStatement getDALStatement(TokenType tokenType, LexerEngine lexerEngine) {
        if (DefaultKeyword.USE == tokenType) {
            lexerEngine.nextToken();
            return new UseStatement(lexerEngine.getCurrentToken().getLiterals());
        }
        if (DefaultKeyword.DESC == tokenType || MySQLKeyword.DESCRIBE == tokenType) {
            return new DescribeStatement();
        }
        return this.getShowStatement(lexerEngine);
    }

    private SQLStatement getShowStatement(LexerEngine lexerEngine) {
        lexerEngine.nextToken();
        lexerEngine.skipIfEqual(DefaultKeyword.FULL);
        if (lexerEngine.equalAny(MySQLKeyword.DATABASES)) {
            return new ShowDatabasesStatement();
        }
        if (lexerEngine.skipIfEqual(DefaultKeyword.TABLE, MySQLKeyword.STATUS)) {
            return this.parseShowTableStatus(lexerEngine);
        }
        if (lexerEngine.skipIfEqual(MySQLKeyword.TABLES)) {
            return this.parseShowTables(lexerEngine);
        }
        if (lexerEngine.skipIfEqual(MySQLKeyword.COLUMNS, MySQLKeyword.FIELDS)) {
            return this.parseShowColumnsFields(lexerEngine);
        }
        if (lexerEngine.skipIfEqual(DefaultKeyword.CREATE) && lexerEngine.skipIfEqual(DefaultKeyword.TABLE)) {
            return this.parseShowCreateTable(lexerEngine);
        }
        if (lexerEngine.skipIfEqual(DefaultKeyword.INDEX, MySQLKeyword.INDEXES, MySQLKeyword.KEYS)) {
            return this.parseShowIndex(lexerEngine);
        }
        return new ShowOtherStatement();
    }

    private DALStatement parseShowTableStatus(LexerEngine lexerEngine) {
        ShowTableStatusStatement result = new ShowTableStatusStatement();
        lexerEngine.nextToken();
        if (lexerEngine.skipIfEqual(DefaultKeyword.FROM, DefaultKeyword.IN)) {
            int beginPosition = lexerEngine.getCurrentToken().getEndPosition() - lexerEngine.getCurrentToken().getLiterals().length();
            result.addSQLToken(new SchemaToken(beginPosition, lexerEngine.getCurrentToken().getEndPosition() - 1, null));
        }
        return result;
    }

    private DALStatement parseShowTables(LexerEngine lexerEngine) {
        ShowTablesStatement result = new ShowTablesStatement();
        if (lexerEngine.skipIfEqual(DefaultKeyword.FROM, DefaultKeyword.IN)) {
            int beginPosition = lexerEngine.getCurrentToken().getEndPosition() - lexerEngine.getCurrentToken().getLiterals().length();
            result.addSQLToken(new SchemaToken(beginPosition, lexerEngine.getCurrentToken().getEndPosition() - 1, null));
        }
        return result;
    }

    private DALStatement parseShowColumnsFields(LexerEngine lexerEngine) {
        ShowColumnsStatement result = new ShowColumnsStatement();
        lexerEngine.skipIfEqual(DefaultKeyword.FROM, DefaultKeyword.IN);
        this.parseSingleTableWithSchema(lexerEngine, result);
        if (lexerEngine.skipIfEqual(DefaultKeyword.FROM, DefaultKeyword.IN)) {
            int beginPosition = lexerEngine.getCurrentToken().getEndPosition() - lexerEngine.getCurrentToken().getLiterals().length();
            result.addSQLToken(new SchemaToken(beginPosition, lexerEngine.getCurrentToken().getEndPosition() - 1, null));
        }
        return result;
    }

    private DALStatement parseShowCreateTable(LexerEngine lexerEngine) {
        ShowCreateTableStatement result = new ShowCreateTableStatement();
        this.parseSingleTableWithSchema(lexerEngine, result);
        return result;
    }

    private DALStatement parseShowIndex(LexerEngine lexerEngine) {
        ShowIndexStatement result = new ShowIndexStatement();
        lexerEngine.skipIfEqual(DefaultKeyword.FROM, DefaultKeyword.IN);
        this.parseSingleTableWithSchema(lexerEngine, result);
        if (lexerEngine.skipIfEqual(DefaultKeyword.FROM, DefaultKeyword.IN)) {
            int beginPosition = lexerEngine.getCurrentToken().getEndPosition() - lexerEngine.getCurrentToken().getLiterals().length();
            result.addSQLToken(new SchemaToken(beginPosition, lexerEngine.getCurrentToken().getEndPosition() - 1, null));
        }
        return result;
    }

    private void parseSingleTableWithSchema(LexerEngine lexerEngine, SQLStatement sqlStatement) {
        int beginPosition = lexerEngine.getCurrentToken().getEndPosition() - lexerEngine.getCurrentToken().getLiterals().length();
        lexerEngine.nextToken();
        if (lexerEngine.skipIfEqual(Symbol.DOT)) {
            sqlStatement.addSQLToken(new SchemaToken(beginPosition, lexerEngine.getCurrentToken().getEndPosition() - 1, null));
            lexerEngine.nextToken();
        }
    }

    @ConstructorProperties(value={"sql"})
    public SQLJudgeEngine(String sql) {
        this.sql = sql;
    }
}

